/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout.gui;

import com.ibm.icu.text.BreakIterator;
import java.lang.ref.WeakReference;
import java.util.Objects;

public class CaxtonUtil {
    private static final ThreadLocal<BreakIterator> characterBreakIterator = ThreadLocal.withInitial(() -> BreakIterator.getCharacterInstance());
    private static final ThreadLocal<WeakReference<String>> lastQueriedString = ThreadLocal.withInitial(() -> null);

    public static int moveCursor(String string, int cursor, int delta) {
        Objects.requireNonNull(string);
        BreakIterator bi = characterBreakIterator.get();
        WeakReference<String> lqs = lastQueriedString.get();
        if (lqs == null || lqs.get() != string) {
            bi.setText(string);
            lastQueriedString.set(new WeakReference<String>(string));
        }
        if (delta > 0) {
            bi.following(cursor);
            bi.next(delta - 1);
        } else if (delta < 0) {
            bi.preceding(cursor);
            bi.next(delta + 1);
        }
        return bi.current();
    }
}

