/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.SpecialGlyphs;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.flirora.caxton.dll.LibraryLoading;
import xyz.flirora.caxton.font.CaxtonFontStorage;
import xyz.flirora.caxton.font.CaxtonGlyphPair;
import xyz.flirora.caxton.font.CaxtonGlyphResult;
import xyz.flirora.caxton.font.CaxtonTypeface;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={FontSet.class})
public abstract class FontStorageMixin
implements AutoCloseable,
CaxtonFontStorage {
    @Unique
    private Int2ObjectMap<CaxtonGlyphPair>[] caxtonGlyphCache = null;
    @Shadow
    @Final
    private List<GlyphProvider> f_95055_;
    @Shadow
    @Final
    private TextureManager f_95051_;

    @Shadow
    private static boolean m_243068_(GlyphInfo glyph) {
        throw new UnsupportedOperationException("this is a mixin, silly");
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/client/texture/TextureManager;Lnet/minecraft/util/Identifier;)V"})
    private void init(CallbackInfo ci) {
        this.caxtonGlyphCache = new Int2ObjectMap[4];
        for (int i = 0; i < 4; ++i) {
            this.caxtonGlyphCache[i] = new Int2ObjectOpenHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"setFonts(Ljava/util/List;)V"})
    private void onSetFonts(List<GlyphProvider> fonts, CallbackInfo ci) {
        Int2ObjectMap<CaxtonGlyphPair>[] int2ObjectMapArray = this.caxtonGlyphCache;
        int n = int2ObjectMapArray.length;
        for (int i = 0; i < n; ++i) {
            Int2ObjectMap<CaxtonGlyphPair> cacheEntry;
            Int2ObjectMap<CaxtonGlyphPair> int2ObjectMap = cacheEntry = int2ObjectMapArray[i];
            synchronized (int2ObjectMap) {
                cacheEntry.clear();
                continue;
            }
        }
    }

    @Unique
    private Int2ObjectMap<CaxtonGlyphPair> getCacheForStyle(Style style) {
        return this.caxtonGlyphCache[(style.m_131154_() ? 2 : 0) | (style.m_131161_() ? 1 : 0)];
    }

    @Redirect(method={"setFonts(Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;"))
    private Stream<GlyphProvider> filterProxy(Stream<GlyphProvider> allFonts, Predicate<GlyphProvider> predicate) {
        if (!LibraryLoading.isLibraryLoaded()) {
            return allFonts.filter(predicate);
        }
        return allFonts.filter(font -> {
            if (font instanceof CaxtonTypeface) {
                CaxtonTypeface c = (CaxtonTypeface)font;
                return true;
            }
            return predicate.test((GlyphProvider)font);
        });
    }

    @Unique
    private CaxtonGlyphPair findCaxtonGlyph(int codePoint, Style style) {
        GlyphInfo glyph = null;
        for (GlyphProvider font : this.f_95055_) {
            CaxtonTypeface caxtonFont;
            if (font instanceof CaxtonTypeface && (caxtonFont = (CaxtonTypeface)font).supportsCodePoint(codePoint, style)) {
                return new CaxtonGlyphPair.Caxton(caxtonFont.getFontByStyle(style));
            }
            GlyphInfo glyph2 = font.m_214022_(codePoint);
            if (glyph2 == null) continue;
            if (glyph == null) {
                glyph = glyph2;
            }
            if (FontStorageMixin.m_243068_(glyph2)) continue;
            return new CaxtonGlyphPair.Legacy(glyph, glyph2);
        }
        if (glyph != null) {
            return new CaxtonGlyphPair.Legacy(glyph, (GlyphInfo)SpecialGlyphs.MISSING);
        }
        return CaxtonGlyphPair.MISSING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaxtonGlyphResult getCaxtonGlyph(int codePoint, boolean validateAdvance, Style style) {
        Int2ObjectMap<CaxtonGlyphPair> cache;
        Int2ObjectMap<CaxtonGlyphPair> int2ObjectMap = cache = this.getCacheForStyle(style);
        synchronized (int2ObjectMap) {
            return ((CaxtonGlyphPair)cache.computeIfAbsent(codePoint, c -> this.findCaxtonGlyph(c, style))).getGlyph(validateAdvance);
        }
    }
}

