/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin;

import com.mojang.logging.LogUtils;
import java.util.function.BiConsumer;
import net.minecraft.client.StringSplitter;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.TextHandlerExt;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={StringSplitter.class})
public class TextHandlerMixin
implements TextHandlerExt {
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private CaxtonTextHandler caxtonTextHandler;

    @Override
    public CaxtonTextHandler getCaxtonTextHandler() {
        return this.caxtonTextHandler;
    }

    @Override
    public void setCaxtonTextHandler(CaxtonTextHandler handler) {
        this.caxtonTextHandler = handler;
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void onInit(StringSplitter.WidthProvider widthRetriever, CallbackInfo ci) {
        this.setCaxtonTextHandler(new CaxtonTextHandler(CaxtonTextHandler.EMPTY_FONT_STORAGE_ACCESSOR, (StringSplitter)this));
    }

    @Inject(at={@At(value="HEAD")}, method={"getWidth(Ljava/lang/String;)F"}, cancellable=true)
    private void onGetWidth(String text, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.caxtonTextHandler.getWidth(text)));
    }

    @Inject(at={@At(value="HEAD")}, method={"getWidth(Lnet/minecraft/text/StringVisitable;)F"}, cancellable=true)
    private void onGetWidth(FormattedText text, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.caxtonTextHandler.getWidth(text)));
    }

    @Inject(at={@At(value="HEAD")}, method={"getWidth(Lnet/minecraft/text/OrderedText;)F"}, cancellable=true)
    private void onGetWidth(FormattedCharSequence text, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.caxtonTextHandler.getWidth(text)));
    }

    @Inject(at={@At(value="HEAD")}, method={"getTrimmedLength"}, cancellable=true)
    private void onGetTrimmedLength(String text, int maxWidth, Style style, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.getCharIndexAtX(text, maxWidth, style));
    }

    @Inject(at={@At(value="HEAD")}, method={"trimToWidth(Ljava/lang/String;ILnet/minecraft/text/Style;)Ljava/lang/String;"})
    private void onTrimToWidth(String text, int maxWidth, Style style, CallbackInfoReturnable<String> cir) {
        CaxtonModClient.onBrokenMethod();
    }

    @Inject(at={@At(value="HEAD")}, method={"trimToWidthBackwards"})
    private void onTrimToWidthBackwards(String text, int maxWidth, Style style, CallbackInfoReturnable<String> cir) {
        CaxtonModClient.onBrokenMethod();
    }

    @Inject(at={@At(value="HEAD")}, method={"getLimitedStringLength"}, cancellable=true)
    private void onGetLimitedStringLength(String text, int maxWidth, Style style, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.getCharIndexAtXFormatted(text, maxWidth, style));
    }

    @Inject(at={@At(value="HEAD")}, method={"limitString"})
    private void onLimitString(String text, int maxWidth, Style style, CallbackInfoReturnable<String> cir) {
        CaxtonModClient.onBrokenMethod();
    }

    @Inject(at={@At(value="HEAD")}, method={"trimToWidth(Lnet/minecraft/text/StringVisitable;ILnet/minecraft/text/Style;)Lnet/minecraft/text/StringVisitable;"}, cancellable=true)
    private void onTrimToWidth(FormattedText text, int width, Style style, CallbackInfoReturnable<FormattedText> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.trimToWidth(text, width, style));
    }

    @Inject(at={@At(value="HEAD")}, method={"getStyleAt(Lnet/minecraft/text/StringVisitable;I)Lnet/minecraft/text/Style;"}, cancellable=true)
    private void onGetStyleAt(FormattedText text, int x, CallbackInfoReturnable<Style> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.getStyleAt(text, x));
    }

    @Inject(at={@At(value="HEAD")}, method={"getStyleAt(Lnet/minecraft/text/OrderedText;I)Lnet/minecraft/text/Style;"}, cancellable=true)
    private void onGetStyleAt(FormattedCharSequence text, int x, CallbackInfoReturnable<Style> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.getStyleAt(text, x));
    }

    @Inject(at={@At(value="HEAD")}, method={"wrapLines(Lnet/minecraft/text/StringVisitable;ILnet/minecraft/text/Style;Ljava/util/function/BiConsumer;)V"}, cancellable=true)
    private void onWrapLines(FormattedText text, int maxWidth, Style style, BiConsumer<FormattedText, Boolean> lineConsumer, CallbackInfo ci) {
        this.caxtonTextHandler.wrapLines(text, maxWidth, style, lineConsumer);
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"wrapLines(Ljava/lang/String;ILnet/minecraft/text/Style;ZLnet/minecraft/client/font/TextHandler$LineWrappingConsumer;)V"}, cancellable=true)
    private void onWrapLines(String text, int maxWidth, Style style, boolean retainTrailingWordSplit, StringSplitter.LinePosConsumer consumer, CallbackInfo ci) {
        this.caxtonTextHandler.wrapLines(text, maxWidth, style, retainTrailingWordSplit, consumer);
        ci.cancel();
    }
}

