/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin;

import com.google.common.base.Suppliers;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Font.class})
public class TextRendererMixin
implements HasCaxtonTextRenderer {
    @Shadow
    @Final
    private StringSplitter f_92714_;
    @Unique
    private static final Supplier<CaxtonGlyphCache> CACHE = Suppliers.memoize(() -> new CaxtonGlyphCache(Minecraft.m_91087_().m_91097_()));
    @Unique
    private CaxtonTextRenderer caxtonRenderer;

    @Inject(at={@At(value="TAIL")}, method={"<init>(Ljava/util/function/Function;Z)V"})
    private void onInit(Function<ResourceLocation, FontSet> fontStorageAccessor, boolean validateAdvance, CallbackInfo ci) {
        this.caxtonRenderer = new CaxtonTextRenderer((Font)this, this.f_92714_, CACHE);
    }

    @Inject(method={"mirror"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMirror(String text, CallbackInfoReturnable<String> cir) {
        this.caxtonRenderer.rtl = true;
        cir.setReturnValue((Object)text);
    }

    @Inject(at={@At(value="HEAD")}, method={"drawLayer(Ljava/lang/String;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/font/TextRenderer$TextLayerType;II)F"}, cancellable=true)
    private void onDrawLayerString(String text, float x, float y, int color, boolean shadow, Matrix4f matrix, MultiBufferSource vertexConsumerProvider, Font.DisplayMode layerType, int backgroundColor, int light, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.caxtonRenderer.drawLayer(text, x, y, color, shadow, matrix, vertexConsumerProvider, layerType, backgroundColor, light, -1, Float.POSITIVE_INFINITY)));
    }

    @Inject(at={@At(value="HEAD")}, method={"drawLayer(Lnet/minecraft/text/OrderedText;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/font/TextRenderer$TextLayerType;II)F"}, cancellable=true)
    private void onDrawLayerOrderedText(FormattedCharSequence text, float x, float y, int color, boolean shadow, Matrix4f matrix, MultiBufferSource vertexConsumerProvider, Font.DisplayMode layerType, int backgroundColor, int light, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.caxtonRenderer.drawLayer(text, x, y, color, shadow, matrix, vertexConsumerProvider, layerType, backgroundColor, light, -1, Float.POSITIVE_INFINITY)));
    }

    @Inject(at={@At(value="HEAD")}, method={"drawWithOutline"}, cancellable=true)
    private void onDrawWithOutline(FormattedCharSequence text, float x, float y, int color, int outlineColor, Matrix4f matrix, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        this.caxtonRenderer.drawWithOutline(text, x, y, color, outlineColor, matrix, vertexConsumers, light, true);
        ci.cancel();
    }

    @Override
    public CaxtonTextRenderer getCaxtonTextRenderer() {
        return this.caxtonRenderer;
    }
}

