/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.DirectionSetting;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;
import xyz.flirora.caxton.render.Voepfxo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractSignEditScreen.class})
public abstract class AbstractSignEditScreenMixin
extends Screen {
    @Shadow
    @Final
    protected SignBlockEntity f_244140_;
    @Shadow
    @Final
    protected String[] f_244359_;
    @Shadow
    private TextFieldHelper f_243993_;
    @Shadow
    private int f_244562_;
    @Unique
    private CaxtonText rowText;
    @Unique
    private CaxtonText currentRowText;

    protected AbstractSignEditScreenMixin(Component title) {
        super(title);
    }

    @ModifyArg(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/font/TextRenderer;draw(Ljava/lang/String;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/font/TextRenderer$TextLayerType;IIZ)I", ordinal=0), index=1)
    private float modifyXForDrawingRow(String currentLine, float x, float y, int color, boolean shadow, Matrix4f matrix, MultiBufferSource vertexConsumers, Font.DisplayMode layerType, int backgroundColor, int light, boolean rightToLeft) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.f_96547_).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        this.rowText = CaxtonText.fromFormatted(currentLine, ctr::getFontStorage, Style.f_131099_, false, this.f_96547_.m_92718_(), cth.getCache());
        if (currentLine == this.f_244359_[this.f_244562_]) {
            this.currentRowText = this.rowText;
        }
        return -cth.getWidth(this.rowText) / 2.0f;
    }

    @ModifyArg(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/font/TextRenderer;draw(Ljava/lang/String;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/font/TextRenderer$TextLayerType;IIZ)I", ordinal=1), index=1)
    private float modifyXForDrawingEndCursor(float x) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.f_96547_).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        return cth.getWidth(this.rowText) / 2.0f;
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/AbstractSignEditScreen;fill(Lnet/minecraft/client/util/math/MatrixStack;IIIII)V", ordinal=0))
    private void drawVerticalCursor(PoseStack matrixStack, int x1, int y1, int x2, int y2, int color) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.f_96547_).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        String currentLine = this.f_244359_[this.f_244562_];
        int selectionStart = this.f_243993_.m_95194_();
        int yAdj = 4 * this.f_244140_.m_245065_() / 2;
        int lineY = this.f_244562_ * this.f_244140_.m_245065_() - yAdj;
        float x = cth.getWidth(this.currentRowText) / 2.0f;
        float cursorOffset = cth.getOffsetAtIndex(this.currentRowText, Math.min(selectionStart, currentLine.length()), DirectionSetting.AUTO);
        float cursorX = cursorOffset - x;
        Voepfxo.fill(matrixStack, cursorX, (float)(lineY - 1), cursorX + 1.0f, (float)(lineY + this.f_244140_.m_245065_()), 0xFF000000 | color);
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/AbstractSignEditScreen;fill(Lnet/minecraft/client/util/math/MatrixStack;IIIII)V", ordinal=1))
    private void drawHighlights(PoseStack matrices, int x1, int y1, int x2, int y2, int color) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.f_96547_).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        int selectionStart = this.f_243993_.m_95194_();
        int selectionEnd = this.f_243993_.m_95197_();
        float x = cth.getWidth(this.currentRowText) / 2.0f;
        int yAdj = 4 * this.f_244140_.m_245065_() / 2;
        int lineY = this.f_244562_ * this.f_244140_.m_245065_() - yAdj;
        cth.getHighlightRanges(this.currentRowText, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), (start, end) -> Voepfxo.fill(matrices, start - x, (float)lineY, end - x, (float)(lineY + this.f_244140_.m_245065_()), color));
    }
}

