/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin.gui;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.DirectionSetting;
import xyz.flirora.caxton.layout.gui.TextFieldWidgetExt;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;
import xyz.flirora.caxton.render.Voepfxo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={EditBox.class})
public abstract class TextFieldWidgetMixin
extends AbstractWidget
implements Renderable,
GuiEventListener,
TextFieldWidgetExt {
    private static final Style SUGGESTION = Style.f_131099_.m_178520_(-8355712);
    @Unique
    private static final Matrix4f IDENTITY = new Matrix4f();
    @Shadow
    @Final
    private static String f_169004_;
    @Shadow
    @Final
    private Font f_94092_;
    @Shadow
    private String f_94093_;
    @Shadow
    private boolean f_94098_;
    @Shadow
    private int f_94103_;
    @Shadow
    private int f_94104_;
    @Shadow
    private int f_94095_;
    @Shadow
    private boolean f_94096_;
    @Shadow
    private int f_94100_;
    @Unique
    private CaxtonText caxtonText;
    @Shadow
    private int f_94101_;
    @Shadow
    private int f_94102_;
    @Shadow
    private BiFunction<String, Integer, FormattedCharSequence> f_94091_;
    @Shadow
    @Nullable
    private String f_94088_;
    @Shadow
    @Nullable
    private Component f_256828_;
    @Shadow
    @Nullable
    private Consumer<String> f_94089_;
    @Unique
    private boolean updatingCaxtonText = false;

    public TextFieldWidgetMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Shadow
    public abstract int m_94210_();

    @Shadow
    protected abstract int m_94216_();

    @Shadow
    public abstract void m_94192_(int var1);

    @Shadow
    public abstract void m_94196_(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCaxtonText(boolean changed) {
        if (this.updatingCaxtonText) {
            return;
        }
        this.updatingCaxtonText = true;
        if (changed && this.f_94089_ != null) {
            this.f_94089_.accept(this.f_94093_);
        }
        try {
            FormattedCharSequence text;
            boolean hideSuggestion = this.f_94101_ < this.f_94093_.length() || this.f_94093_.length() >= this.m_94216_();
            FormattedCharSequence formattedCharSequence = text = this.f_94093_.isEmpty() ? FormattedCharSequence.f_13691_ : this.f_94091_.apply(this.f_94093_, 0);
            if (!hideSuggestion && this.f_94088_ != null) {
                text = FormattedCharSequence.m_13696_((FormattedCharSequence)text, (FormattedCharSequence)FormattedCharSequence.m_13714_((String)this.f_94088_, (Style)SUGGESTION));
            }
            if (this.f_94092_ == null) {
                return;
            }
            CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.f_94092_).getCaxtonTextRenderer();
            this.caxtonText = CaxtonText.from(text, ctr::getFontStorage, true, false, ctr.getHandler().getCache());
        }
        finally {
            this.updatingCaxtonText = false;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onChanged"}, cancellable=true)
    private void stubOnChanged(String newText, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;text:Ljava/lang/String;", opcode=181, shift=At.Shift.AFTER)}, method={"setText"})
    private void updateCaxtonTextOnSetText(String text, CallbackInfo ci) {
        this.f_94102_ = this.f_94101_ = text.length();
        this.updateCaxtonText(true);
    }

    @ModifyReceiver(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;setSelectionStart(I)V")})
    private EditBox updateCaxtonTextOnWrite(EditBox me, int newSelectionStart) {
        this.m_94196_(newSelectionStart);
        this.f_94102_ = this.f_94101_;
        this.updateCaxtonText(true);
        return me;
    }

    @ModifyReceiver(method={"eraseCharacters"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;setCursor(I)V")})
    private EditBox updateCaxtonTextOnEraseCharacters(EditBox me, int cursor) {
        this.m_94196_(cursor);
        this.f_94102_ = this.f_94101_;
        this.updateCaxtonText(true);
        return me;
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;text:Ljava/lang/String;", opcode=181, shift=At.Shift.AFTER)}, method={"setMaxLength"})
    private void updateCaxtonTextOnSetMaxLength(int maxLength, CallbackInfo ci) {
        this.f_94101_ = Math.min(this.f_94101_, this.f_94093_.length());
        this.f_94102_ = Math.min(this.f_94102_, this.f_94093_.length());
        this.updateCaxtonText(true);
    }

    @Inject(at={@At(value="TAIL")}, method={"setSuggestion"})
    private void updateCaxtonTextOnSuggestionSet(String text, CallbackInfo ci) {
        this.updateCaxtonText(false);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;getInnerWidth()I")}, method={"renderButton"}, cancellable=true)
    private void onRenderButton(PoseStack matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.f_94092_).getCaxtonTextRenderer();
        int color = this.f_94098_ ? this.f_94103_ : this.f_94104_;
        int x = this.f_94096_ ? this.m_252754_() + 4 : this.m_252754_();
        int y = this.f_94096_ ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
        float firstCharLocation = 0.0f;
        float selectionStartLocation = 0.0f;
        if (this.caxtonText != null) {
            MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            ctr.draw(this.caxtonText, x, y, color, true, matrices.m_85850_().m_252922_(), (MultiBufferSource)immediate, false, 0, 0xF000F0, this.f_94100_, this.m_94210_());
            firstCharLocation = ctr.getHandler().getOffsetAtIndex(this.caxtonText, this.f_94100_, DirectionSetting.FORCE_LTR);
            selectionStartLocation = ctr.getHandler().getOffsetAtIndex(this.caxtonText, this.f_94101_, DirectionSetting.AUTO);
            immediate.m_109911_();
        }
        boolean cursorIsVertical = this.f_94101_ < this.f_94093_.length() || this.f_94093_.length() >= this.m_94216_();
        float cursorLocation = selectionStartLocation - firstCharLocation;
        boolean cursorInBounds = 0.0f <= cursorLocation && cursorLocation < (float)this.m_94210_();
        boolean showCursor = this.m_93696_() && this.f_94095_ / 6 % 2 == 0 && cursorInBounds;
        float cursorX = Math.round((float)x + cursorLocation);
        if (!cursorInBounds) {
            float f = cursorX = cursorLocation > 0.0f ? (float)(x + this.f_93618_) : (float)x;
        }
        if (this.f_256828_ != null && this.f_94093_.isEmpty() && !this.m_93696_()) {
            this.f_94092_.m_92763_(matrices, this.f_256828_, cursorX, (float)y, color);
        }
        if (showCursor) {
            if (cursorIsVertical) {
                float f = y - 1;
                Objects.requireNonNull(this.f_94092_);
                Voepfxo.fill(matrices, cursorX, f, cursorX + 1.0f, (float)(y + 1 + 9), -3092272);
            } else {
                this.f_94092_.m_92750_(matrices, f_169004_, cursorX, (float)y, color);
            }
        }
        if (this.f_94101_ != this.f_94102_) {
            float finalFirstCharLocation = firstCharLocation;
            ctr.getHandler().getHighlightRanges(this.caxtonText, Math.min(this.f_94101_, this.f_94102_), Math.max(this.f_94101_, this.f_94102_), (x0, x1) -> {
                float f = (float)x + x0 - finalFirstCharLocation;
                float f2 = y - 1;
                float f3 = (float)x + x1 - finalFirstCharLocation;
                Objects.requireNonNull(this.f_94092_);
                this.myDrawSelectionHighlight(f, f2, f3, y + 1 + 9);
            });
        }
        ci.cancel();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;getInnerWidth()I")}, method={"mouseClicked"}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.caxtonText == null) {
            this.updateCaxtonText(false);
        }
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.f_94092_).getCaxtonTextRenderer();
        float xOffset = (float)(mouseX - (double)this.m_252754_());
        if (this.f_94096_) {
            xOffset -= 4.0f;
        }
        int index = ctr.getHandler().getCharIndexAtX(this.caxtonText, xOffset, this.f_94100_);
        this.m_94192_(index);
        cir.setReturnValue((Object)true);
    }

    @Inject(at={@At(value="HEAD")}, method={"setSelectionEnd"}, cancellable=true)
    private void onSetSelectionEnd(int index, CallbackInfo ci) {
        int length = this.f_94093_.length();
        this.f_94102_ = Mth.m_14045_((int)index, (int)0, (int)length);
        if (this.f_94092_ != null && this.caxtonText != null) {
            if (this.f_94100_ > length) {
                this.f_94100_ = length;
            }
            int width = this.m_94210_();
            CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.f_94092_).getCaxtonTextRenderer();
            float firstCharLocation = ctr.getHandler().getOffsetAtIndex(this.caxtonText, this.f_94100_, DirectionSetting.FORCE_LTR);
            float selectionEndLocation = ctr.getHandler().getOffsetAtIndex(this.caxtonText, this.f_94102_, DirectionSetting.AUTO);
            if (this.f_94102_ == this.f_94100_) {
                this.f_94100_ = ctr.getHandler().getCharIndexAtX(this.caxtonText, selectionEndLocation - (float)width, -1);
            } else if (selectionEndLocation < firstCharLocation) {
                this.f_94100_ = ctr.getHandler().getCharIndexAtX(this.caxtonText, Math.min(firstCharLocation - (float)width, selectionEndLocation), -1);
            } else if (selectionEndLocation >= firstCharLocation + (float)width) {
                this.f_94100_ = ctr.getHandler().getCharIndexAfterX(this.caxtonText, selectionEndLocation - (float)width, -1);
            }
            this.f_94100_ = Mth.m_14045_((int)this.f_94100_, (int)0, (int)length);
        }
        ci.cancel();
    }

    private void myDrawSelectionHighlight(float x1, float y1, float x2, float y2) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > (float)(this.m_252754_() + this.f_93618_)) {
            x2 = this.m_252754_() + this.f_93618_;
        }
        if (x1 > (float)(this.m_252754_() + this.f_93618_)) {
            x1 = this.m_252754_() + this.f_93618_;
        }
        if (x2 < (float)this.m_252754_()) {
            x2 = this.m_252754_();
        }
        if (x1 < (float)this.m_252754_()) {
            x1 = this.m_252754_();
        }
        Voepfxo.drawSelection(IDENTITY, x1, y1, x2, y2);
    }
}

