/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.render.CaxtonAtlas;

public class CaxtonGlyphCache {
    private final CaxtonAtlas atlas;
    private final Map<CaxtonFont, Int2LongMap> cache = new HashMap<CaxtonFont, Int2LongMap>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public CaxtonGlyphCache(TextureManager textureManager) {
        this.atlas = new CaxtonAtlas(textureManager);
    }

    public Font forFont(CaxtonFont font) {
        return new Font(font, this.cache.computeIfAbsent(font, f -> {
            LOGGER.info("Adding entry for font {}", (Object)font);
            return new Int2LongOpenHashMap();
        }));
    }

    public ResourceLocation getAtlasPage(int pageNum) {
        return this.atlas.getAtlasPage(pageNum);
    }

    public CaxtonAtlas.Page getAtlasPageTexture(int pageNum) {
        int pageCount = this.atlas.getNumPages();
        if (pageNum >= pageCount) {
            LOGGER.error("*** ATLAS PAGE INDEX OUT OF BOUNDS: {} >= {} ***", (Object)pageNum, (Object)pageCount);
            LOGGER.error("This probably indicates a race condition.");
            LOGGER.error("See <https://gitlab.com/Kyarei/caxton/-/issues/44> for more details.");
            throw new IndexOutOfBoundsException("Al quira Prenia Callta caprinini");
        }
        return this.atlas.getAtlasPageTexture(pageNum);
    }

    public synchronized void clear() {
        LOGGER.info("Clearing glyph atlas with {} pages and {} fonts", (Object)this.atlas.getNumPages(), (Object)this.cache.size());
        this.atlas.clear();
        this.cache.clear();
    }

    public CaxtonAtlas getAtlas() {
        return this.atlas;
    }

    public Map<CaxtonFont, Int2LongMap> getLocations() {
        return this.cache;
    }

    public class Font {
        private final CaxtonFont font;
        private final Int2LongMap entry;

        private Font(CaxtonFont font, Int2LongMap entry) {
            this.font = font;
            this.entry = entry;
        }

        public long getOrCreateAtlasLocation(int glyphId) {
            return this.entry.computeIfAbsent(glyphId, id -> {
                long tlLoc = this.font.getTlistLocation(glyphId, 0);
                int width = (int)(tlLoc & 0xFFFFL);
                int height = (int)(tlLoc >> 16 & 0xFFFFL);
                int numMipmapLevels = this.font.getNumMipmapLevels();
                long location = CaxtonGlyphCache.this.atlas.insert(width, height, 1, this.font.getOptions().range(), numMipmapLevels, this.font.getPixelFormat());
                if (location == 0L) {
                    return location;
                }
                CaxtonGlyphCache.this.atlas.getAtlasPageTexture(CaxtonAtlas.getPage(location)).m_117966_();
                GlStateManager.m_84522_((int)3314, (int)0);
                GlStateManager.m_84522_((int)3316, (int)0);
                GlStateManager.m_84522_((int)3315, (int)0);
                GlStateManager.m_84522_((int)3317, (int)this.font.getPixelFormat().m_85161_());
                for (int mipmap = 0; mipmap < numMipmapLevels; ++mipmap) {
                    tlLoc = this.font.getTlistLocation(glyphId, mipmap);
                    width = (int)(tlLoc & 0xFFFFL);
                    height = (int)(tlLoc >> 16 & 0xFFFFL);
                    int offset = (int)(tlLoc >>> 32);
                    GlStateManager.m_84199_((int)3553, (int)mipmap, (int)(CaxtonAtlas.getX(location) >> mipmap), (int)(CaxtonAtlas.getY(location) >> mipmap), (int)width, (int)height, (int)this.font.getPixelFormat().m_85170_(), (int)5121, (long)(this.font.getPixelData(mipmap) + 4L * Integer.toUnsignedLong(offset)));
                }
                return location;
            });
        }
    }
}

