/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSink;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import xyz.flirora.caxton.mixin.TextRendererAccessor;
import xyz.flirora.caxton.render.CaxtonTextRenderer;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonTextDrawer
implements FormattedCharSink {
    private final CaxtonTextRenderer textRenderer;
    final MultiBufferSource vertexConsumers;
    private final boolean shadow;
    private final float brightnessMultiplier;
    private final float red;
    private final float green;
    private final float blue;
    private final float alpha;
    private final int backgroundColor;
    private final Matrix4f matrix;
    private final Font.DisplayMode layerType;
    private final int light;
    private final boolean swapZIndex;
    private float x;
    private float y;
    private final List<DrawnGlyph> glyphs;
    @Nullable
    private List<BakedGlyph.Effect> rectangles;

    public CaxtonTextDrawer(CaxtonTextRenderer textRenderer, MultiBufferSource vertexConsumers, float x, float y, int color, int backgroundColor, boolean shadow, Matrix4f matrix, Font.DisplayMode layerType, int light, boolean swapZIndex) {
        this.textRenderer = textRenderer;
        this.vertexConsumers = vertexConsumers;
        this.shadow = shadow;
        this.brightnessMultiplier = shadow ? 0.25f : 1.0f;
        this.alpha = (float)(color >>> 24) / 255.0f;
        this.red = (float)(color >> 16 & 0xFF) / 255.0f * this.brightnessMultiplier;
        this.green = (float)(color >> 8 & 0xFF) / 255.0f * this.brightnessMultiplier;
        this.blue = (float)(color & 0xFF) / 255.0f * this.brightnessMultiplier;
        this.backgroundColor = backgroundColor;
        this.matrix = matrix;
        this.layerType = layerType;
        this.light = light;
        this.swapZIndex = swapZIndex;
        this.x = x;
        this.y = y;
        this.glyphs = new ArrayList<DrawnGlyph>();
    }

    public CaxtonTextDrawer(CaxtonTextRenderer textRenderer, MultiBufferSource vertexConsumers, float x, float y, int color, boolean shadow, Matrix4f matrix, Font.DisplayMode layerType, int light) {
        this(textRenderer, vertexConsumers, x, y, color, 0, shadow, matrix, layerType, light, true);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void addRectangle(BakedGlyph.Effect rectangle) {
        if (this.rectangles == null) {
            this.rectangles = new ArrayList<BakedGlyph.Effect>();
        }
        this.rectangles.add(rectangle);
    }

    public boolean m_6411_(int index, Style style, int codePoint) {
        float shadowOffset;
        float x;
        FontSet storage = this.textRenderer.getFontStorage(style.m_131192_());
        GlyphInfo glyph = storage.m_243128_(codePoint, ((TextRendererAccessor)this.textRenderer.vanillaTextRenderer).isValidateAdvance());
        BakedGlyph bakedGlyph = style.m_131176_() && codePoint != 32 ? storage.m_95067_(glyph) : storage.m_95078_(codePoint);
        boolean bold = style.m_131154_();
        TextColor textColor = style.m_131135_();
        float red = textColor != null ? (float)(textColor.m_131265_() >> 16 & 0xFF) / 255.0f * this.brightnessMultiplier : this.red;
        float green = textColor != null ? (float)(textColor.m_131265_() >> 8 & 0xFF) / 255.0f * this.brightnessMultiplier : this.green;
        float blue = textColor != null ? (float)(textColor.m_131265_() & 0xFF) / 255.0f * this.brightnessMultiplier : this.blue;
        float alpha = this.alpha;
        float advance = glyph.m_83827_(bold);
        float f = x = index == 0 ? this.x - 1.0f : this.x;
        if (!(bakedGlyph instanceof EmptyGlyph)) {
            float boldOffset = bold ? glyph.m_5619_() : 0.0f;
            float shadowOffset2 = this.shadow ? glyph.m_5645_() : 0.0f;
            this.glyphs.add(new DrawnGlyph(this.x + shadowOffset2, this.y + shadowOffset2, red, green, blue, alpha, bakedGlyph, style, boldOffset));
        }
        float f2 = shadowOffset = this.shadow ? 1.0f : 0.0f;
        if (style.m_131168_()) {
            this.addRectangle(new BakedGlyph.Effect(x + shadowOffset, this.y + shadowOffset + 4.5f, this.x + shadowOffset + advance, this.y + shadowOffset + 3.5f, this.getForegroundZIndex(), red, green, blue, alpha));
        }
        if (style.m_131171_()) {
            this.addRectangle(new BakedGlyph.Effect(x + shadowOffset, this.y + shadowOffset + 9.0f, this.x + shadowOffset + advance, this.y + shadowOffset + 8.0f, this.getForegroundZIndex(), red, green, blue, alpha));
        }
        this.x += advance;
        return true;
    }

    float drawLayer(float x) {
        BakedGlyph bakedGlyph = null;
        if (this.backgroundColor != 0) {
            BakedGlyph.Effect rectangle = new BakedGlyph.Effect(x - 1.0f, this.y + 9.0f, this.x, this.y - 1.0f, this.getBackgroundZIndex(), (float)(this.backgroundColor >> 16) / 255.0f, (float)(this.backgroundColor >> 8) / 255.0f, (float)this.backgroundColor / 255.0f, (float)(this.backgroundColor >> 24) / 255.0f);
            bakedGlyph = this.textRenderer.getFontStorage(Style.f_131100_).m_95064_();
            VertexConsumer vertexConsumer = this.vertexConsumers.m_6299_(bakedGlyph.m_181387_(this.layerType));
            bakedGlyph.m_95220_(rectangle, this.matrix, vertexConsumer, this.light);
        }
        this.drawGlyphs();
        if (this.rectangles != null) {
            if (bakedGlyph == null) {
                bakedGlyph = this.textRenderer.getFontStorage(Style.f_131100_).m_95064_();
            }
            VertexConsumer vertexConsumer2 = this.vertexConsumers.m_6299_(bakedGlyph.m_181387_(this.layerType));
            for (BakedGlyph.Effect rectangle2 : this.rectangles) {
                bakedGlyph.m_95220_(rectangle2, this.matrix, vertexConsumer2, this.light);
            }
        }
        return this.x;
    }

    void drawGlyphs() {
        for (DrawnGlyph drawnGlyph : this.glyphs) {
            BakedGlyph bakedGlyph = drawnGlyph.glyph();
            VertexConsumer vertexConsumer = this.vertexConsumers.m_6299_(bakedGlyph.m_181387_(this.layerType));
            bakedGlyph.m_5626_(drawnGlyph.style.m_131161_(), drawnGlyph.x, drawnGlyph.y, this.matrix, vertexConsumer, drawnGlyph.red, drawnGlyph.green, drawnGlyph.blue, drawnGlyph.alpha, this.light);
            if (!drawnGlyph.style.m_131154_()) continue;
            bakedGlyph.m_5626_(drawnGlyph.style.m_131161_(), drawnGlyph.x + drawnGlyph.boldOffset, drawnGlyph.y, this.matrix, vertexConsumer, drawnGlyph.red, drawnGlyph.green, drawnGlyph.blue, drawnGlyph.alpha, this.light);
        }
    }

    public float getForegroundZIndex() {
        return this.swapZIndex ? 0.01f : -0.01f;
    }

    private float getBackgroundZIndex() {
        return this.swapZIndex ? -0.01f : 0.01f;
    }

    private record DrawnGlyph(float x, float y, float red, float green, float blue, float alpha, BakedGlyph glyph, Style style, float boldOffset) {
    }
}

