/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.font.FontTech;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonShaders;
import xyz.flirora.caxton.render.CaxtonTextLayerType;
import xyz.flirora.caxton.render.ShaderExt;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonTextRenderLayers {
    private final Group msdf = new Group(RenderLayerFunctions::ofText, RenderLayerFunctions::ofTextSeeThrough, RenderLayerFunctions::ofTextOffset, RenderLayerFunctions::ofTextOutline);
    private final Group raster = new Group(RenderLayerFunctions::ofTextR, RenderLayerFunctions::ofTextSeeThroughR, RenderLayerFunctions::ofTextOffsetR, RenderLayerFunctions::ofTextR);
    private final Group rasterAa = new Group(RenderLayerFunctions::ofTextRA, RenderLayerFunctions::ofTextSeeThroughRA, RenderLayerFunctions::ofTextOffsetRA, RenderLayerFunctions::ofTextRA);

    public void clear() {
        this.msdf.clear();
        this.raster.clear();
    }

    public RenderType text(CaxtonAtlas.Page page, CaxtonTextLayerType layerType, FontTech tech, boolean blur) {
        return switch (tech) {
            default -> throw new IncompatibleClassChangeError();
            case FontTech.MSDF -> this.msdf.text(page, layerType);
            case FontTech.RASTER -> (blur ? this.rasterAa : this.raster).text(page, layerType);
        };
    }

    public static class Group {
        private final ConcurrentHashMap<CaxtonAtlas.Page, RenderType> text = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, RenderType> textSeeThrough = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, RenderType> textOffset = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, RenderType> textOutline = new ConcurrentHashMap();
        private final Function<CaxtonAtlas.Page, RenderType> ofText;
        private final Function<CaxtonAtlas.Page, RenderType> ofTextSeeThrough;
        private final Function<CaxtonAtlas.Page, RenderType> ofTextOffset;
        private final Function<CaxtonAtlas.Page, RenderType> ofTextOutline;

        public Group(Function<CaxtonAtlas.Page, RenderType> ofText, Function<CaxtonAtlas.Page, RenderType> ofTextSeeThrough, Function<CaxtonAtlas.Page, RenderType> ofTextOffset, Function<CaxtonAtlas.Page, RenderType> ofTextOutline) {
            this.ofText = ofText;
            this.ofTextSeeThrough = ofTextSeeThrough;
            this.ofTextOffset = ofTextOffset;
            this.ofTextOutline = ofTextOutline;
        }

        public void clear() {
            this.text.clear();
            this.textSeeThrough.clear();
            this.textOffset.clear();
            this.textOutline.clear();
        }

        public RenderType text(CaxtonAtlas.Page page, CaxtonTextLayerType layerType) {
            return switch (layerType) {
                default -> throw new IncompatibleClassChangeError();
                case CaxtonTextLayerType.NORMAL -> this.text.computeIfAbsent(page, this.ofText);
                case CaxtonTextLayerType.SEE_THROUGH -> this.textSeeThrough.computeIfAbsent(page, this.ofTextSeeThrough);
                case CaxtonTextLayerType.OUTLINE -> this.textOutline.computeIfAbsent(page, this.ofTextOutline);
                case CaxtonTextLayerType.POLYGON_OFFSET -> this.textOffset.computeIfAbsent(page, this.ofTextOffset);
            };
        }
    }

    private static class RenderLayerFunctions
    extends RenderType {
        public RenderLayerFunctions(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
        }

        private static RenderType make(String name, Supplier<ShaderInstance> shader, CaxtonAtlas.Page page, boolean seeThrough, boolean rasterized, boolean blur, boolean polygonOffset) {
            return RenderType.m_173215_((String)name, (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)CaxtonModClient.CONFIG.sortTextRenderLayers, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_((RenderStateShard.ShaderStateShard)new Shayder(shader, RenderLayerFunctions.handleTextShader(page, !rasterized))).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(page.getId(), blur, page.getNumMipmapLevels() > 1)).m_110685_(f_110139_).m_110671_(f_110152_).m_110663_(seeThrough ? RenderStateShard.f_110111_ : RenderStateShard.f_110113_).m_110669_(polygonOffset ? RenderStateShard.f_110118_ : RenderStateShard.f_110117_).m_110691_(false));
        }

        private static RenderType ofText(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text", () -> CaxtonShaders.caxtonTextShader, page, false, false, true, false);
        }

        private static RenderType ofTextSeeThrough(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through", () -> CaxtonShaders.caxtonTextSeeThroughShader, page, true, false, true, false);
        }

        private static RenderType ofTextOffset(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text", () -> CaxtonShaders.caxtonTextShader, page, false, false, true, true);
        }

        private static RenderType ofTextOutline(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline", () -> CaxtonShaders.caxtonTextOutlineShader, page, false, false, true, false);
        }

        private static RenderType ofTextR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_raster", GameRenderer::m_172750_, page, false, true, false, false);
        }

        private static RenderType ofTextSeeThroughR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through_raster", GameRenderer::m_172752_, page, true, true, false, false);
        }

        private static RenderType ofTextOffsetR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline_raster", GameRenderer::m_172750_, page, false, true, false, true);
        }

        private static RenderType ofTextRA(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_raster", GameRenderer::m_172750_, page, false, true, true, false);
        }

        private static RenderType ofTextSeeThroughRA(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through_raster", GameRenderer::m_172752_, page, true, true, true, false);
        }

        private static RenderType ofTextOffsetRA(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline_raster", GameRenderer::m_172750_, page, false, true, true, true);
        }

        private static Consumer<ShaderInstance> handleTextShader(CaxtonAtlas.Page texId, boolean setUniforms) {
            if (!setUniforms) {
                return shader -> {};
            }
            return shader -> {
                if (shader == null) {
                    return;
                }
                Uniform unitRange = ((ShaderExt)shader).caxton$getUnitRange();
                if (unitRange != null) {
                    unitRange.m_5985_((float)texId.getRange() / (float)CaxtonAtlas.PAGE_SIZE);
                }
            };
        }

        public static class Shayder
        extends RenderStateShard.ShaderStateShard {
            public Shayder(Supplier<ShaderInstance> supplier, Consumer<ShaderInstance> callback) {
                super(() -> {
                    ShaderInstance shader = (ShaderInstance)supplier.get();
                    callback.accept(shader);
                    return shader;
                });
            }
        }
    }
}

