/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonFontOptions;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;
import xyz.flirora.caxton.layout.Threshold;
import xyz.flirora.caxton.mixin.TextRendererAccessor;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextDrawer;
import xyz.flirora.caxton.render.CaxtonTextLayerType;
import xyz.flirora.caxton.render.CaxtonTextRenderLayers;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonTextRenderer {
    private static final Vector3f FORWARD_SHIFT = new Vector3f(0.0f, 0.0f, 0.03f);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final CaxtonTextHandler handler;
    final Font vanillaTextRenderer;
    private final RandomSource RANDOM = RandomSource.m_216343_();
    private CaxtonGlyphCache cache;
    private final Supplier<CaxtonGlyphCache> cacheSupplier;
    private final CaxtonTextRenderLayers renderLayers;
    public boolean rtl;

    public CaxtonTextRenderer(Font vanillaTextRenderer, StringSplitter vanillaTextHandler, Supplier<CaxtonGlyphCache> cacheSupplier) {
        this.handler = new CaxtonTextHandler(this::getFontStorage, vanillaTextHandler);
        this.vanillaTextRenderer = vanillaTextRenderer;
        this.cacheSupplier = cacheSupplier;
        this.renderLayers = new CaxtonTextRenderLayers();
    }

    public static CaxtonTextRenderer getInstance() {
        return ((HasCaxtonTextRenderer)Minecraft.m_91087_().f_91062_).getCaxtonTextRenderer();
    }

    public static CaxtonTextRenderer getAdvanceValidatingInstance() {
        return ((HasCaxtonTextRenderer)Minecraft.m_91087_().f_243022_).getCaxtonTextRenderer();
    }

    private static int tweakTransparency(int argb) {
        if ((argb & 0xFC000000) == 0) {
            return argb | 0xFF000000;
        }
        return argb;
    }

    private static float getMinThickness(Matrix4f modelView) {
        if (modelView.isAffine()) {
            Window window = Minecraft.m_91087_().m_91268_();
            Vector3f v = new Vector3f(0.0f, 1.0f, 0.0f);
            modelView.transformDirection(v);
            RenderSystem.m_253262_().transformDirection(v);
            v.mul((float)window.m_85443_() / 2.0f, (float)window.m_85444_() / 2.0f, 0.0f);
            float fontUnitYPx = Mth.m_14116_((float)(v.x * v.x + v.y * v.y));
            return 1.0f / fontUnitYPx;
        }
        return 0.0f;
    }

    public FontSet getFontStorage(ResourceLocation id) {
        return ((TextRendererAccessor)this.vanillaTextRenderer).callGetFontStorage(id);
    }

    public float drawLayer(String text, float x, float y, int color, boolean shadow, Matrix4f matrix, MultiBufferSource vertexConsumerProvider, Font.DisplayMode layerType, int backgroundColor, int light, int leftmostCodePoint, float maxWidth) {
        CaxtonText runGroups = CaxtonText.fromFormatted(text, this::getFontStorage, Style.f_131099_, false, this.rtl, this.handler.getCache());
        float newX = this.drawRunGroups(x, y, color, shadow, matrix, vertexConsumerProvider, CaxtonTextLayerType.fromVanilla(layerType), backgroundColor, light, runGroups, leftmostCodePoint, maxWidth, CaxtonTextRenderer.getMinThickness(matrix));
        if (!shadow) {
            this.rtl = false;
        }
        return newX;
    }

    public float drawLayer(FormattedCharSequence text, float x, float y, int color, boolean shadow, Matrix4f matrix, MultiBufferSource vertexConsumerProvider, Font.DisplayMode layerType, int backgroundColor, int light, int leftmostCodePoint, float maxWidth) {
        CaxtonText runGroups = CaxtonText.from(text, this::getFontStorage, false, this.rtl, this.handler.getCache());
        return this.drawRunGroups(x, y, color, shadow, matrix, vertexConsumerProvider, CaxtonTextLayerType.fromVanilla(layerType), backgroundColor, light, runGroups, leftmostCodePoint, maxWidth, CaxtonTextRenderer.getMinThickness(matrix));
    }

    public void drawWithOutline(FormattedCharSequence text, float x, float y, int color, int outlineColor, Matrix4f matrix, MultiBufferSource vertexConsumers, int light, boolean addCorners) {
        Threshold NO_THRESHOLD = new Threshold(-1);
        float minThickness = CaxtonTextRenderer.getMinThickness(matrix);
        CaxtonText runGroups = CaxtonText.from(text, this::getFontStorage, false, this.rtl, this.handler.getCache());
        int effectiveOutlineColor = CaxtonTextRenderer.tweakTransparency(outlineColor);
        int effectiveColor = CaxtonTextRenderer.tweakTransparency(color);
        CaxtonTextDrawer outlineDrawer = new CaxtonTextDrawer(this, vertexConsumers, 0.0f, 0.0f, effectiveOutlineColor, false, matrix, Font.DisplayMode.NORMAL, light);
        CaxtonTextDrawer centralDrawer = new CaxtonTextDrawer(this, vertexConsumers, x, y, effectiveColor, false, matrix, Font.DisplayMode.POLYGON_OFFSET, light);
        for (RunGroup runGroup : runGroups.runGroups()) {
            ConfiguredCaxtonFont font = runGroup.getFont();
            if (font == null) {
                MutableFloat xBox = new MutableFloat();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        if (dx == 0 && dy == 0 || !addCorners && dx != 0 && dy != 0) continue;
                        xBox.setValue(x);
                        int dxf = dx;
                        int dyf = dy;
                        runGroup.acceptRender((index, style, codePoint) -> {
                            int index2 = runGroup.getCharOffset() + index;
                            FontSet fontStorage = this.getFontStorage(style.m_131192_());
                            GlyphInfo glyph = fontStorage.m_243128_(codePoint, false);
                            float shadowOffset = glyph.m_5645_();
                            outlineDrawer.setX(xBox.floatValue() + (float)dxf * shadowOffset);
                            outlineDrawer.setY(y + (float)dyf * shadowOffset);
                            xBox.add(glyph.m_83827_(style.m_131154_()));
                            return outlineDrawer.m_6411_(index2, style, codePoint);
                        });
                    }
                }
                centralDrawer.setX(x);
                runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = runGroup.getCharOffset() + index;
                    return centralDrawer.m_6411_(index2, style, codePoint);
                });
                x = centralDrawer.getX();
            } else {
                ShapingResult[] shapingResults = runGroup.getShapingResults();
                int outlinedGlyphOffset = font.font().getOptions().fontTech().offsetOutlineGlyphsByGlyphCounts() ? font.font().getGlyphCount() : 0;
                for (int i = 0; i < shapingResults.length; ++i) {
                    ShapingResult shapingResult = shapingResults[i];
                    this.drawShapedRun(shapingResult, runGroup, i, x, y, effectiveOutlineColor, false, matrix, vertexConsumers, CaxtonTextLayerType.OUTLINE, light, outlineDrawer, NO_THRESHOLD, Float.POSITIVE_INFINITY, minThickness, outlinedGlyphOffset);
                    x = this.drawShapedRun(shapingResult, runGroup, i, x, y, effectiveColor, false, matrix, vertexConsumers, CaxtonTextLayerType.POLYGON_OFFSET, light, outlineDrawer, NO_THRESHOLD, Float.POSITIVE_INFINITY, minThickness, 0);
                }
            }
            outlineDrawer.drawLayer(x);
            centralDrawer.drawLayer(x);
        }
    }

    public float draw(CaxtonText text, float x, float y, int color, boolean shadow, Matrix4f matrix, MultiBufferSource vertexConsumerProvider, boolean seeThrough, int backgroundColor, int light, int leftmostCodePoint, float maxWidth) {
        float minThickness = CaxtonTextRenderer.getMinThickness(matrix);
        CaxtonTextLayerType layerType = seeThrough ? CaxtonTextLayerType.SEE_THROUGH : CaxtonTextLayerType.NORMAL;
        color = CaxtonTextRenderer.tweakTransparency(color);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)matrix);
        if (shadow) {
            this.drawRunGroups(x, y, color, true, matrix, vertexConsumerProvider, layerType, backgroundColor, light, text, leftmostCodePoint, maxWidth, minThickness);
            matrix4f.translate((Vector3fc)FORWARD_SHIFT);
        }
        x = this.drawRunGroups(x, y, color, false, matrix4f, vertexConsumerProvider, layerType, backgroundColor, light, text, leftmostCodePoint, maxWidth, minThickness);
        return (int)x + (shadow ? 1 : 0);
    }

    private float drawRunGroups(float x, float y, int color, boolean shadow, Matrix4f matrix, MultiBufferSource vertexConsumerProvider, CaxtonTextLayerType layerType, int backgroundColor, int light, CaxtonText text, int leftmostCodePoint, float maxWidth, float minThickness) {
        this.getCache();
        Threshold threshold = new Threshold(leftmostCodePoint);
        float origX = x;
        float maxX = x + maxWidth;
        CaxtonTextDrawer drawer = new CaxtonTextDrawer(this, vertexConsumerProvider, x, y, color, backgroundColor, shadow, matrix, layerType.asVanilla(), light, true);
        for (RunGroup runGroup : text.runGroups()) {
            if (threshold.shouldSkip(runGroup)) continue;
            if (x >= maxX) break;
            if (runGroup.getFont() == null) {
                drawer.setX(x);
                runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = runGroup.getCharOffset() + index;
                    if (threshold.updateLegacy(index2)) {
                        return true;
                    }
                    if (drawer.getX() >= maxX + this.handler.getWidth(codePoint, style)) {
                        return false;
                    }
                    return drawer.m_6411_(index2, style, codePoint);
                });
                x = drawer.getX();
                continue;
            }
            ShapingResult[] shapingResults = runGroup.getShapingResults();
            for (int index2 = 0; index2 < shapingResults.length; ++index2) {
                ShapingResult shapingResult = shapingResults[index2];
                x = this.drawShapedRun(shapingResult, runGroup, index2, x, y, color, shadow, matrix, vertexConsumerProvider, layerType, light, drawer, threshold, maxX, minThickness, 0);
            }
        }
        drawer.setX(x);
        drawer.drawLayer(origX);
        return x;
    }

    private float drawShapedRun(ShapingResult shapedRun, RunGroup runGroup, int index, float x, float y, int color, boolean shadow, Matrix4f matrix, MultiBufferSource vertexConsumers, CaxtonTextLayerType layerType, int light, CaxtonTextDrawer drawer, Threshold threshold, float maxX, float minThickness, int glyphOffset) {
        if (x >= maxX) {
            return x;
        }
        ConfiguredCaxtonFont configuredFont = runGroup.getFont();
        CaxtonFont font = configuredFont.font();
        CaxtonFontOptions options = font.getOptions();
        CaxtonGlyphCache.Font cacheForFont = this.cache.forFont(font);
        assert (glyphOffset + font.getGlyphCount() <= font.getTlistSize());
        double shrink = options.shrinkage();
        int margin = options.margin();
        float shadowOffset = shadow ? configuredFont.shadowOffset() : 0.0f;
        float pageSize = CaxtonAtlas.PAGE_SIZE;
        int offset = runGroup.getBidiRuns()[4 * index + 0];
        short underlinePosition = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_POSITION);
        short underlineThickness = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_THICKNESS);
        short strikeoutPosition = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_POSITION);
        short strikeoutThickness = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_THICKNESS);
        float scale = configuredFont.getScale();
        float baselineY = y + 7.0f + configuredFont.shiftY();
        x += configuredFont.shiftX();
        float yu = baselineY - (float)underlinePosition * scale;
        float ys = baselineY - (float)strikeoutPosition * scale;
        float dyu = (float)underlineThickness * scale;
        float dys = (float)strikeoutThickness * scale;
        float ou = 0.5f * dyu;
        float os = 0.5f * dys;
        if (dyu < minThickness) {
            dyu = minThickness;
        }
        if (dys < minThickness) {
            dys = minThickness;
        }
        float y0u = yu + 0.5f * dyu;
        float y1u = yu - 0.5f * dyu;
        float y0s = ys + 0.5f * dys;
        float y1s = ys - 0.5f * dys;
        float brightnessMultiplier = shadow ? 0.25f : 1.0f;
        float baseBlue = (float)(color & 0xFF) / 255.0f * brightnessMultiplier;
        float baseGreen = (float)(color >> 8 & 0xFF) / 255.0f * brightnessMultiplier;
        float baseRed = (float)(color >> 16 & 0xFF) / 255.0f * brightnessMultiplier;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int numGlyphs = shapedRun.numGlyphs();
        int cumulAdvanceX = 0;
        for (int i = 0; i < numGlyphs; ++i) {
            int glyphId = shapedRun.glyphId(i);
            int clusterIndex = shapedRun.clusterIndex(i);
            if (threshold.updateCaxton(runGroup, index, shapedRun, i)) continue;
            Style style = runGroup.getStyleAt(offset + clusterIndex);
            if (style.m_131176_()) {
                long tlLoc = font.getTlistLocation(glyphId, 0);
                int width = (int)(tlLoc & 0xFFFFL);
                IntList others = (IntList)font.getGlyphsByWidth().get(width);
                glyphId = others.getInt(this.RANDOM.m_188503_(others.size()));
            }
            TextColor styleColorObj = style.m_131135_();
            float red = baseRed;
            float green = baseGreen;
            float blue = baseBlue;
            if (styleColorObj != null) {
                int styleColor = styleColorObj.m_131265_();
                red = (float)(styleColor >> 16 & 0xFF) / 255.0f * brightnessMultiplier;
                green = (float)(styleColor >> 8 & 0xFF) / 255.0f * brightnessMultiplier;
                blue = (float)(styleColor & 0xFF) / 255.0f * brightnessMultiplier;
            }
            int advanceX = shapedRun.advanceX(i);
            int offsetX = shapedRun.offsetX(i);
            int offsetY = shapedRun.offsetY(i);
            int gx = cumulAdvanceX + offsetX;
            long atlasLoc = cacheForFont.getOrCreateAtlasLocation(glyphOffset + glyphId);
            if (atlasLoc != 0L) {
                int atlasX = CaxtonAtlas.getX(atlasLoc);
                int atlasY = CaxtonAtlas.getY(atlasLoc);
                int atlasWidth = CaxtonAtlas.getW(atlasLoc);
                int atlasHeight = CaxtonAtlas.getH(atlasLoc);
                int atlasPageIndex = CaxtonAtlas.getPage(atlasLoc);
                CaxtonAtlas.Page atlasPage = this.cache.getAtlasPageTexture(atlasPageIndex);
                long glyphBbox = font.getBbox(glyphId);
                short bbXMin = (short)glyphBbox;
                short bbYMin = (short)(glyphBbox >> 16);
                short bbXMax = (short)(glyphBbox >> 32);
                short bbYMax = (short)(glyphBbox >> 48);
                int bbWidth = bbXMax - bbXMin;
                int bbHeight = bbYMax - bbYMin;
                RenderType renderLayer = this.renderLayers.text(atlasPage, layerType, options.fontTech(), configuredFont.blur());
                VertexConsumer vertexConsumer = vertexConsumers.m_6299_(renderLayer);
                float x0 = (float)((double)x + ((double)(gx += bbXMin) - shrink * (double)margin) * (double)scale);
                float y1 = (float)(((double)(-(offsetY += bbYMin)) + shrink * (double)margin) * (double)scale);
                float u0 = (float)atlasX / pageSize;
                float v0 = (float)atlasY / pageSize;
                float x1 = (float)((double)x + ((double)gx + shrink * (double)(atlasWidth - margin)) * (double)scale);
                float y0 = (float)(((double)(-offsetY) - shrink * (double)(atlasHeight - margin)) * (double)scale);
                float u1 = (float)(atlasX + atlasWidth) / pageSize;
                float v1 = (float)(atlasY + atlasHeight) / pageSize;
                float lowerOffset = configuredFont.slant() * y0;
                float upperOffset = configuredFont.slant() * y1;
                y0 += baselineY;
                y1 += baselineY;
                if (x1 >= maxX) break;
                x1 += shadowOffset;
                vertexConsumer.m_252986_(matrix, (x0 += shadowOffset) + lowerOffset, y0 += shadowOffset, 0.0f).m_85950_(red, green, blue, alpha);
                vertexConsumer.m_7421_(u0, v0).m_85969_(light).m_5752_();
                vertexConsumer.m_252986_(matrix, x0 + upperOffset, y1 += shadowOffset, 0.0f).m_85950_(red, green, blue, alpha);
                vertexConsumer.m_7421_(u0, v1).m_85969_(light).m_5752_();
                vertexConsumer.m_252986_(matrix, x1 + upperOffset, y1, 0.0f).m_85950_(red, green, blue, alpha);
                vertexConsumer.m_7421_(u1, v1).m_85969_(light).m_5752_();
                vertexConsumer.m_252986_(matrix, x1 + lowerOffset, y0, 0.0f).m_85950_(red, green, blue, alpha);
                vertexConsumer.m_7421_(u1, v0).m_85969_(light).m_5752_();
            }
            float x0a = x + (float)cumulAdvanceX * scale;
            float x1a = x + (float)(cumulAdvanceX + advanceX) * scale;
            if (style.m_131171_()) {
                drawer.addRectangle(new BakedGlyph.Effect(x0a + shadowOffset, y0u + shadowOffset, x1a + shadowOffset, y1u + shadowOffset, drawer.getForegroundZIndex(), red, green, blue, alpha));
            }
            if (style.m_131168_()) {
                drawer.addRectangle(new BakedGlyph.Effect(x0a + shadowOffset, y0s + shadowOffset, x1a + shadowOffset, y1s + shadowOffset, drawer.getForegroundZIndex(), red, green, blue, alpha));
            }
            cumulAdvanceX += advanceX;
        }
        return x + (float)cumulAdvanceX * scale - configuredFont.shiftX();
    }

    public CaxtonGlyphCache getCache() {
        if (this.cache == null) {
            this.cache = this.cacheSupplier.get();
        }
        return this.cache;
    }

    public void clearCaches() {
        this.handler.clearCaches();
        LOGGER.info("Cleared layout caches");
        if (this.cache != null) {
            this.cache.clear();
        }
        this.renderLayers.clear();
        LOGGER.info("Cleared rendering caches");
    }

    public CaxtonTextHandler getHandler() {
        return this.handler;
    }
}

