/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.flirora.caxton.mixin.RenderPhaseAccessor;

@OnlyIn(value=Dist.CLIENT)
public class WorldRendererVertexConsumerProvider
extends MultiBufferSource.BufferSource {
    private static final Set<String> CAXTON_TEXT_RENDER_LAYER_NAMES = ImmutableSet.of((Object)"caxton_text", (Object)"caxton_text_see_through", (Object)"caxton_text_outline");
    private static final Map<RenderType, BufferBuilder> caxtonTextLayerBuilders = new HashMap<RenderType, BufferBuilder>();

    public WorldRendererVertexConsumerProvider(BufferBuilder fallbackBuffer, Map<RenderType, BufferBuilder> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    private static boolean isCaxtonTextLayer(RenderType layer) {
        return CAXTON_TEXT_RENDER_LAYER_NAMES.contains(((RenderPhaseAccessor)layer).getName());
    }

    public VertexConsumer m_6299_(RenderType renderLayer) {
        Optional optional = renderLayer.m_110406_();
        BufferBuilder bufferBuilder = this.getBufferInternal(renderLayer);
        if (!Objects.equals(this.f_109906_, optional) || !renderLayer.m_234326_()) {
            RenderType currentLayer;
            if (this.f_109906_.isPresent() && !WorldRendererVertexConsumerProvider.isCaxtonTextLayer(currentLayer = (RenderType)this.f_109906_.get()) && !this.f_109905_.containsKey(currentLayer)) {
                this.m_109912_(currentLayer);
            }
            if (this.f_109907_.add(bufferBuilder)) {
                bufferBuilder.m_166779_(renderLayer.m_173186_(), renderLayer.m_110508_());
            }
            this.f_109906_ = optional;
        }
        return bufferBuilder;
    }

    private BufferBuilder getBufferInternal(RenderType layer) {
        if (WorldRendererVertexConsumerProvider.isCaxtonTextLayer(layer)) {
            return caxtonTextLayerBuilders.computeIfAbsent(layer, l -> new BufferBuilder(256));
        }
        return this.f_109905_.getOrDefault(layer, this.f_109904_);
    }

    public void m_173043_() {
        if (this.f_109906_.isPresent()) {
            RenderType renderLayer = (RenderType)this.f_109906_.get();
            if (!WorldRendererVertexConsumerProvider.isCaxtonTextLayer(renderLayer) && !this.f_109905_.containsKey(renderLayer)) {
                this.m_109912_(renderLayer);
            }
            this.f_109906_ = Optional.empty();
        }
    }

    public void m_109911_() {
        super.m_109911_();
        this.drawCaxtonTextLayers();
    }

    public void drawCaxtonTextLayers() {
        for (RenderType renderLayer : caxtonTextLayerBuilders.keySet()) {
            this.m_109912_(renderLayer);
        }
    }

    public void m_109912_(RenderType layer) {
        BufferBuilder bufferBuilder = this.getBufferInternal(layer);
        boolean layerIsCurrent = Objects.equals(this.f_109906_, layer.m_110406_());
        if (!layerIsCurrent && bufferBuilder == this.f_109904_) {
            return;
        }
        if (!this.f_109907_.remove(bufferBuilder)) {
            return;
        }
        layer.m_110412_(bufferBuilder, 0, 0, 0);
        if (layerIsCurrent) {
            this.f_109906_ = Optional.empty();
        }
    }
}

