/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_377;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.CaxtonFontStorage;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.FcIndexConverter;

@Environment(value=EnvType.CLIENT)
public record Run(String text, class_2583 style, @Nullable ConfiguredCaxtonFont font) {
    @NotNull
    public static List<Run> splitIntoRuns(class_5481 text, Function<class_2960, class_377> fonts, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        text.accept((class_5224)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsFormatted(class_5348 text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        class_5223.method_27476((class_5348)text, (class_2583)style, (class_5224)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsFormatted(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        class_5223.method_27479((String)text, (class_2583)style, (class_5224)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsFormatted(String text, Function<class_2960, class_377> fonts, class_2583 style, class_2583 baseStyle, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        class_5223.method_27473((String)text, (int)0, (class_2583)style, (class_2583)baseStyle, (class_5224)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsForwards(class_5348 text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        text.method_27658((style1, asString) -> {
            class_5223.method_27474((String)asString, (class_2583)style1.method_27702(style), (class_5224)lister);
            return Optional.empty();
        }, style);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsForwards(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        class_5223.method_27474((String)text, (class_2583)style, (class_5224)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsFormatted(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, FcIndexConverter formattingCodeStarts) {
        formattingCodeStarts.put(Integer.MIN_VALUE, 0);
        RunLister lister = new RunLister(fonts, validateAdvance);
        MutableInt numFormattingCodes = new MutableInt();
        class_5223.method_27479((String)text, (class_2583)style, (index, style1, codePoint) -> {
            if (index >= 2 && text.charAt(index - 2) == '\u00a7') {
                int numConsecutiveCodes = 1;
                for (int checkIndex = index - 4; checkIndex >= 0 && text.charAt(checkIndex) == '\u00a7'; checkIndex -= 2) {
                    ++numConsecutiveCodes;
                }
                int n = numFormattingCodes.addAndGet(numConsecutiveCodes);
                formattingCodeStarts.put(index - 2 * n, n);
            }
            return lister.accept(index, style1, codePoint);
        });
        return lister.getRuns();
    }

    public static class RunLister
    implements class_5224 {
        private final List<PendingRun> runs = new ArrayList<PendingRun>();
        private final Function<class_2960, class_377> fonts;
        private final boolean validateAdvance;

        public RunLister(Function<class_2960, class_377> fonts, boolean validateAdvance) {
            this.fonts = fonts;
            this.validateAdvance = validateAdvance;
        }

        public boolean accept(int index, class_2583 style, int codePoint) {
            ConfiguredCaxtonFont font = ((CaxtonFontStorage)this.fonts.apply(style.method_27708())).getCaxtonGlyph(codePoint, this.validateAdvance, style).getCaxtonFont();
            if (this.runs.isEmpty()) {
                this.addNewRun(codePoint, style, font);
            } else {
                PendingRun lastRun = this.runs.get(this.runs.size() - 1);
                if (lastRun.style.equals((Object)style) && lastRun.font == font) {
                    lastRun.appendCodePoint(codePoint);
                } else {
                    this.addNewRun(codePoint, style, font);
                }
            }
            return true;
        }

        private void addNewRun(int codePoint, class_2583 style, @Nullable ConfiguredCaxtonFont font) {
            this.runs.add(new PendingRun(new StringBuffer().appendCodePoint(codePoint), style, font));
        }

        public List<Run> getRuns() {
            return this.runs.stream().map(PendingRun::bake).collect(Collectors.toList());
        }
    }

    private static class PendingRun {
        private final StringBuffer contents;
        private final class_2583 style;
        @Nullable
        private final ConfiguredCaxtonFont font;

        private PendingRun(StringBuffer contents, class_2583 style, @Nullable ConfiguredCaxtonFont font) {
            this.contents = contents;
            this.style = style;
            this.font = font;
        }

        public void appendCodePoint(int codePoint) {
            this.contents.appendCodePoint(codePoint);
        }

        public Run bake() {
            String text = this.contents.toString();
            return new Run(text, this.style, this.font);
        }
    }
}

