/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.slf4j.Logger;

public class CaxtonAtlas
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static int PAGE_SIZE = 4096;
    private final List<Page> pages = new ArrayList<Page>();
    private final List<LongList> shelves = new ArrayList<LongList>();
    private final IntList unallocatedSpaces = new IntArrayList();
    private final class_1060 textureManager;

    public CaxtonAtlas(class_1060 textureManager) {
        this.textureManager = textureManager;
    }

    public static int getX(long packed) {
        return (int)(packed & 0x1FFFL);
    }

    public static int getY(long packed) {
        return (int)(packed >> 13 & 0x1FFFL);
    }

    public static int getW(long packed) {
        return (int)(packed >> 26 & 0x1FFFL);
    }

    public static int getH(long packed) {
        return (int)(packed >> 39 & 0x1FFFL);
    }

    public static int getPage(long packed) {
        return (int)(packed >>> 52);
    }

    private static long pack(int x, int y, int w, int h, int page) {
        return (long)x | (long)y << 13 | (long)w << 26 | (long)h << 39 | (long)page << 52;
    }

    private static int heightToBucketId(int height) {
        assert (height >= 1);
        return (height + 7) / 8 - 1;
    }

    private static int bucketIdToHeight(int bucket) {
        return 8 * (bucket + 1);
    }

    private int roundToNextPowerOf2(int n, int p) {
        return n + ((1 << p) - 1) >> p << p;
    }

    public class_2960 getAtlasPage(int pageNum) {
        return this.pages.get((int)pageNum).id;
    }

    public Page getAtlasPageTexture(int pageNum) {
        return this.pages.get(pageNum);
    }

    public int getNumPages() {
        return this.pages.size();
    }

    public List<Page> getAllPages() {
        return this.pages;
    }

    public long insert(int width, int height, int additionalMargin, int fontRange, int numMipmapLevels, class_1011.class_1012 format) {
        if (fontRange < 0 || fontRange >= 256) {
            throw new IllegalArgumentException("fontRange must be in [0, 256)");
        }
        if (width < 0) {
            throw new IllegalArgumentException("width must not be negative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must not be negative");
        }
        int totalWidth = this.roundToNextPowerOf2(width + additionalMargin, numMipmapLevels - 1);
        int totalHeight = this.roundToNextPowerOf2(height + additionalMargin, numMipmapLevels - 1);
        if (totalWidth > PAGE_SIZE) {
            throw new IllegalArgumentException("width + additionalMargin must not be greater than 4096");
        }
        if (totalHeight > PAGE_SIZE) {
            throw new IllegalArgumentException("height + additionalMargin must not be greater than 4096");
        }
        if (width == 0 || height == 0) {
            return CaxtonAtlas.pack(0, 0, width, height, 0);
        }
        long space = this.insertInternal(totalWidth, totalHeight, fontRange, numMipmapLevels, format);
        return CaxtonAtlas.pack(CaxtonAtlas.getX(space), CaxtonAtlas.getY(space), width, height, CaxtonAtlas.getPage(space));
    }

    private long insertInternal(int width, int height, int range, int numMipmapLevels, class_1011.class_1012 format) {
        int bucket = CaxtonAtlas.heightToBucketId(height);
        while (bucket >= this.shelves.size()) {
            this.shelves.add((LongList)new LongArrayList());
        }
        LongList shelvesInBucket = this.shelves.get(bucket);
        for (int i = shelvesInBucket.size() - 1; i >= 0; --i) {
            long prev;
            long shelf = shelvesInBucket.getLong(i);
            int x = CaxtonAtlas.getX(shelf);
            int y = CaxtonAtlas.getY(shelf);
            int page = CaxtonAtlas.getPage(shelf);
            if (x + width > PAGE_SIZE || CaxtonAtlas.getW(shelf) != numMipmapLevels || CaxtonAtlas.getH(shelf) != range || this.getAtlasPageTexture((int)page).format != format) continue;
            long space = CaxtonAtlas.pack(x, y, width, height, page);
            long remainingShelf = CaxtonAtlas.pack(x + width, y, numMipmapLevels, range, page);
            shelvesInBucket.set(i, remainingShelf);
            if (i > 0 && x + width > CaxtonAtlas.getW(prev = shelvesInBucket.getLong(i - 1))) {
                shelvesInBucket.set(i, prev);
                shelvesInBucket.set(i - 1, remainingShelf);
            }
            return space;
        }
        long shelf = this.allocateShelf(bucket, range, numMipmapLevels, format);
        int x = CaxtonAtlas.getX(shelf);
        int y = CaxtonAtlas.getY(shelf);
        int page = CaxtonAtlas.getPage(shelf);
        long remainingShelf = CaxtonAtlas.pack(width, y, numMipmapLevels, range, page);
        shelvesInBucket.add(remainingShelf);
        return CaxtonAtlas.pack(x, y, width, height, page);
    }

    private long allocateShelf(int bucket, int range, int numMipmapLevels, class_1011.class_1012 format) {
        int height = CaxtonAtlas.bucketIdToHeight(bucket);
        int minHeight = CaxtonAtlas.bucketIdToHeight(0);
        while (true) {
            int len = this.unallocatedSpaces.size();
            for (int i = 0; i < len; ++i) {
                int y2;
                int space = this.unallocatedSpaces.getInt(i);
                int y = space & 0xFFF;
                int page = space >> 12 & 0xFFF;
                Page pageTex = this.getAtlasPageTexture(page);
                if (pageTex.range != range || pageTex.numMipmapLevels != numMipmapLevels || pageTex.format != format || (y2 = y + height) > PAGE_SIZE) continue;
                if (y2 + minHeight <= PAGE_SIZE) {
                    this.unallocatedSpaces.set(i, y2 | page << 12);
                } else {
                    this.unallocatedSpaces.set(i, this.unallocatedSpaces.getInt(len - 1));
                    this.unallocatedSpaces.removeInt(len - 1);
                }
                return CaxtonAtlas.pack(0, y, numMipmapLevels, range, page);
            }
            this.addNewPage(range, numMipmapLevels, format);
        }
    }

    private void addNewPage(int range, int numMipmapLevels, class_1011.class_1012 format) {
        int pageNum = this.pages.size();
        if (pageNum >= 4096) {
            throw new RuntimeException("Only 4096 pages are supported");
        }
        LOGGER.info("I am {}", (Object)this);
        LOGGER.info("Adding a new page #{} with range {} and {} mipmap levels", new Object[]{pageNum, range, numMipmapLevels});
        Page page = new Page(this, pageNum, range, numMipmapLevels, format);
        this.pages.add(page);
        this.unallocatedSpaces.add(pageNum << 12);
    }

    @Override
    public void close() {
        for (Page page : this.pages) {
            page.close();
        }
        this.pages.clear();
        this.unallocatedSpaces.clear();
    }

    public void clear() {
        for (Page page : this.pages) {
            page.close();
        }
        this.pages.clear();
        this.shelves.clear();
        this.unallocatedSpaces.clear();
    }

    public static class Page
    extends class_1044 {
        private final class_2960 id;
        private final int range;
        private final int numMipmapLevels;
        private final class_1011.class_1012 format;

        public Page(CaxtonAtlas atlas, int pageNum, int range, int numMipmapLevels, class_1011.class_1012 format) {
            this.format = format;
            class_1011.class_1013 internalFormat = switch (format) {
                default -> throw new IncompatibleClassChangeError();
                case class_1011.class_1012.field_4997 -> class_1011.class_1013.field_5012;
                case class_1011.class_1012.field_5001 -> class_1011.class_1013.field_5011;
                case class_1011.class_1012.field_5002 -> class_1011.class_1013.field_33618;
                case class_1011.class_1012.field_4998 -> class_1011.class_1013.field_33619;
            };
            TextureUtil.prepareImage((class_1011.class_1013)internalFormat, (int)this.method_4624(), (int)(numMipmapLevels - 1), (int)PAGE_SIZE, (int)PAGE_SIZE);
            this.id = new class_2960("caxton", "atlas/" + pageNum);
            this.range = range;
            this.numMipmapLevels = numMipmapLevels;
            atlas.textureManager.method_4616(this.id, (class_1044)this);
        }

        public class_2960 getId() {
            return this.id;
        }

        public int getRange() {
            return this.range;
        }

        public int getNumMipmapLevels() {
            return this.numMipmapLevels;
        }

        public class_1011.class_1012 getFormat() {
            return this.format;
        }

        public void method_4625(class_3300 manager) {
        }

        public void close() {
            this.method_4528();
        }
    }
}

