/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import org.slf4j.Logger;
import xyz.flirora.caxton.command.ClientCommandSource;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;

public class DumpAtlasCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DynamicCommandExceptionType ATLAS_FAILED = new DynamicCommandExceptionType(i -> class_2561.method_43469((String)"caxton.command.caxtondumpatlas.atlasFailed", (Object[])new Object[]{i}));
    private static final SimpleCommandExceptionType LOCATION_DATA_FAILED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"caxton.command.caxtondumpatlas.locationDataFailed"));

    public static int run(CommandContext<?> context, ClientCommandSource source) throws CommandSyntaxException {
        class_310 client = source.getClient();
        File debugDir = new File(client.field_1697, "debug");
        File outputDir = new File(debugDir, "dumped-atlas-" + class_156.method_44893() + "-client");
        outputDir.mkdirs();
        class_327 vanillaRenderer = client.field_1772;
        CaxtonTextRenderer caxtonRenderer = ((HasCaxtonTextRenderer)vanillaRenderer).getCaxtonTextRenderer();
        CaxtonGlyphCache cache = caxtonRenderer.getCache();
        List<CaxtonAtlas.Page> pages = cache.getAtlas().getAllPages();
        Path outputPath = outputDir.toPath();
        for (int i = 0; i < pages.size(); ++i) {
            CaxtonAtlas.Page page = pages.get(i);
            int numMipmaps = page.getNumMipmapLevels();
            String name = "page" + i;
            TextureUtil.writeAsPNG((Path)outputPath, (String)name, (GpuTexture)page.method_68004(), (int)numMipmaps, color -> color);
        }
        Map<CaxtonFont, CaxtonGlyphCache.Font> locations = cache.getLocations();
        File locationsOut = new File(outputDir, "locations.json");
        try (FileWriter writer = new FileWriter(locationsOut);
             JsonWriter jsonWriter = GSON.newJsonWriter((Writer)writer);){
            jsonWriter.beginObject();
            for (Map.Entry<CaxtonFont, CaxtonGlyphCache.Font> fontEntry : locations.entrySet()) {
                CaxtonFont font = fontEntry.getKey();
                jsonWriter.name(font.getId().toString());
                jsonWriter.beginObject();
                for (Int2LongMap.Entry locationEntry : fontEntry.getValue().getEntry().int2LongEntrySet()) {
                    int glyphId = locationEntry.getIntKey();
                    String glyphName = font.getGlyphName(glyphId);
                    jsonWriter.name((String)(glyphName != null ? glyphName : "_glyph" + glyphId));
                    jsonWriter.beginObject();
                    long location = locationEntry.getLongValue();
                    jsonWriter.name("id").value((long)glyphId);
                    jsonWriter.name("x").value((long)CaxtonAtlas.getX(location));
                    jsonWriter.name("y").value((long)CaxtonAtlas.getY(location));
                    jsonWriter.name("width").value((long)CaxtonAtlas.getW(location));
                    jsonWriter.name("height").value((long)CaxtonAtlas.getH(location));
                    jsonWriter.name("page").value((long)CaxtonAtlas.getPage(location));
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Exception exception) {
            LOGGER.warn("Couldn\u2019t save location data", (Throwable)exception);
            throw LOCATION_DATA_FAILED.create();
        }
        source.sendFeedback(() -> class_2561.method_43469((String)"caxton.command.caxtondumpatlas.success", (Object[])new Object[]{outputDir}));
        return 1;
    }
}

