/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;

public class CaxtonAtlas
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static int PAGE_SIZE = 4096;
    private final List<Page> pages = new ArrayList<Page>();
    private final List<LongList> shelves = new ArrayList<LongList>();
    private final IntList unallocatedSpaces = new IntArrayList();
    private final class_1060 textureManager;
    private final Map<String, Page> pagesByGpuTexture = new IdentityHashMap<String, Page>();
    private final Float2ObjectMap<GpuBuffer> unitRangeBuffersByValue = new Float2ObjectArrayMap();

    public CaxtonAtlas(class_1060 textureManager) {
        this.textureManager = textureManager;
    }

    public static int getX(long packed) {
        return (int)(packed & 0x1FFFL);
    }

    public static int getY(long packed) {
        return (int)(packed >> 13 & 0x1FFFL);
    }

    public static int getW(long packed) {
        return (int)(packed >> 26 & 0x1FFFL);
    }

    public static int getH(long packed) {
        return (int)(packed >> 39 & 0x1FFFL);
    }

    public static int getPage(long packed) {
        return (int)(packed >>> 52);
    }

    private static long pack(int x, int y, int w, int h, int page) {
        return (long)x | (long)y << 13 | (long)w << 26 | (long)h << 39 | (long)page << 52;
    }

    private static int heightToBucketId(int height) {
        assert (height >= 1);
        return (height + 7) / 8 - 1;
    }

    private static int bucketIdToHeight(int bucket) {
        return 8 * (bucket + 1);
    }

    private int roundToNextPowerOf2(int n, int p) {
        return n + ((1 << p) - 1) >> p << p;
    }

    public Page getAtlasPageTexture(int pageNum) {
        return this.pages.get(pageNum);
    }

    public int getNumPages() {
        return this.pages.size();
    }

    public List<Page> getAllPages() {
        return this.pages;
    }

    public long insert(int width, int height, int additionalMargin, int fontRange, int numMipmapLevels, class_1011.class_1012 format, boolean blur) {
        if (fontRange < 0 || fontRange >= 256) {
            throw new IllegalArgumentException("fontRange must be in [0, 256)");
        }
        if (width < 0) {
            throw new IllegalArgumentException("width must not be negative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must not be negative");
        }
        int totalWidth = this.roundToNextPowerOf2(width + additionalMargin, numMipmapLevels - 1);
        int totalHeight = this.roundToNextPowerOf2(height + additionalMargin, numMipmapLevels - 1);
        if (totalWidth > PAGE_SIZE) {
            throw new IllegalArgumentException("width + additionalMargin must not be greater than 4096");
        }
        if (totalHeight > PAGE_SIZE) {
            throw new IllegalArgumentException("height + additionalMargin must not be greater than 4096");
        }
        if (width == 0 || height == 0) {
            return CaxtonAtlas.pack(0, 0, width, height, 0);
        }
        long space = this.insertInternal(totalWidth, totalHeight, fontRange, numMipmapLevels, format, blur);
        return CaxtonAtlas.pack(CaxtonAtlas.getX(space), CaxtonAtlas.getY(space), width, height, CaxtonAtlas.getPage(space));
    }

    private long insertInternal(int width, int height, int range, int numMipmapLevels, class_1011.class_1012 format, boolean blur) {
        int bucket = CaxtonAtlas.heightToBucketId(height);
        while (bucket >= this.shelves.size()) {
            this.shelves.add((LongList)new LongArrayList());
        }
        LongList shelvesInBucket = this.shelves.get(bucket);
        for (int i = shelvesInBucket.size() - 1; i >= 0; --i) {
            long prev;
            long shelf = shelvesInBucket.getLong(i);
            int x = CaxtonAtlas.getX(shelf);
            int y = CaxtonAtlas.getY(shelf);
            int page = CaxtonAtlas.getPage(shelf);
            if (x + width > PAGE_SIZE || CaxtonAtlas.getW(shelf) != numMipmapLevels || CaxtonAtlas.getH(shelf) != range || this.getAtlasPageTexture((int)page).format != format || this.getAtlasPageTexture((int)page).blur != blur) continue;
            long space = CaxtonAtlas.pack(x, y, width, height, page);
            long remainingShelf = CaxtonAtlas.pack(x + width, y, numMipmapLevels, range, page);
            shelvesInBucket.set(i, remainingShelf);
            if (i > 0 && x + width > CaxtonAtlas.getW(prev = shelvesInBucket.getLong(i - 1))) {
                shelvesInBucket.set(i, prev);
                shelvesInBucket.set(i - 1, remainingShelf);
            }
            return space;
        }
        long shelf = this.allocateShelf(bucket, range, numMipmapLevels, format, blur);
        int x = CaxtonAtlas.getX(shelf);
        int y = CaxtonAtlas.getY(shelf);
        int page = CaxtonAtlas.getPage(shelf);
        long remainingShelf = CaxtonAtlas.pack(width, y, numMipmapLevels, range, page);
        shelvesInBucket.add(remainingShelf);
        return CaxtonAtlas.pack(x, y, width, height, page);
    }

    private long allocateShelf(int bucket, int range, int numMipmapLevels, class_1011.class_1012 format, boolean blur) {
        int height = CaxtonAtlas.bucketIdToHeight(bucket);
        int minHeight = CaxtonAtlas.bucketIdToHeight(0);
        while (true) {
            int len = this.unallocatedSpaces.size();
            for (int i = 0; i < len; ++i) {
                int y2;
                int space = this.unallocatedSpaces.getInt(i);
                int y = space & 0xFFF;
                int page = space >> 12 & 0xFFF;
                Page pageTex = this.getAtlasPageTexture(page);
                if (pageTex.range != range || pageTex.numMipmapLevels != numMipmapLevels || pageTex.format != format || (y2 = y + height) > PAGE_SIZE) continue;
                if (y2 + minHeight <= PAGE_SIZE) {
                    this.unallocatedSpaces.set(i, y2 | page << 12);
                } else {
                    this.unallocatedSpaces.set(i, this.unallocatedSpaces.getInt(len - 1));
                    this.unallocatedSpaces.removeInt(len - 1);
                }
                return CaxtonAtlas.pack(0, y, numMipmapLevels, range, page);
            }
            this.addNewPage(range, numMipmapLevels, format, blur);
        }
    }

    private void addNewPage(int range, int numMipmapLevels, class_1011.class_1012 format, boolean blur) {
        int pageNum = this.pages.size();
        if (pageNum >= 4096) {
            throw new RuntimeException("Only 4096 pages are supported");
        }
        LOGGER.info("I am {}", (Object)this);
        LOGGER.info("Adding a new page #{} with range {}, {} mipmap levels, and {} interpolation", new Object[]{pageNum, range, numMipmapLevels, blur ? "linear" : "nearest"});
        Page page = new Page(this, pageNum, range, numMipmapLevels, format, blur);
        this.pages.add(page);
        this.pagesByGpuTexture.put(page.method_68004().getLabel(), page);
        this.unallocatedSpaces.add(pageNum << 12);
    }

    @Override
    public void close() {
        for (Page page : this.pages) {
            page.close();
        }
        this.pages.clear();
        this.pagesByGpuTexture.clear();
        this.unallocatedSpaces.clear();
    }

    public void clear() {
        for (Page page : this.pages) {
            page.close();
        }
        this.pages.clear();
        this.pagesByGpuTexture.clear();
        this.shelves.clear();
        this.unallocatedSpaces.clear();
    }

    @Nullable
    public Page getPageByGpuTexture(GpuTexture tex) {
        return this.pagesByGpuTexture.get(tex.getLabel());
    }

    public static class Page
    extends class_1044 {
        private static final int UNIT_RANGE_BUFFER_SIZE = new Std140SizeCalculator().putFloat().get();
        private final class_2960 id;
        private final int range;
        private final int numMipmapLevels;
        private final class_1011.class_1012 format;
        private final boolean blur;
        private final GpuBuffer unitRangeBuffer;

        public Page(CaxtonAtlas atlas, int pageNum, int range, int numMipmapLevels, class_1011.class_1012 format, boolean blur) {
            this.blur = blur;
            this.format = format;
            TextureFormat textureFormat = switch (format) {
                default -> throw new MatchException(null, null);
                case class_1011.class_1012.field_4997 -> TextureFormat.RGBA8;
                case class_1011.class_1012.field_5001 -> TextureFormat.RGBA8;
                case class_1011.class_1012.field_5002 -> TextureFormat.RGBA8;
                case class_1011.class_1012.field_4998 -> TextureFormat.RED8;
            };
            GpuDevice device = RenderSystem.getDevice();
            this.field_56974 = device.createTexture(() -> "Caxton atlas page #" + pageNum, 15, textureFormat, PAGE_SIZE, PAGE_SIZE, 1, numMipmapLevels);
            this.field_63613 = RenderSystem.getSamplerCache().method_75294(blur ? FilterMode.LINEAR : FilterMode.NEAREST);
            this.field_60597 = device.createTextureView(this.field_56974);
            device.createCommandEncoder().clearColorTexture(this.field_56974, 0);
            this.id = class_2960.method_60655((String)"caxton", (String)("atlas/" + pageNum));
            this.range = range;
            this.numMipmapLevels = numMipmapLevels;
            this.unitRangeBuffer = (GpuBuffer)atlas.unitRangeBuffersByValue.computeIfAbsent(this.getNormalizedRange(), unitRange -> {
                GpuBuffer ubo = device.createBuffer(() -> "Unit range UBO for page #" + pageNum, 136, UNIT_RANGE_BUFFER_SIZE);
                try (MemoryStack memoryStack = MemoryStack.stackPush();){
                    ByteBuffer byteBuffer = Std140Builder.onStack((MemoryStack)memoryStack, (int)RenderSystem.PROJECTION_MATRIX_UBO_SIZE).putFloat(unitRange).get();
                    device.createCommandEncoder().writeToBuffer(ubo.slice(), byteBuffer);
                }
                return ubo;
            });
            atlas.textureManager.method_4616(this.id, (class_1044)this);
        }

        public class_2960 getId() {
            return this.id;
        }

        private float getNormalizedRange() {
            return (float)this.range / (float)PAGE_SIZE;
        }

        public int getNumMipmapLevels() {
            return this.numMipmapLevels;
        }

        public class_1011.class_1012 getFormat() {
            return this.format;
        }

        public GpuBuffer getUnitRangeBuffer() {
            return this.unitRangeBuffer;
        }
    }
}

