/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_11768;
import net.minecraft.class_379;
import net.minecraft.class_382;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonFontOptions;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonGlyphMetrics;
import xyz.flirora.caxton.render.CaxtonTextRenderLayers;

public class CaxtonGlyphCache {
    private final CaxtonAtlas atlas;
    private final Map<CaxtonFont, Font> cache = new HashMap<CaxtonFont, Font>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public CaxtonGlyphCache(class_1060 textureManager) {
        this.atlas = new CaxtonAtlas(textureManager);
    }

    public Font forFont(CaxtonFont font) {
        return this.cache.computeIfAbsent(font, f -> {
            LOGGER.info("Adding entry for font {}", (Object)font);
            return new Font(font, (Int2LongMap)new Int2LongOpenHashMap(), (Int2ObjectMap<class_11768>)new Int2ObjectOpenHashMap());
        });
    }

    public CaxtonAtlas.Page getAtlasPageTexture(int pageNum) {
        int pageCount = this.atlas.getNumPages();
        if (pageNum >= pageCount) {
            LOGGER.error("*** ATLAS PAGE INDEX OUT OF BOUNDS: {} >= {} ***", (Object)pageNum, (Object)pageCount);
            LOGGER.error("This probably indicates a race condition.");
            LOGGER.error("See <https://gitlab.com/Kyarei/caxton/-/issues/44> for more details.");
            throw new IndexOutOfBoundsException("Al quira Prenia Callta caprinini");
        }
        return this.atlas.getAtlasPageTexture(pageNum);
    }

    public synchronized void clear() {
        LOGGER.info("Clearing glyph atlas with {} pages and {} fonts", (Object)this.atlas.getNumPages(), (Object)this.cache.size());
        this.cache.clear();
        this.atlas.clear();
    }

    public CaxtonAtlas getAtlas() {
        return this.atlas;
    }

    public Map<CaxtonFont, Font> getLocations() {
        return this.cache;
    }

    public class Font {
        private final CaxtonFont font;
        private final Int2LongMap entry;
        private final Int2ObjectMap<class_11768> entryBaked;

        private Font(CaxtonFont font, Int2LongMap entry, Int2ObjectMap<class_11768> entryBaked) {
            this.font = font;
            this.entry = entry;
            this.entryBaked = entryBaked;
        }

        public Int2LongMap getEntry() {
            return this.entry;
        }

        public long getOrCreateAtlasLocation(int glyphId) {
            return this.entry.computeIfAbsent(glyphId, id -> {
                long tlLoc = this.font.getTlistLocation(glyphId, 0);
                int width = (int)(tlLoc & 0xFFFFL);
                int height = (int)(tlLoc >> 16 & 0xFFFFL);
                int numMipmapLevels = this.font.getNumMipmapLevels();
                long location = CaxtonGlyphCache.this.atlas.insert(width, height, 1, this.font.getOptions().range(), numMipmapLevels, this.font.getPixelFormat(), this.font.getOptions().blur());
                if (location == 0L) {
                    return location;
                }
                GpuTexture page = CaxtonGlyphCache.this.atlas.getAtlasPageTexture(CaxtonAtlas.getPage(location)).method_68004();
                CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
                for (int mipmap = 0; mipmap < numMipmapLevels; ++mipmap) {
                    tlLoc = this.font.getTlistLocation(glyphId, mipmap);
                    width = (int)(tlLoc & 0xFFFFL);
                    height = (int)(tlLoc >> 16 & 0xFFFFL);
                    int offset = (int)(tlLoc >>> 32);
                    class_1011 nativeImage = new class_1011(this.font.getPixelFormat(), width, height, false, this.font.getPixelData(mipmap) + 4L * Integer.toUnsignedLong(offset));
                    commandEncoder.writeToTexture(page, nativeImage, mipmap, 0, CaxtonAtlas.getX(location) >> mipmap, CaxtonAtlas.getY(location) >> mipmap, width, height, 0, 0);
                }
                return location;
            });
        }

        @Nullable
        public class_11768 getBakedGlyph(int glyphId, CaxtonTextRenderLayers renderLayers, CaxtonGlyphCache cache, ConfiguredCaxtonFont configuredFont, boolean outline, float advance) {
            return (class_11768)this.entryBaked.computeIfAbsent(glyphId | (outline ? -268435456 : 0), id -> {
                long atlasLoc = this.getOrCreateAtlasLocation(glyphId);
                if (atlasLoc == 0L) {
                    return null;
                }
                int atlasX = CaxtonAtlas.getX(atlasLoc);
                int atlasY = CaxtonAtlas.getY(atlasLoc);
                int atlasWidth = CaxtonAtlas.getW(atlasLoc);
                int atlasHeight = CaxtonAtlas.getH(atlasLoc);
                int atlasPageIndex = CaxtonAtlas.getPage(atlasLoc);
                CaxtonAtlas.Page atlasPage = cache.getAtlasPageTexture(atlasPageIndex);
                float pageSize = CaxtonAtlas.PAGE_SIZE;
                float u0 = (float)atlasX / pageSize;
                float v0 = (float)atlasY / pageSize;
                float u1 = (float)(atlasX + atlasWidth) / pageSize;
                float v1 = (float)(atlasY + atlasHeight) / pageSize;
                CaxtonFontOptions options = this.font.getOptions();
                double shrink = options.shrinkage();
                int margin = options.margin();
                float scale = configuredFont.getScale();
                float x0 = (float)(-shrink * (double)margin * (double)scale);
                float y1 = (float)(shrink * (double)margin * (double)scale);
                float x1 = (float)(shrink * (double)(atlasWidth - margin) * (double)scale);
                float y0 = (float)(-shrink * (double)(atlasHeight - margin) * (double)scale);
                CaxtonGlyphMetrics metrics = new CaxtonGlyphMetrics(configuredFont.shadowOffset(), advance);
                return new class_382((class_379)metrics, renderLayers.renderLayerSet(atlasPage, options.fontTech(), outline), atlasPage.method_71659(), u0, u1, v0, v1, x0, x1, y0, y1);
            });
        }
    }
}

