/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11603;
import net.minecraft.class_11767;
import net.minecraft.class_11768;
import net.minecraft.class_11769;
import net.minecraft.class_12237;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_379;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_5819;
import net.minecraft.class_8030;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;
import xyz.flirora.caxton.layout.Threshold;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextRenderLayers;
import xyz.flirora.caxton.render.CaxtonTextRenderer;

@Environment(value=EnvType.CLIENT)
public class CaxtonTextDrawer
implements class_5224,
class_327.class_11465 {
    private final CaxtonTextRenderer textRenderer;
    private final boolean shadow;
    private final int color;
    private final int backgroundColor;
    private final boolean trackEmpty;
    private float x;
    private float y;
    private final List<class_11767.class_12238> glyphs;
    @Nullable
    private List<class_11767> rectangles;
    @Nullable
    private List<class_12237> emptyGlyphRects;
    private final float xRight;
    private final Threshold threshold;
    private final class_5819 random = class_5819.method_43053();
    private boolean outline = false;
    private float minX = Float.MAX_VALUE;
    private float minY = Float.MAX_VALUE;
    private float maxX = Float.MIN_VALUE;
    private float maxY = Float.MIN_VALUE;
    private float minBackgroundX = Float.MAX_VALUE;
    private float minBackgroundY = Float.MAX_VALUE;
    private float maxBackgroundX = Float.MIN_VALUE;
    private float maxBackgroundY = Float.MIN_VALUE;
    private static final float FOREGROUND_Z_INDEX = 0.001f;
    private static final float BACKGROUND_Z_INDEX = -0.001f;

    public CaxtonTextDrawer(CaxtonTextRenderer textRenderer, float x, float y, int color, int backgroundColor, boolean shadow, boolean trackEmpty, float xRight, Threshold threshold) {
        this.textRenderer = textRenderer;
        this.shadow = shadow;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.x = x;
        this.y = y;
        this.glyphs = new ArrayList<class_11767.class_12238>();
        this.xRight = xRight;
        this.threshold = threshold;
        this.trackEmpty = trackEmpty;
    }

    public CaxtonTextDrawer(CaxtonTextRenderer textRenderer, float x, float y, int color, boolean shadow, boolean trackEmpty, float xRight, Threshold threshold) {
        this(textRenderer, x, y, color, 0, shadow, trackEmpty, xRight, threshold);
    }

    public CaxtonTextDrawer outlined() {
        this.outline = true;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    private void updateTextBounds(float minX, float minY, float maxX, float maxY) {
        this.minX = Math.min(this.minX, minX);
        this.minY = Math.min(this.minY, minY);
        this.maxX = Math.max(this.maxX, maxX);
        this.maxY = Math.max(this.maxY, maxY);
    }

    private void updateBackgroundBounds(float x, float y, float width) {
        if (class_9848.method_61320((int)this.backgroundColor) != 0) {
            this.minBackgroundX = Math.min(this.minBackgroundX, x - 1.0f);
            this.minBackgroundY = Math.min(this.minBackgroundY, y - 1.0f);
            this.maxBackgroundX = Math.max(this.maxBackgroundX, x + width);
            this.maxBackgroundY = Math.max(this.maxBackgroundY, y + 9.0f);
            this.updateTextBounds(this.minBackgroundX, this.minBackgroundY, this.maxBackgroundX, this.maxBackgroundY);
        }
    }

    private void addGlyph(class_11767.class_12238 glyph) {
        this.glyphs.add(glyph);
        this.updateTextBounds(glyph.method_71829(), glyph.method_71830(), glyph.method_71831(), glyph.method_71832());
    }

    public void addRectangle(class_11767 rectangle) {
        if (this.rectangles == null) {
            this.rectangles = new ArrayList<class_11767>();
        }
        this.rectangles.add(rectangle);
        this.updateTextBounds(rectangle.method_71829(), rectangle.method_71830(), rectangle.method_71831(), rectangle.method_71832());
    }

    private void addEmptyGlyphRect(class_12237 glyph) {
        if (this.emptyGlyphRects == null) {
            this.emptyGlyphRects = new ArrayList<class_12237>();
        }
        this.emptyGlyphRects.add(glyph);
    }

    public boolean accept(int index, class_2583 style, int codePoint) {
        if (this.x >= this.xRight) {
            return false;
        }
        class_11603 glyphProvider = this.textRenderer.getGlyphs(style.method_27708());
        class_11768 glyph = glyphProvider.method_72736(codePoint);
        return this.accept(index, style, glyph);
    }

    public boolean accept(int index, class_2583 style, class_11768 glyph) {
        float shadowOffset;
        class_379 glyphMetrics = glyph.method_73398();
        boolean bold = style.method_10984();
        class_5251 textColor = style.method_10973();
        int renderColor = this.getRenderColor(textColor);
        int shadowColor = this.getShadowColor(style, renderColor);
        float advance = glyphMetrics.method_16798(bold);
        float x = index == 0 ? this.x - 1.0f : this.x;
        float boldOffset = bold ? glyphMetrics.method_16799() : 0.0f;
        class_11767.class_12238 drawnGlyph = glyph.method_73399(this.x, this.y, renderColor, shadowColor, style, boldOffset, shadowOffset = glyphMetrics.method_16800());
        if (drawnGlyph != null) {
            this.addGlyph(drawnGlyph);
        } else if (this.trackEmpty) {
            this.addEmptyGlyphRect(new class_12237(this.x, this.y, advance, 7.0f, 9.0f, style));
        }
        this.updateBackgroundBounds(this.x, this.y, advance);
        class_11769 rectangle = this.textRenderer.getFonts().method_73366();
        if (style.method_10986()) {
            this.addRectangle(rectangle.method_73406(x + shadowOffset, this.y + shadowOffset + 3.5f, this.x + shadowOffset + advance, this.y + shadowOffset + 4.5f, 0.001f, renderColor, shadowColor, shadowOffset));
        }
        if (style.method_10965()) {
            this.addRectangle(rectangle.method_73406(x + shadowOffset, this.y + shadowOffset + 8.0f, this.x + shadowOffset + advance, this.y + shadowOffset + 9.0f, 0.001f, renderColor, shadowColor, shadowOffset));
        }
        this.x += advance;
        this.threshold.updateLegacy(index);
        return true;
    }

    public boolean acceptShapedRun(ShapingResult shapedRun, RunGroup runGroup, int index, CaxtonGlyphCache cache, int glyphOffset, float minThickness, CaxtonTextRenderLayers renderLayers) {
        if (this.x >= this.xRight) {
            return false;
        }
        float origX = this.x;
        ConfiguredCaxtonFont configuredFont = runGroup.getFont();
        CaxtonFont font = configuredFont.font();
        CaxtonGlyphCache.Font cacheForFont = cache.forFont(font);
        class_11769 rectangle = this.textRenderer.getFonts().method_73366();
        assert (glyphOffset + font.getGlyphCount() <= font.getTlistSize());
        float shadowOffset = configuredFont.shadowOffset();
        float textZ = this.shadow ? 0.03f : 0.0f;
        int offset = runGroup.getBidiRuns()[4 * index + 0];
        short underlinePosition = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_POSITION);
        short underlineThickness = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_THICKNESS);
        short strikeoutPosition = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_POSITION);
        short strikeoutThickness = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_THICKNESS);
        float scale = configuredFont.getScale();
        float baselineY = this.y + 7.0f + configuredFont.shiftY();
        this.x += configuredFont.shiftX();
        float yu = baselineY - (float)underlinePosition * scale;
        float ys = baselineY - (float)strikeoutPosition * scale;
        float dyu = (float)underlineThickness * scale;
        float dys = (float)strikeoutThickness * scale;
        float ou = 0.5f * dyu;
        float os = 0.5f * dys;
        if (dyu < minThickness) {
            dyu = minThickness;
        }
        if (dys < minThickness) {
            dys = minThickness;
        }
        float y0u = yu + 0.5f * dyu;
        float y1u = yu - 0.5f * dyu;
        float y0s = ys + 0.5f * dys;
        float y1s = ys - 0.5f * dys;
        int numGlyphs = shapedRun.numGlyphs();
        int cumulAdvanceX = 0;
        for (int i = 0; i < numGlyphs; ++i) {
            int glyphId = shapedRun.glyphId(i);
            int clusterIndex = shapedRun.clusterIndex(i);
            if (this.threshold.updateCaxton(runGroup, index, shapedRun, i)) continue;
            class_2583 style = runGroup.getStyleAt(offset + clusterIndex);
            if (style.method_10987()) {
                long tlLoc = font.getTlistLocation(glyphId, 0);
                int width = (int)(tlLoc & 0xFFFFL);
                IntList others = (IntList)font.getGlyphsByWidth().get(width);
                glyphId = others.getInt(this.random.method_43048(others.size()));
            }
            int textColor = this.getRenderColor(style.method_10973());
            int shadowColor = this.getShadowColor(style, textColor);
            class_2583 drawnStyle = style.method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false));
            int advanceX = shapedRun.advanceX(i);
            int offsetX = shapedRun.offsetX(i);
            int offsetY = shapedRun.offsetY(i);
            int gx = cumulAdvanceX + offsetX;
            long atlasLoc = cacheForFont.getOrCreateAtlasLocation(glyphOffset + glyphId);
            class_11768 bakedGlyph = cacheForFont.getBakedGlyph(glyphId, renderLayers, cache, configuredFont, this.outline, (float)advanceX * scale);
            if (bakedGlyph != null) {
                int atlasPageIndex = CaxtonAtlas.getPage(atlasLoc);
                long glyphBbox = font.getBbox(glyphId);
                short bbXMin = (short)glyphBbox;
                short bbYMin = (short)(glyphBbox >> 16);
                float glyphX = this.x + (float)(gx += bbXMin) * scale;
                float glyphY = (float)(-(offsetY += bbYMin)) * scale + baselineY;
                this.addGlyph(bakedGlyph.method_73399(glyphX, glyphY, textColor, shadowColor, drawnStyle, 0.0f, configuredFont.shadowOffset()));
                this.updateBackgroundBounds(glyphX, this.y, (float)advanceX * scale);
                if (glyphX + (float)advanceX * scale >= this.xRight) break;
            }
            float x0a = this.x + (float)cumulAdvanceX * scale;
            float x1a = this.x + (float)(cumulAdvanceX + advanceX) * scale;
            if (style.method_10965()) {
                this.addRectangle(rectangle.method_73406(x0a, y1u, x1a, y0u, 0.001f + textZ, textColor, shadowColor, shadowOffset));
            }
            if (style.method_10986()) {
                this.addRectangle(rectangle.method_73406(x0a, y1s, x1a, y0s, 0.001f + textZ, textColor, shadowColor, shadowOffset));
            }
            cumulAdvanceX += advanceX;
        }
        this.x = origX + (float)cumulAdvanceX * scale - configuredFont.shiftX();
        return true;
    }

    public int getRenderColor(@Nullable class_5251 override) {
        if (override != null && !this.outline) {
            int alpha = class_9848.method_61320((int)this.color);
            int rgb = override.method_27716();
            return class_9848.method_61330((int)alpha, (int)rgb);
        }
        return this.color;
    }

    public int getShadowColor(class_2583 style, int renderColor) {
        Integer shadowColor = style.method_65301();
        if (shadowColor != null) {
            float textAlpha = class_9848.method_65100((int)renderColor);
            float shadowAlpha = class_9848.method_65100((int)shadowColor);
            return textAlpha != 1.0f ? class_9848.method_61330((int)class_9848.method_61326((float)(textAlpha * shadowAlpha)), (int)shadowColor) : shadowColor;
        }
        return this.shadow ? class_9848.method_61321((int)renderColor, (float)0.25f) : 0;
    }

    public float getForegroundZIndex() {
        return 0.001f;
    }

    public void method_71801(class_327.class_11464 glyphDrawer) {
        Object bakedGlyph = null;
        if (class_9848.method_61320((int)this.backgroundColor) != 0) {
            glyphDrawer.method_71798(this.textRenderer.getFonts().method_73366().method_73406(this.minBackgroundX, this.minBackgroundY, this.maxBackgroundX, this.maxBackgroundY, -0.001f, this.backgroundColor, 0, 0.0f));
        }
        for (class_11767.class_12238 drawnGlyph : this.glyphs) {
            glyphDrawer.method_71797(drawnGlyph);
        }
        if (this.rectangles != null) {
            for (class_11767 rectangle2 : this.rectangles) {
                glyphDrawer.method_71798(rectangle2);
            }
        }
        if (this.emptyGlyphRects != null) {
            for (class_12237 emptyGlyphRect : this.emptyGlyphRects) {
                glyphDrawer.method_75775(emptyGlyphRect);
            }
        }
    }

    @Nullable
    public class_8030 method_71800() {
        if (!(this.minX >= this.maxX) && !(this.minY >= this.maxY)) {
            int minX = class_3532.method_15375((float)this.minX);
            int minY = class_3532.method_15375((float)this.minY);
            int maxX = class_3532.method_15375((float)this.maxX) + 1;
            int maxY = class_3532.method_15375((float)this.maxY) + 1;
            return new class_8030(minX, minY, maxX - minX, maxY - minY);
        }
        return null;
    }
}

