/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_389;
import net.minecraft.class_390;
import net.minecraft.class_394;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.dll.LibraryLoading;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonTypeface;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;

@Environment(value=EnvType.CLIENT)
public class CaxtonFontLoader
implements class_389 {
    public static final String FONT_PREFIX = "textures/font/";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<class_2960, CaxtonFont> CACHE = new ConcurrentHashMap<class_2960, CaxtonFont>();
    private static final JsonObject EMPTY = new JsonObject();
    private final ConfiguredCaxtonFont.Loader regular;
    @Nullable
    private final ConfiguredCaxtonFont.Loader bold;
    @Nullable
    private final ConfiguredCaxtonFont.Loader italic;
    @Nullable
    private final ConfiguredCaxtonFont.Loader boldItalic;
    public static final MapCodec<CaxtonFontLoader> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ConfiguredCaxtonFont.Loader.CODEC.fieldOf("regular").forGetter(x -> x.regular), (App)ConfiguredCaxtonFont.Loader.CODEC.optionalFieldOf("bold").forGetter(x -> Optional.ofNullable(x.bold)), (App)ConfiguredCaxtonFont.Loader.CODEC.optionalFieldOf("italic").forGetter(x -> Optional.ofNullable(x.italic)), (App)ConfiguredCaxtonFont.Loader.CODEC.optionalFieldOf("bold_italic").forGetter(x -> Optional.ofNullable(x.boldItalic))).apply((Applicative)instance, (regular, bold, italic, boldItalic) -> new CaxtonFontLoader((ConfiguredCaxtonFont.Loader)regular, bold.orElse(null), italic.orElse(null), boldItalic.orElse(null))));

    public CaxtonFontLoader(ConfiguredCaxtonFont.Loader regular, @Nullable ConfiguredCaxtonFont.Loader bold, @Nullable ConfiguredCaxtonFont.Loader italic, @Nullable ConfiguredCaxtonFont.Loader boldItalic) {
        this.regular = regular;
        this.bold = bold;
        this.italic = italic;
        this.boldItalic = boldItalic;
    }

    @Nullable
    public static CaxtonFont loadFontByIdentifier(class_3300 manager, @Nullable class_2960 id) {
        if (id == null) {
            return null;
        }
        return CACHE.computeIfAbsent(id, id1 -> {
            CaxtonFont caxtonFont;
            block17: {
                LOGGER.info("Loading font {}", (Object)id);
                class_2960 fontId = id1.method_45138(FONT_PREFIX);
                class_2960 metaId = fontId.method_45134(path -> path + ".json");
                JsonObject optionsJson = EMPTY;
                Optional metaResource = manager.method_14486(metaId);
                if (metaResource.isPresent()) {
                    try (BufferedReader metaInput = ((class_3298)metaResource.get()).method_43039();){
                        optionsJson = class_3518.method_15255((Reader)metaInput);
                        String path2 = class_3518.method_15253((JsonObject)optionsJson, (String)"path", null);
                        if (path2 != null) {
                            fontId = new class_2960(path2).method_45138(FONT_PREFIX);
                        }
                    }
                }
                InputStream input = manager.open(fontId);
                try {
                    caxtonFont = new CaxtonFont(input, (class_2960)id1, optionsJson);
                    if (input == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                input.close();
            }
            return caxtonFont;
        }).cloneReference();
    }

    public static void clearFontCache() {
        LOGGER.info("Clearing {} loaded font(s)", (Object)CACHE.size());
        CACHE.forEach((id, font) -> font.close());
        CACHE.clear();
    }

    public static CaxtonFont getFontById(class_2960 id) {
        return CACHE.get(id);
    }

    public static Stream<class_2960> getAvailableFontIds() {
        System.err.println(CACHE);
        return CACHE.keySet().stream();
    }

    @Nullable
    public class_390 load(class_3300 manager) throws IOException {
        if (!LibraryLoading.isLibraryLoaded()) {
            throw new IOException("Refusing to load Caxton font when native library loading had failed");
        }
        try {
            ConfiguredCaxtonFont regular = ConfiguredCaxtonFont.load(manager, this.regular);
            ConfiguredCaxtonFont bold = ConfiguredCaxtonFont.load(manager, this.bold);
            ConfiguredCaxtonFont italic = ConfiguredCaxtonFont.load(manager, this.italic);
            ConfiguredCaxtonFont boldItalic = ConfiguredCaxtonFont.load(manager, this.boldItalic);
            return new CaxtonTypeface(regular, bold, italic, boldItalic);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load truetype font", (Throwable)exception);
            throw new IOException(exception);
        }
    }

    public Either<class_389.class_8539, class_389.class_8540> method_51734() {
        return Either.left(this::load);
    }

    public class_394 method_51731() {
        return CaxtonModClient.CAXTON_FONT_TYPE;
    }
}

