/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.FontTech;

@Environment(value=EnvType.CLIENT)
public record CaxtonFontOptions(FontTech fontTech, double shrinkage, int margin, int range, Invert invert) {
    public CaxtonFontOptions {
        if (shrinkage <= 0.0) {
            throw new IllegalArgumentException("shrinkage must be positive");
        }
        if (margin < 0) {
            margin = range;
        }
        if (range <= 0) {
            throw new IllegalArgumentException("range must be positive");
        }
        if (range >= 256) {
            throw new IllegalArgumentException("range cannot be greater than 255");
        }
    }

    public CaxtonFontOptions(JsonObject json) {
        this(FontTech.fromName(class_3518.method_15253((JsonObject)json, (String)"tech", (String)"msdf")), class_3518.method_34915((JsonObject)json, (String)"shrinkage", (double)32.0), class_3518.method_15282((JsonObject)json, (String)"margin", (int)-1), class_3518.method_15282((JsonObject)json, (String)"range", (int)4), Invert.fromJson(json.get("invert")));
    }

    public static enum Invert {
        UNSET,
        FALSE,
        TRUE;


        public static Invert fromJson(@Nullable JsonElement json) {
            if (json == null || json.isJsonNull()) {
                return UNSET;
            }
            try {
                boolean b = json.getAsBoolean();
                return b ? TRUE : FALSE;
            }
            catch (Exception e) {
                throw new JsonSyntaxException("invert must be true, false, or null", (Throwable)e);
            }
        }
    }
}

