/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.dll.CaxtonInternal;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonFontLoader;
import xyz.flirora.caxton.layout.ShapingResult;

@Environment(value=EnvType.CLIENT)
public record ConfiguredCaxtonFont(CaxtonFont font, long ptr, float shadowOffset, float computedScaleFactor, boolean blur, float shiftX, float shiftY, float slant) implements AutoCloseable
{
    @Nullable
    public static ConfiguredCaxtonFont load(class_3300 manager, @Nullable Loader settings) {
        if (settings == null) {
            return null;
        }
        String config = settings.settings == null ? null : settings.settings.toString();
        CaxtonFont font = CaxtonFontLoader.loadFontByIdentifier(manager, settings.id);
        if (font == null) {
            throw new RuntimeException("font " + String.valueOf(settings.id) + " does not exist");
        }
        long ptr = CaxtonInternal.configureFont(font.getFontPtr(), config);
        float shadowOffset = 1.0f;
        double scaleFactor = 1.0;
        boolean blur = false;
        float shiftX = 0.0f;
        float shiftY = 0.0f;
        float slant = 0.0f;
        if (settings.settings != null) {
            shadowOffset = class_3518.method_15277((JsonObject)settings.settings, (String)"shadow_offset", (float)shadowOffset);
            scaleFactor = class_3518.method_34915((JsonObject)settings.settings, (String)"scale_factor", (double)scaleFactor);
            blur = class_3518.method_15258((JsonObject)settings.settings, (String)"blur", (boolean)blur);
            JsonElement shiftE = settings.settings.get("shift");
            if (shiftE instanceof JsonArray) {
                JsonArray shift = (JsonArray)shiftE;
                if (shift.size() != 2) {
                    throw new JsonSyntaxException("shift must have 2 elements");
                }
                shiftX = shift.get(0).getAsFloat();
                shiftY = shift.get(1).getAsFloat();
            } else if (shiftE != null) {
                throw new JsonSyntaxException("shift must be an array");
            }
            slant = -Float.intBitsToFloat(class_3518.method_15282((JsonObject)settings.settings, (String)"the_font_designer_couldnt_be_assed_to_make_an_italic_variant_so_slant_the_text", (int)0));
        }
        float computedScaleFactor = (float)(7.0 * scaleFactor / (double)font.getMetrics(CaxtonFont.Metrics.ASCENDER));
        return new ConfiguredCaxtonFont(font, ptr, shadowOffset, computedScaleFactor, blur, shiftX, shiftY, slant);
    }

    @Override
    public void close() {
        CaxtonInternal.destroyConfiguredFont(this.ptr);
        this.font.close();
    }

    public float getScale() {
        return this.computedScaleFactor;
    }

    public ShapingResult[] shape(char[] s, int[] bidiRuns) {
        return CaxtonInternal.shape(this.ptr, s, bidiRuns);
    }

    public record Loader(class_2960 id, @Nullable JsonObject settings) {
        private static final Codec<class_2960> FILE_FIELD_CODEC = class_2960.field_25139.fieldOf("file").codec();
        public static final Codec<Loader> CODEC = Codec.either((Codec)class_2960.field_25139.xmap(id -> new Loader((class_2960)id, null), Loader::id), (Codec)Codec.PASSTHROUGH.comapFlatMap(obj -> {
            JsonElement elem = (JsonElement)obj.cast((DynamicOps)JsonOps.INSTANCE);
            if (!(elem instanceof JsonObject)) {
                return DataResult.error(() -> "Not a JSON object: " + String.valueOf(elem));
            }
            JsonObject settings = (JsonObject)elem;
            return FILE_FIELD_CODEC.parse(obj).map(id -> new Loader((class_2960)id, settings));
        }, loader -> new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)loader.settings))).xmap(either -> either.left().orElse((Loader)either.right().get()), x -> x.settings == null ? Either.left((Object)x) : Either.right((Object)x));
    }
}

