/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_284;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.font.FontTech;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonShaders;
import xyz.flirora.caxton.render.CaxtonTextLayerType;
import xyz.flirora.caxton.render.ShaderExt;

@Environment(value=EnvType.CLIENT)
public class CaxtonTextRenderLayers {
    private final Group msdf = new Group(RenderLayerFunctions::ofText, RenderLayerFunctions::ofTextSeeThrough, RenderLayerFunctions::ofTextOffset, RenderLayerFunctions::ofTextOutline);
    private final Group raster = new Group(RenderLayerFunctions::ofTextR, RenderLayerFunctions::ofTextSeeThroughR, RenderLayerFunctions::ofTextOffsetR, RenderLayerFunctions::ofTextR);
    private final Group rasterAa = new Group(RenderLayerFunctions::ofTextRA, RenderLayerFunctions::ofTextSeeThroughRA, RenderLayerFunctions::ofTextOffsetRA, RenderLayerFunctions::ofTextRA);

    public void clear() {
        this.msdf.clear();
        this.raster.clear();
    }

    public class_1921 text(CaxtonAtlas.Page page, CaxtonTextLayerType layerType, FontTech tech, boolean blur) {
        return switch (tech) {
            default -> throw new MatchException(null, null);
            case FontTech.MSDF -> this.msdf.text(page, layerType);
            case FontTech.RASTER -> (blur ? this.rasterAa : this.raster).text(page, layerType);
        };
    }

    public static class Group {
        private final ConcurrentHashMap<CaxtonAtlas.Page, class_1921> text = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, class_1921> textSeeThrough = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, class_1921> textOffset = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, class_1921> textOutline = new ConcurrentHashMap();
        private final Function<CaxtonAtlas.Page, class_1921> ofText;
        private final Function<CaxtonAtlas.Page, class_1921> ofTextSeeThrough;
        private final Function<CaxtonAtlas.Page, class_1921> ofTextOffset;
        private final Function<CaxtonAtlas.Page, class_1921> ofTextOutline;

        public Group(Function<CaxtonAtlas.Page, class_1921> ofText, Function<CaxtonAtlas.Page, class_1921> ofTextSeeThrough, Function<CaxtonAtlas.Page, class_1921> ofTextOffset, Function<CaxtonAtlas.Page, class_1921> ofTextOutline) {
            this.ofText = ofText;
            this.ofTextSeeThrough = ofTextSeeThrough;
            this.ofTextOffset = ofTextOffset;
            this.ofTextOutline = ofTextOutline;
        }

        public void clear() {
            this.text.clear();
            this.textSeeThrough.clear();
            this.textOffset.clear();
            this.textOutline.clear();
        }

        public class_1921 text(CaxtonAtlas.Page page, CaxtonTextLayerType layerType) {
            return switch (layerType) {
                default -> throw new MatchException(null, null);
                case CaxtonTextLayerType.NORMAL -> this.text.computeIfAbsent(page, this.ofText);
                case CaxtonTextLayerType.SEE_THROUGH -> this.textSeeThrough.computeIfAbsent(page, this.ofTextSeeThrough);
                case CaxtonTextLayerType.OUTLINE -> this.textOutline.computeIfAbsent(page, this.ofTextOutline);
                case CaxtonTextLayerType.POLYGON_OFFSET -> this.textOffset.computeIfAbsent(page, this.ofTextOffset);
            };
        }
    }

    private static class RenderLayerFunctions
    extends class_1921 {
        public RenderLayerFunctions(String name, class_293 vertexFormat, class_293.class_5596 drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
        }

        private static class_1921 make(String name, Supplier<class_5944> shader, CaxtonAtlas.Page page, boolean seeThrough, boolean rasterized, boolean blur, boolean polygonOffset) {
            return class_1921.method_24049((String)name, (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)CaxtonModClient.CONFIG.sortTextRenderLayers, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578((class_4668.class_5942)new Shayder(shader, RenderLayerFunctions.handleTextShader(page, !rasterized))).method_34577((class_4668.class_5939)new class_4668.class_4683(page.getId(), blur, page.getNumMipmapLevels() > 1)).method_23615(field_21370).method_23608(field_21383).method_23604(seeThrough ? class_4668.field_21346 : class_4668.field_21348).method_23607(polygonOffset ? class_4668.field_21353 : class_4668.field_21352).method_23617(false));
        }

        private static class_1921 ofText(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text", () -> CaxtonShaders.caxtonTextShader, page, false, false, true, false);
        }

        private static class_1921 ofTextSeeThrough(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through", () -> CaxtonShaders.caxtonTextSeeThroughShader, page, true, false, true, false);
        }

        private static class_1921 ofTextOffset(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text", () -> CaxtonShaders.caxtonTextShader, page, false, false, true, true);
        }

        private static class_1921 ofTextOutline(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline", () -> CaxtonShaders.caxtonTextOutlineShader, page, false, false, true, false);
        }

        private static class_1921 ofTextR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_raster", class_757::method_36432, page, false, true, false, false);
        }

        private static class_1921 ofTextSeeThroughR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through_raster", class_757::method_36433, page, true, true, false, false);
        }

        private static class_1921 ofTextOffsetR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline_raster", class_757::method_36432, page, false, true, false, true);
        }

        private static class_1921 ofTextRA(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_raster", class_757::method_36432, page, false, true, true, false);
        }

        private static class_1921 ofTextSeeThroughRA(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through_raster", class_757::method_36433, page, true, true, true, false);
        }

        private static class_1921 ofTextOffsetRA(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline_raster", class_757::method_36432, page, false, true, true, true);
        }

        private static Consumer<class_5944> handleTextShader(CaxtonAtlas.Page texId, boolean setUniforms) {
            if (!setUniforms) {
                return shader -> {};
            }
            return shader -> {
                if (shader == null) {
                    return;
                }
                class_284 unitRange = ((ShaderExt)shader).caxton$getUnitRange();
                if (unitRange != null) {
                    unitRange.method_1251((float)texId.getRange() / (float)CaxtonAtlas.PAGE_SIZE);
                }
            };
        }

        public static class Shayder
        extends class_4668.class_5942 {
            public Shayder(Supplier<class_5944> supplier, Consumer<class_5944> callback) {
                super(() -> {
                    class_5944 shader = (class_5944)supplier.get();
                    callback.accept(shader);
                    return shader;
                });
            }
        }
    }
}

