/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.dll;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import java.util.Scanner;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.Platform;
import org.slf4j.Logger;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.dll.RustPlatform;
import xyz.flirora.caxton.dll.UnsupportedPlatformException;

public class LibraryLoading {
    private static final class_2561 UNSUPPORTED_PLATFORM = new class_2588("caxton.gui.unsupportedPlatform").method_27692(class_124.field_1067);
    private static final class_2561 LIBRARY_LOADING_FAILED = new class_2588("caxton.gui.libraryLoadingFailed").method_27692(class_124.field_1067);
    private static final class_2561 UNSUPPORTED_PLATFORM_DESC = new class_2588("caxton.gui.unsupportedPlatform.description");
    private static final class_2561 UNSUPPORTED_PLATFORM_DESC_OSX = new class_2588("caxton.gui.unsupportedPlatform.description.osx").method_10852((class_2561)new class_2588("caxton.gui.unsupportedPlatform.description.osx2").method_27692(class_124.field_1067));
    private static final class_2561 LIBRARY_LOADING_FAILED_DESC = new class_2588("caxton.gui.libraryLoadingFailed.description");
    public static final String ISSUES_URL = "https://gitlab.com/Kyarei/caxton/-/issues";
    private static final class_2561 LIBRARY_LOADING_FAILED_LINK = new class_2588("caxton.gui.libraryLoadingFailed.link", new Object[]{"https://gitlab.com/Kyarei/caxton/-/issues"});
    public static final String OS_SUPPORT_URL = "https://gitlab.com/Kyarei/caxton#os-support";
    private static final class_2561 UNSUPPORTED_PLATFORM_LINK = new class_2588("caxton.gui.unsupportedPlatform.link", new Object[]{"https://gitlab.com/Kyarei/caxton#os-support"});
    private static Exception loadingException = new IllegalStateException("library not yet loaded");

    public static Exception getLoadingException() {
        return loadingException;
    }

    public static boolean isLibraryLoaded() {
        return loadingException == null;
    }

    public static void loadNativeLibrary(Logger logger) {
        logger.info("Extracting and loading library for {} / {}", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.arch"));
        File runDirectory = class_310.method_1551().field_1697;
        String soName = System.mapLibraryName("caxton_impl");
        String soNameWithPlatform = RustPlatform.forCurrent() + "-" + soName;
        Metadata metadata = LibraryLoading.readFromChecksumsTxt(soNameWithPlatform, logger);
        try (InputStream libStream = CaxtonModClient.class.getResourceAsStream("/natives/" + soNameWithPlatform);){
            if (libStream == null) {
                throw new UnsupportedPlatformException("Could not find " + soNameWithPlatform);
            }
            File tmp = new File(runDirectory, soName);
            if (LibraryLoading.shouldRewrite(tmp, metadata, logger)) {
                logger.info("Writing native library to {}", (Object)tmp);
                try (FileOutputStream output = new FileOutputStream(tmp);){
                    libStream.transferTo(output);
                }
            } else {
                logger.info("Skipping copying native library because size and hash matched");
            }
            System.load(tmp.getAbsolutePath());
            loadingException = null;
        }
        catch (Exception e) {
            logger.error("Failed to load library", (Throwable)e);
            loadingException = e;
        }
    }

    private static boolean isMacOs() {
        return Platform.get() == Platform.MACOSX;
    }

    private static class_2561 getTitle(Exception e) {
        return e instanceof UnsupportedPlatformException ? UNSUPPORTED_PLATFORM : LIBRARY_LOADING_FAILED;
    }

    private static class_2561 getDescriptionText(Exception e) {
        boolean unsupported = e instanceof UnsupportedPlatformException;
        class_2561 description = unsupported ? (LibraryLoading.isMacOs() ? UNSUPPORTED_PLATFORM_DESC_OSX : UNSUPPORTED_PLATFORM_DESC) : LIBRARY_LOADING_FAILED_DESC;
        class_2561 link = unsupported ? UNSUPPORTED_PLATFORM_LINK : LIBRARY_LOADING_FAILED_LINK;
        return new class_2588("caxton.gui.failDescription", new Object[]{description, System.getProperty("os.name"), System.getProperty("os.arch"), link});
    }

    public static class_437 nativeLibraryLoadFailedScreen(BooleanConsumer callback, Exception e) {
        return new MyConfirmChatLinkScreen(callback, e);
    }

    public static void showNativeLibraryLoadFailedScreen(class_310 client, Exception e) {
        class_437 screen = client.field_1755;
        client.method_1507(LibraryLoading.nativeLibraryLoadFailedScreen(confirmed -> {
            if (confirmed) {
                String url = e instanceof UnsupportedPlatformException ? OS_SUPPORT_URL : ISSUES_URL;
                class_156.method_668().method_670(url);
            }
            client.method_1507(screen);
        }, e));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Metadata readFromChecksumsTxt(String soName, Logger logger) {
        try (InputStream checksums = CaxtonModClient.class.getResourceAsStream("/natives/checksums.txt");){
            String[] comps;
            block12: {
                Scanner scanner = new Scanner(Objects.requireNonNull(checksums, "checksums.txt not found"));
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.isEmpty()) continue;
                    comps = line.split("\t");
                    if (comps.length != 3) {
                        throw new IOException("Malformed line in checksums.txt: " + line);
                    }
                    if (!comps[0].equals(soName)) {
                        continue;
                    }
                    break block12;
                }
                return null;
            }
            Metadata metadata = new Metadata(Integer.parseInt(comps[1]), comps[2]);
            return metadata;
        }
        catch (IOException e) {
            logger.error("Could not read checksums.txt", (Throwable)e);
        }
        return null;
    }

    private static boolean shouldRewrite(File dest, @Nullable Metadata metadata, Logger logger) {
        try {
            if (metadata == null) {
                return true;
            }
            if (!dest.exists()) {
                return true;
            }
            if (Files.size(dest.toPath()) != (long)metadata.size) {
                return true;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream stream = new FileInputStream(dest);){
                byte[] contents;
                while ((contents = stream.readNBytes(4096)).length != 0) {
                    digest.update(contents);
                }
            }
            String digestStr = Base64.getEncoder().encodeToString(digest.digest());
            return !digestStr.equals(metadata.sha256Base64);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            logger.error("Could not determine whether we need to overwrite existing file in .minecraft; assuming that we do", (Throwable)e);
            return true;
        }
    }

    private record Metadata(int size, String sha256Base64) {
    }

    private static class MyConfirmChatLinkScreen
    extends class_410 {
        private static final class_2561 COPY = new class_2588("chat.copy");
        private final String link;

        public MyConfirmChatLinkScreen(BooleanConsumer callback, Exception e) {
            super(callback, LibraryLoading.getTitle(e), LibraryLoading.getDescriptionText(e));
            this.field_2402 = new class_2588("caxton.learnMore");
            this.field_2399 = new class_2588("caxton.acknowledge");
            this.link = LibraryLoading.OS_SUPPORT_URL;
        }

        protected void method_37051(int y) {
            this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 50 - 105, this.field_22790 / 6 + 96, 100, 20, this.field_2402, button -> this.field_2403.accept(true)));
            this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 50, this.field_22790 / 6 + 96, 100, 20, COPY, button -> {
                this.copyToClipboard();
                this.field_2403.accept(false);
            }));
            this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 50 + 105, this.field_22790 / 6 + 96, 100, 20, this.field_2399, button -> this.field_2403.accept(false)));
        }

        public void copyToClipboard() {
            this.field_22787.field_1774.method_1455(this.link);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
    }
}

