/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_389;
import net.minecraft.class_390;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.flirora.caxton.dll.LibraryLoading;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonTypeface;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;

@Environment(value=EnvType.CLIENT)
public class CaxtonFontLoader
implements class_389 {
    public static final String FONT_PREFIX = "textures/font/";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<class_2960, CaxtonFont> CACHE = new ConcurrentHashMap<class_2960, CaxtonFont>();
    private static final JsonObject EMPTY = new JsonObject();
    private final ConfiguredCaxtonFont.Loader regular;
    @Nullable
    private final ConfiguredCaxtonFont.Loader bold;
    @Nullable
    private final ConfiguredCaxtonFont.Loader italic;
    @Nullable
    private final ConfiguredCaxtonFont.Loader boldItalic;

    public CaxtonFontLoader(ConfiguredCaxtonFont.Loader regular, @Nullable ConfiguredCaxtonFont.Loader bold, @Nullable ConfiguredCaxtonFont.Loader italic, @Nullable ConfiguredCaxtonFont.Loader boldItalic) {
        this.regular = regular;
        this.bold = bold;
        this.italic = italic;
        this.boldItalic = boldItalic;
    }

    @Nullable
    private static ConfiguredCaxtonFont.Loader parseConfiguredFontLoader(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            return new ConfiguredCaxtonFont.Loader(class_2960.method_12829((String)class_3518.method_15265((JsonObject)object, (String)"file")), object);
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            return new ConfiguredCaxtonFont.Loader(class_2960.method_12829((String)primitive.getAsString()), null);
        }
        throw new JsonParseException("expected identifier or object; got something else");
    }

    @Nullable
    private static class_2960 getOptionalIdentifier(JsonObject json, String key) {
        String id = class_3518.method_15253((JsonObject)json, (String)key, null);
        return id == null ? null : new class_2960(id);
    }

    public static class_389 fromJson(JsonObject json) {
        return new CaxtonFontLoader(CaxtonFontLoader.parseConfiguredFontLoader(json.get("regular")), CaxtonFontLoader.parseConfiguredFontLoader(json.get("bold")), CaxtonFontLoader.parseConfiguredFontLoader(json.get("italic")), CaxtonFontLoader.parseConfiguredFontLoader(json.get("bold_italic")));
    }

    @Nullable
    public static CaxtonFont loadFontByIdentifier(class_3300 manager, @Nullable class_2960 id) {
        if (id == null) {
            return null;
        }
        return CACHE.computeIfAbsent(id, id1 -> {
            CaxtonFont caxtonFont;
            block16: {
                LOGGER.info("Loading font {}", (Object)id);
                class_2960 fontId = new class_2960(id1.method_12836(), FONT_PREFIX + id1.method_12832());
                class_2960 metaId = new class_2960(fontId.method_12836(), fontId.method_12832() + ".json");
                JsonObject optionsJson = EMPTY;
                class_3298 metaResource = manager.method_14486(metaId);
                if (metaResource != null) {
                    try (BufferedReader metaInput = new BufferedReader(new InputStreamReader(metaResource.method_14482(), StandardCharsets.UTF_8));){
                        optionsJson = class_3518.method_15255((Reader)metaInput);
                        String path = class_3518.method_15253((JsonObject)optionsJson, (String)"path", null);
                        if (path != null) {
                            fontId = new class_2960(path);
                            fontId = new class_2960(fontId.method_12836(), FONT_PREFIX + fontId.method_12832());
                        }
                    }
                }
                InputStream input = manager.method_14486(fontId).method_14482();
                try {
                    caxtonFont = new CaxtonFont(input, (class_2960)id1, optionsJson);
                    if (input == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                input.close();
            }
            return caxtonFont;
        }).cloneReference();
    }

    public static void clearFontCache() {
        LOGGER.info("Clearing {} loaded font(s)", (Object)CACHE.size());
        CACHE.forEach((id, font) -> font.close());
        CACHE.clear();
    }

    public static CaxtonFont getFontById(class_2960 id) {
        return CACHE.get(id);
    }

    public static Stream<class_2960> getAvailableFontIds() {
        System.err.println(CACHE);
        return CACHE.keySet().stream();
    }

    @Nullable
    public class_390 method_2039(class_3300 manager) {
        if (!LibraryLoading.isLibraryLoaded()) {
            throw new RuntimeException("Refusing to load Caxton font when native library loading had failed");
        }
        try {
            ConfiguredCaxtonFont regular = ConfiguredCaxtonFont.load(manager, this.regular);
            ConfiguredCaxtonFont bold = ConfiguredCaxtonFont.load(manager, this.bold);
            ConfiguredCaxtonFont italic = ConfiguredCaxtonFont.load(manager, this.italic);
            ConfiguredCaxtonFont boldItalic = ConfiguredCaxtonFont.load(manager, this.boldItalic);
            return new CaxtonTypeface(regular, bold, italic, boldItalic);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load truetype font", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }
}

