/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import com.google.common.collect.ImmutableList;
import com.ibm.icu.text.Bidi;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_377;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import xyz.flirora.caxton.layout.FcIndexConverter;
import xyz.flirora.caxton.layout.LayoutCache;
import xyz.flirora.caxton.layout.Run;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingRunSegmenter;

@Environment(value=EnvType.CLIENT)
public record CaxtonText(List<RunGroup> runGroups, int totalLength, boolean rtl, String contents) {
    public static final CaxtonText EMPTY = new CaxtonText((List<RunGroup>)ImmutableList.of(), 0, false, "");

    private CaxtonText(List<RunGroup> runGroups, boolean rtl, String contents) {
        this(runGroups, runGroups.stream().mapToInt(RunGroup::getTotalLength).sum(), rtl, contents);
    }

    @NotNull
    public static CaxtonText from(class_5481 text, Function<class_2960, class_377> fonts, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        return CaxtonText.fromFull((class_5481)text, fonts, (boolean)validateAdvance, (boolean)rtl, (LayoutCache)cache).text;
    }

    @NotNull
    public static Full fromFull(class_5481 text, Function<class_2960, class_377> fonts, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        List<Run> runs = Run.splitIntoRuns(text, fonts, validateAdvance);
        return CaxtonText.fromRuns(runs, rtl, cache);
    }

    @NotNull
    public static CaxtonText fromFormatted(class_5348 text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        return CaxtonText.fromFormattedFull((class_5348)text, fonts, (class_2583)style, (boolean)validateAdvance, (boolean)rtl, (LayoutCache)cache).text;
    }

    @NotNull
    public static Full fromFormattedFull(class_5348 text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        List<Run> runs = Run.splitIntoRunsFormatted(text, fonts, style, validateAdvance);
        return CaxtonText.fromRuns(runs, rtl, cache);
    }

    @NotNull
    public static CaxtonText fromForwards(class_5348 text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        return CaxtonText.fromForwardsFull((class_5348)text, fonts, (class_2583)style, (boolean)validateAdvance, (boolean)rtl, (LayoutCache)cache).text;
    }

    @NotNull
    public static Full fromForwardsFull(class_5348 text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        List<Run> runs = Run.splitIntoRunsForwards(text, fonts, style, validateAdvance);
        return CaxtonText.fromRuns(runs, rtl, cache);
    }

    @NotNull
    public static CaxtonText fromFormatted(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        return CaxtonText.fromFormattedFull((String)text, fonts, (class_2583)style, (boolean)validateAdvance, (boolean)rtl, (LayoutCache)cache).text;
    }

    @NotNull
    public static Full fromFormattedFull(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        List<Run> runs = Run.splitIntoRunsFormatted(text, fonts, style, validateAdvance);
        return CaxtonText.fromRuns(runs, rtl, cache);
    }

    @NotNull
    public static CaxtonText fromFormatted(String text, Function<class_2960, class_377> fonts, class_2583 style, class_2583 baseStyle, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        return CaxtonText.fromFormattedFull((String)text, fonts, (class_2583)style, (class_2583)baseStyle, (boolean)validateAdvance, (boolean)rtl, (LayoutCache)cache).text;
    }

    @NotNull
    public static Full fromFormattedFull(String text, Function<class_2960, class_377> fonts, class_2583 style, class_2583 baseStyle, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        List<Run> runs = Run.splitIntoRunsFormatted(text, fonts, style, baseStyle, validateAdvance);
        return CaxtonText.fromRuns(runs, rtl, cache);
    }

    @NotNull
    public static CaxtonText fromFormatted(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache, FcIndexConverter formattingCodeStarts) {
        return CaxtonText.fromFormattedFull((String)text, fonts, (class_2583)style, (boolean)validateAdvance, (boolean)rtl, (LayoutCache)cache, (FcIndexConverter)formattingCodeStarts).text;
    }

    @NotNull
    public static Full fromFormattedFull(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache, FcIndexConverter formattingCodeStarts) {
        List<Run> runs = Run.splitIntoRunsFormatted(text, fonts, style, validateAdvance, formattingCodeStarts);
        return CaxtonText.fromRuns(runs, rtl, cache);
    }

    @NotNull
    public static CaxtonText fromForwards(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        return CaxtonText.fromForwardsFull((String)text, fonts, (class_2583)style, (boolean)validateAdvance, (boolean)rtl, (LayoutCache)cache).text;
    }

    @NotNull
    public static Full fromForwardsFull(String text, Function<class_2960, class_377> fonts, class_2583 style, boolean validateAdvance, boolean rtl, LayoutCache cache) {
        List<Run> runs = Run.splitIntoRunsForwards(text, fonts, style, validateAdvance);
        return CaxtonText.fromRuns(runs, rtl, cache);
    }

    @NotNull
    public static Full fromRuns(List<Run> runs, boolean rtl, LayoutCache cache) {
        return (Full)cache.getReorderCache().get((Object)new LayoutCache.FromRunsInput(runs, rtl), key -> CaxtonText.computeFromRuns(key.runs(), key.rtl(), cache));
    }

    @NotNull
    private static Full computeFromRuns(List<Run> runs, boolean rtl, LayoutCache cache) {
        ShapingRunSegmenter segmenter = new ShapingRunSegmenter(runs, rtl, cache);
        return new Full(new CaxtonText(segmenter.getRunGroupsInVisualOrder(), segmenter.isRightToLeft(), segmenter.getContents()), segmenter.getBidi());
    }

    public record Full(CaxtonText text, Bidi bidi) {
    }
}

