/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_2583;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_383;
import net.minecraft.class_390;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.flirora.caxton.dll.LibraryLoading;
import xyz.flirora.caxton.font.CaxtonFontStorage;
import xyz.flirora.caxton.font.CaxtonGlyphPair;
import xyz.flirora.caxton.font.CaxtonGlyphResult;
import xyz.flirora.caxton.font.CaxtonTypeface;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_377.class})
public abstract class FontStorageMixin
implements AutoCloseable,
CaxtonFontStorage {
    @Unique
    private Int2ObjectMap<CaxtonGlyphPair>[] caxtonGlyphCache = null;
    @Shadow
    @Final
    private List<class_390> field_2247;
    @Shadow
    @Final
    private class_1060 field_2248;

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/client/texture/TextureManager;Lnet/minecraft/util/Identifier;)V"})
    private void init(CallbackInfo ci) {
        this.caxtonGlyphCache = new Int2ObjectMap[4];
        for (int i = 0; i < 4; ++i) {
            this.caxtonGlyphCache[i] = new Int2ObjectOpenHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"setFonts(Ljava/util/List;)V"})
    private void onSetFonts(List<class_390> fonts, CallbackInfo ci) {
        Int2ObjectMap<CaxtonGlyphPair>[] int2ObjectMapArray = this.caxtonGlyphCache;
        int n = int2ObjectMapArray.length;
        for (int i = 0; i < n; ++i) {
            Int2ObjectMap<CaxtonGlyphPair> cacheEntry;
            Int2ObjectMap<CaxtonGlyphPair> int2ObjectMap = cacheEntry = int2ObjectMapArray[i];
            synchronized (int2ObjectMap) {
                cacheEntry.clear();
                continue;
            }
        }
    }

    @Unique
    private Int2ObjectMap<CaxtonGlyphPair> getCacheForStyle(class_2583 style) {
        return this.caxtonGlyphCache[(style.method_10984() ? 2 : 0) | (style.method_10966() ? 1 : 0)];
    }

    @Redirect(method={"setFonts(Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;"))
    private Stream<class_390> filterProxy(Stream<class_390> allFonts, Predicate<class_390> predicate) {
        if (!LibraryLoading.isLibraryLoaded()) {
            return allFonts.filter(predicate);
        }
        return allFonts.filter(font -> {
            if (font instanceof CaxtonTypeface) {
                CaxtonTypeface c = (CaxtonTypeface)font;
                return true;
            }
            return predicate.test((class_390)font);
        });
    }

    @Unique
    private CaxtonGlyphPair findCaxtonGlyph(int codePoint, class_2583 style) {
        class_383 glyph = null;
        for (class_390 font : this.field_2247) {
            CaxtonTypeface caxtonFont;
            if (font instanceof CaxtonTypeface && (caxtonFont = (CaxtonTypeface)font).supportsCodePoint(codePoint, style)) {
                return new CaxtonGlyphPair.Caxton(caxtonFont.getFontByStyle(style));
            }
            class_383 glyph2 = font.method_2040(codePoint);
            if (glyph2 == null) continue;
            glyph = glyph2;
            return new CaxtonGlyphPair.Legacy((class_379)glyph, (class_379)glyph2);
        }
        return CaxtonGlyphPair.MISSING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaxtonGlyphResult getCaxtonGlyph(int codePoint, boolean validateAdvance, class_2583 style) {
        Int2ObjectMap<CaxtonGlyphPair> cache;
        Int2ObjectMap<CaxtonGlyphPair> int2ObjectMap = cache = this.getCacheForStyle(style);
        synchronized (int2ObjectMap) {
            return ((CaxtonGlyphPair)cache.computeIfAbsent(codePoint, c -> this.findCaxtonGlyph(c, style))).getGlyph(validateAdvance);
        }
    }
}

