/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_384;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.render.CaxtonTextRenderer;

@Environment(value=EnvType.CLIENT)
public class CaxtonTextDrawer
implements class_5224 {
    private final CaxtonTextRenderer textRenderer;
    final class_4597 vertexConsumers;
    private final boolean shadow;
    private final float brightnessMultiplier;
    private final float red;
    private final float green;
    private final float blue;
    private final float alpha;
    private final int backgroundColor;
    private final class_1159 matrix;
    private final class_327.class_6415 layerType;
    private final int light;
    private final boolean swapZIndex;
    private float x;
    private float y;
    private final List<DrawnGlyph> glyphs;
    @Nullable
    private List<class_382.class_328> rectangles;

    public CaxtonTextDrawer(CaxtonTextRenderer textRenderer, class_4597 vertexConsumers, float x, float y, int color, int backgroundColor, boolean shadow, class_1159 matrix, class_327.class_6415 layerType, int light, boolean swapZIndex) {
        this.textRenderer = textRenderer;
        this.vertexConsumers = vertexConsumers;
        this.shadow = shadow;
        this.brightnessMultiplier = shadow ? 0.25f : 1.0f;
        this.alpha = (float)(color >>> 24) / 255.0f;
        this.red = (float)(color >> 16 & 0xFF) / 255.0f * this.brightnessMultiplier;
        this.green = (float)(color >> 8 & 0xFF) / 255.0f * this.brightnessMultiplier;
        this.blue = (float)(color & 0xFF) / 255.0f * this.brightnessMultiplier;
        this.backgroundColor = backgroundColor;
        this.matrix = matrix;
        this.layerType = layerType;
        this.light = light;
        this.swapZIndex = swapZIndex;
        this.x = x;
        this.y = y;
        this.glyphs = new ArrayList<DrawnGlyph>();
    }

    public CaxtonTextDrawer(CaxtonTextRenderer textRenderer, class_4597 vertexConsumers, float x, float y, int color, boolean shadow, class_1159 matrix, class_327.class_6415 layerType, int light) {
        this(textRenderer, vertexConsumers, x, y, color, 0, shadow, matrix, layerType, light, true);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void addRectangle(class_382.class_328 rectangle) {
        if (this.rectangles == null) {
            this.rectangles = new ArrayList<class_382.class_328>();
        }
        this.rectangles.add(rectangle);
    }

    public boolean accept(int index, class_2583 style, int codePoint) {
        float shadowOffset;
        float x;
        class_377 storage = this.textRenderer.getFontStorage(style.method_27708());
        class_379 glyph = storage.method_2011(codePoint);
        class_382 bakedGlyph = style.method_10987() && codePoint != 32 ? storage.method_2013(glyph) : storage.method_2014(codePoint);
        boolean bold = style.method_10984();
        class_5251 textColor = style.method_10973();
        float red = textColor != null ? (float)(textColor.method_27716() >> 16 & 0xFF) / 255.0f * this.brightnessMultiplier : this.red;
        float green = textColor != null ? (float)(textColor.method_27716() >> 8 & 0xFF) / 255.0f * this.brightnessMultiplier : this.green;
        float blue = textColor != null ? (float)(textColor.method_27716() & 0xFF) / 255.0f * this.brightnessMultiplier : this.blue;
        float alpha = this.alpha;
        float advance = glyph.method_16798(bold);
        float f = x = index == 0 ? this.x - 1.0f : this.x;
        if (!(bakedGlyph instanceof class_384)) {
            float boldOffset = bold ? glyph.method_16799() : 0.0f;
            float shadowOffset2 = this.shadow ? glyph.method_16800() : 0.0f;
            this.glyphs.add(new DrawnGlyph(this.x + shadowOffset2, this.y + shadowOffset2, red, green, blue, alpha, bakedGlyph, style, boldOffset));
        }
        float f2 = shadowOffset = this.shadow ? 1.0f : 0.0f;
        if (style.method_10986()) {
            this.addRectangle(new class_382.class_328(x + shadowOffset, this.y + shadowOffset + 4.5f, this.x + shadowOffset + advance, this.y + shadowOffset + 3.5f, this.getForegroundZIndex(), red, green, blue, alpha));
        }
        if (style.method_10965()) {
            this.addRectangle(new class_382.class_328(x + shadowOffset, this.y + shadowOffset + 9.0f, this.x + shadowOffset + advance, this.y + shadowOffset + 8.0f, this.getForegroundZIndex(), red, green, blue, alpha));
        }
        this.x += advance;
        return true;
    }

    float drawLayer(float x) {
        class_382 bakedGlyph = null;
        if (this.backgroundColor != 0) {
            class_382.class_328 rectangle = new class_382.class_328(x - 1.0f, this.y + 9.0f, this.x, this.y - 1.0f, this.getBackgroundZIndex(), (float)(this.backgroundColor >> 16) / 255.0f, (float)(this.backgroundColor >> 8) / 255.0f, (float)this.backgroundColor / 255.0f, (float)(this.backgroundColor >> 24) / 255.0f);
            bakedGlyph = this.textRenderer.getFontStorage(class_2583.field_24359).method_22943();
            class_4588 vertexConsumer = this.vertexConsumers.getBuffer(bakedGlyph.method_24045(this.layerType));
            bakedGlyph.method_22944(rectangle, this.matrix, vertexConsumer, this.light);
        }
        this.drawGlyphs();
        if (this.rectangles != null) {
            if (bakedGlyph == null) {
                bakedGlyph = this.textRenderer.getFontStorage(class_2583.field_24359).method_22943();
            }
            class_4588 vertexConsumer2 = this.vertexConsumers.getBuffer(bakedGlyph.method_24045(this.layerType));
            for (class_382.class_328 rectangle2 : this.rectangles) {
                bakedGlyph.method_22944(rectangle2, this.matrix, vertexConsumer2, this.light);
            }
        }
        return this.x;
    }

    void drawGlyphs() {
        for (DrawnGlyph drawnGlyph : this.glyphs) {
            class_382 bakedGlyph = drawnGlyph.glyph();
            class_4588 vertexConsumer = this.vertexConsumers.getBuffer(bakedGlyph.method_24045(this.layerType));
            bakedGlyph.method_2025(drawnGlyph.style.method_10966(), drawnGlyph.x, drawnGlyph.y, this.matrix, vertexConsumer, drawnGlyph.red, drawnGlyph.green, drawnGlyph.blue, drawnGlyph.alpha, this.light);
            if (!drawnGlyph.style.method_10984()) continue;
            bakedGlyph.method_2025(drawnGlyph.style.method_10966(), drawnGlyph.x + drawnGlyph.boldOffset, drawnGlyph.y, this.matrix, vertexConsumer, drawnGlyph.red, drawnGlyph.green, drawnGlyph.blue, drawnGlyph.alpha, this.light);
        }
    }

    public float getForegroundZIndex() {
        return this.swapZIndex ? 0.01f : -0.01f;
    }

    private float getBackgroundZIndex() {
        return this.swapZIndex ? -0.01f : 0.01f;
    }

    private record DrawnGlyph(float x, float y, float red, float green, float blue, float alpha, class_382 glyph, class_2583 style, float boldOffset) {
    }
}

