/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.FloatBuffer;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_4581;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5225;
import net.minecraft.class_5251;
import net.minecraft.class_5481;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.slf4j.Logger;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonFontOptions;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;
import xyz.flirora.caxton.layout.Threshold;
import xyz.flirora.caxton.mixin.TextRendererAccessor;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextDrawer;
import xyz.flirora.caxton.render.CaxtonTextLayerType;
import xyz.flirora.caxton.render.CaxtonTextRenderLayers;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;

@Environment(value=EnvType.CLIENT)
public class CaxtonTextRenderer {
    private static final class_1160 FORWARD_SHIFT = new class_1160(0.0f, 0.0f, 0.03f);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final CaxtonTextHandler handler;
    final class_327 vanillaTextRenderer;
    private final Random RANDOM = new Random();
    private CaxtonGlyphCache cache;
    private final Supplier<CaxtonGlyphCache> cacheSupplier;
    private final CaxtonTextRenderLayers renderLayers;
    public boolean rtl;

    public CaxtonTextRenderer(class_327 vanillaTextRenderer, class_5225 vanillaTextHandler, Supplier<CaxtonGlyphCache> cacheSupplier) {
        this.handler = new CaxtonTextHandler(this::getFontStorage, vanillaTextHandler);
        this.vanillaTextRenderer = vanillaTextRenderer;
        this.cacheSupplier = cacheSupplier;
        this.renderLayers = new CaxtonTextRenderLayers();
    }

    public static CaxtonTextRenderer getInstance() {
        return ((HasCaxtonTextRenderer)class_310.method_1551().field_1772).getCaxtonTextRenderer();
    }

    private static int tweakTransparency(int argb) {
        if ((argb & 0xFC000000) == 0) {
            return argb | 0xFF000000;
        }
        return argb;
    }

    private static float getMinThickness(class_1159 modelView) {
        if (CaxtonTextRenderer.isAffine(modelView)) {
            class_1041 window = class_310.method_1551().method_22683();
            class_4581 modelView3 = new class_4581(modelView);
            class_1160 v = new class_1160(0.0f, 1.0f, 0.0f);
            v.method_23215(modelView3);
            v.method_23215(new class_4581(RenderSystem.getProjectionMatrix()));
            v.method_23849((float)window.method_4480() / 2.0f, (float)window.method_4507() / 2.0f, 0.0f);
            float fontUnitYPx = class_3532.method_15355((float)(v.method_4943() * v.method_4943() + v.method_4945() * v.method_4945()));
            return 1.0f / fontUnitYPx;
        }
        return 0.0f;
    }

    private static boolean isAffine(class_1159 mat) {
        FloatBuffer buf = FloatBuffer.allocate(16);
        mat.method_4932(buf);
        return buf.get(3) == 0.0f && buf.get(7) == 0.0f && buf.get(11) == 0.0f && buf.get(15) == 1.0f;
    }

    public class_377 getFontStorage(class_2960 id) {
        return ((TextRendererAccessor)this.vanillaTextRenderer).callGetFontStorage(id);
    }

    public float drawLayer(String text, float x, float y, int color, boolean shadow, class_1159 matrix, class_4597 vertexConsumerProvider, boolean seeThrough, int backgroundColor, int light, int leftmostCodePoint, float maxWidth) {
        class_327.class_6415 layerType = seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        CaxtonText runGroups = CaxtonText.fromFormatted(text, this::getFontStorage, class_2583.field_24360, false, this.rtl, this.handler.getCache());
        float newX = this.drawRunGroups(x, y, color, shadow, matrix, vertexConsumerProvider, CaxtonTextLayerType.fromVanilla(layerType), backgroundColor, light, runGroups, leftmostCodePoint, maxWidth, CaxtonTextRenderer.getMinThickness(matrix));
        if (!shadow) {
            this.rtl = false;
        }
        return newX;
    }

    public float drawLayer(class_5481 text, float x, float y, int color, boolean shadow, class_1159 matrix, class_4597 vertexConsumerProvider, boolean seeThrough, int backgroundColor, int light, int leftmostCodePoint, float maxWidth) {
        class_327.class_6415 layerType = seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        CaxtonText runGroups = CaxtonText.from(text, this::getFontStorage, false, this.rtl, this.handler.getCache());
        return this.drawRunGroups(x, y, color, shadow, matrix, vertexConsumerProvider, CaxtonTextLayerType.fromVanilla(layerType), backgroundColor, light, runGroups, leftmostCodePoint, maxWidth, CaxtonTextRenderer.getMinThickness(matrix));
    }

    public void drawWithOutline(class_5481 text, float x, float y, int color, int outlineColor, class_1159 matrix, class_4597 vertexConsumers, int light, boolean addCorners) {
        Threshold NO_THRESHOLD = new Threshold(-1);
        float minThickness = CaxtonTextRenderer.getMinThickness(matrix);
        CaxtonText runGroups = CaxtonText.from(text, this::getFontStorage, false, this.rtl, this.handler.getCache());
        int effectiveOutlineColor = CaxtonTextRenderer.tweakTransparency(outlineColor);
        int effectiveColor = CaxtonTextRenderer.tweakTransparency(color);
        CaxtonTextDrawer outlineDrawer = new CaxtonTextDrawer(this, vertexConsumers, 0.0f, 0.0f, effectiveOutlineColor, false, matrix, class_327.class_6415.field_33993, light);
        CaxtonTextDrawer centralDrawer = new CaxtonTextDrawer(this, vertexConsumers, x, y, effectiveColor, false, matrix, class_327.class_6415.field_33995, light);
        for (RunGroup runGroup : runGroups.runGroups()) {
            ConfiguredCaxtonFont font = runGroup.getFont();
            if (font == null) {
                MutableFloat xBox = new MutableFloat();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        if (dx == 0 && dy == 0 || !addCorners && dx != 0 && dy != 0) continue;
                        xBox.setValue(x);
                        int dxf = dx;
                        int dyf = dy;
                        runGroup.acceptRender((index, style, codePoint) -> {
                            int index2 = runGroup.getCharOffset() + index;
                            class_377 fontStorage = this.getFontStorage(style.method_27708());
                            class_379 glyph = fontStorage.method_2011(codePoint);
                            float shadowOffset = glyph.method_16800();
                            outlineDrawer.setX(xBox.floatValue() + (float)dxf * shadowOffset);
                            outlineDrawer.setY(y + (float)dyf * shadowOffset);
                            xBox.add(glyph.method_16798(style.method_10984()));
                            return outlineDrawer.accept(index2, style, codePoint);
                        });
                    }
                }
                centralDrawer.setX(x);
                runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = runGroup.getCharOffset() + index;
                    return centralDrawer.accept(index2, style, codePoint);
                });
                x = centralDrawer.getX();
            } else {
                ShapingResult[] shapingResults = runGroup.getShapingResults();
                int outlinedGlyphOffset = font.font().getOptions().fontTech().offsetOutlineGlyphsByGlyphCounts() ? font.font().getGlyphCount() : 0;
                for (int i = 0; i < shapingResults.length; ++i) {
                    ShapingResult shapingResult = shapingResults[i];
                    this.drawShapedRun(shapingResult, runGroup, i, x, y, effectiveOutlineColor, false, matrix, vertexConsumers, CaxtonTextLayerType.OUTLINE, light, outlineDrawer, NO_THRESHOLD, Float.POSITIVE_INFINITY, minThickness, outlinedGlyphOffset);
                    x = this.drawShapedRun(shapingResult, runGroup, i, x, y, effectiveColor, false, matrix, vertexConsumers, CaxtonTextLayerType.POLYGON_OFFSET, light, outlineDrawer, NO_THRESHOLD, Float.POSITIVE_INFINITY, minThickness, 0);
                }
            }
            outlineDrawer.drawLayer(x);
            centralDrawer.drawLayer(x);
        }
    }

    public float draw(CaxtonText text, float x, float y, int color, boolean shadow, class_1159 matrix, class_4597 vertexConsumerProvider, boolean seeThrough, int backgroundColor, int light, int leftmostCodePoint, float maxWidth) {
        float minThickness = CaxtonTextRenderer.getMinThickness(matrix);
        CaxtonTextLayerType layerType = seeThrough ? CaxtonTextLayerType.SEE_THROUGH : CaxtonTextLayerType.NORMAL;
        color = CaxtonTextRenderer.tweakTransparency(color);
        class_1159 matrix4f = new class_1159(matrix);
        if (shadow) {
            this.drawRunGroups(x, y, color, true, matrix, vertexConsumerProvider, layerType, backgroundColor, light, text, leftmostCodePoint, maxWidth, minThickness);
            matrix4f.method_31544(FORWARD_SHIFT.method_4943(), FORWARD_SHIFT.method_4945(), FORWARD_SHIFT.method_4947());
        }
        x = this.drawRunGroups(x, y, color, false, matrix4f, vertexConsumerProvider, layerType, backgroundColor, light, text, leftmostCodePoint, maxWidth, minThickness);
        return (int)x + (shadow ? 1 : 0);
    }

    private float drawRunGroups(float x, float y, int color, boolean shadow, class_1159 matrix, class_4597 vertexConsumerProvider, CaxtonTextLayerType layerType, int backgroundColor, int light, CaxtonText text, int leftmostCodePoint, float maxWidth, float minThickness) {
        this.getCache();
        Threshold threshold = new Threshold(leftmostCodePoint);
        float origX = x;
        float maxX = x + maxWidth;
        CaxtonTextDrawer drawer = new CaxtonTextDrawer(this, vertexConsumerProvider, x, y, color, backgroundColor, shadow, matrix, layerType.asVanilla(), light, true);
        for (RunGroup runGroup : text.runGroups()) {
            if (threshold.shouldSkip(runGroup)) continue;
            if (x >= maxX) break;
            if (runGroup.getFont() == null) {
                drawer.setX(x);
                runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = runGroup.getCharOffset() + index;
                    if (threshold.updateLegacy(index2)) {
                        return true;
                    }
                    if (drawer.getX() >= maxX + this.handler.getWidth(codePoint, style)) {
                        return false;
                    }
                    return drawer.accept(index2, style, codePoint);
                });
                x = drawer.getX();
                continue;
            }
            ShapingResult[] shapingResults = runGroup.getShapingResults();
            for (int index2 = 0; index2 < shapingResults.length; ++index2) {
                ShapingResult shapingResult = shapingResults[index2];
                x = this.drawShapedRun(shapingResult, runGroup, index2, x, y, color, shadow, matrix, vertexConsumerProvider, layerType, light, drawer, threshold, maxX, minThickness, 0);
            }
        }
        drawer.setX(x);
        drawer.drawLayer(origX);
        return x;
    }

    private float drawShapedRun(ShapingResult shapedRun, RunGroup runGroup, int index, float x, float y, int color, boolean shadow, class_1159 matrix, class_4597 vertexConsumers, CaxtonTextLayerType layerType, int light, CaxtonTextDrawer drawer, Threshold threshold, float maxX, float minThickness, int glyphOffset) {
        if (x >= maxX) {
            return x;
        }
        ConfiguredCaxtonFont configuredFont = runGroup.getFont();
        CaxtonFont font = configuredFont.font();
        CaxtonFontOptions options = font.getOptions();
        CaxtonGlyphCache.Font cacheForFont = this.cache.forFont(font);
        assert (glyphOffset + font.getGlyphCount() <= font.getTlistSize());
        double shrink = options.shrinkage();
        int margin = options.margin();
        float shadowOffset = shadow ? configuredFont.shadowOffset() : 0.0f;
        float pageSize = CaxtonAtlas.PAGE_SIZE;
        int offset = runGroup.getBidiRuns()[4 * index + 0];
        short underlinePosition = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_POSITION);
        short underlineThickness = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_THICKNESS);
        short strikeoutPosition = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_POSITION);
        short strikeoutThickness = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_THICKNESS);
        float scale = configuredFont.getScale();
        float baselineY = y + 7.0f + configuredFont.shiftY();
        x += configuredFont.shiftX();
        float yu = baselineY - (float)underlinePosition * scale;
        float ys = baselineY - (float)strikeoutPosition * scale;
        float dyu = (float)underlineThickness * scale;
        float dys = (float)strikeoutThickness * scale;
        float ou = 0.5f * dyu;
        float os = 0.5f * dys;
        if (dyu < minThickness) {
            dyu = minThickness;
        }
        if (dys < minThickness) {
            dys = minThickness;
        }
        float y0u = yu + 0.5f * dyu;
        float y1u = yu - 0.5f * dyu;
        float y0s = ys + 0.5f * dys;
        float y1s = ys - 0.5f * dys;
        float brightnessMultiplier = shadow ? 0.25f : 1.0f;
        float baseBlue = (float)(color & 0xFF) / 255.0f * brightnessMultiplier;
        float baseGreen = (float)(color >> 8 & 0xFF) / 255.0f * brightnessMultiplier;
        float baseRed = (float)(color >> 16 & 0xFF) / 255.0f * brightnessMultiplier;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int numGlyphs = shapedRun.numGlyphs();
        int cumulAdvanceX = 0;
        for (int i = 0; i < numGlyphs; ++i) {
            int glyphId = shapedRun.glyphId(i);
            int clusterIndex = shapedRun.clusterIndex(i);
            if (threshold.updateCaxton(runGroup, index, shapedRun, i)) continue;
            class_2583 style = runGroup.getStyleAt(offset + clusterIndex);
            if (style.method_10987()) {
                long tlLoc = font.getTlistLocation(glyphId, 0);
                int width = (int)(tlLoc & 0xFFFFL);
                IntList others = (IntList)font.getGlyphsByWidth().get(width);
                glyphId = others.getInt(this.RANDOM.nextInt(others.size()));
            }
            class_5251 styleColorObj = style.method_10973();
            float red = baseRed;
            float green = baseGreen;
            float blue = baseBlue;
            if (styleColorObj != null) {
                int styleColor = styleColorObj.method_27716();
                red = (float)(styleColor >> 16 & 0xFF) / 255.0f * brightnessMultiplier;
                green = (float)(styleColor >> 8 & 0xFF) / 255.0f * brightnessMultiplier;
                blue = (float)(styleColor & 0xFF) / 255.0f * brightnessMultiplier;
            }
            int advanceX = shapedRun.advanceX(i);
            int offsetX = shapedRun.offsetX(i);
            int offsetY = shapedRun.offsetY(i);
            int gx = cumulAdvanceX + offsetX;
            long atlasLoc = cacheForFont.getOrCreateAtlasLocation(glyphOffset + glyphId);
            if (atlasLoc != 0L) {
                int atlasX = CaxtonAtlas.getX(atlasLoc);
                int atlasY = CaxtonAtlas.getY(atlasLoc);
                int atlasWidth = CaxtonAtlas.getW(atlasLoc);
                int atlasHeight = CaxtonAtlas.getH(atlasLoc);
                int atlasPageIndex = CaxtonAtlas.getPage(atlasLoc);
                CaxtonAtlas.Page atlasPage = this.cache.getAtlasPageTexture(atlasPageIndex);
                long glyphBbox = font.getBbox(glyphId);
                short bbXMin = (short)glyphBbox;
                short bbYMin = (short)(glyphBbox >> 16);
                short bbXMax = (short)(glyphBbox >> 32);
                short bbYMax = (short)(glyphBbox >> 48);
                int bbWidth = bbXMax - bbXMin;
                int bbHeight = bbYMax - bbYMin;
                class_1921 renderLayer = this.renderLayers.text(atlasPage, layerType, options.fontTech(), configuredFont.blur());
                class_4588 vertexConsumer = vertexConsumers.getBuffer(renderLayer);
                float x0 = (float)((double)x + ((double)(gx += bbXMin) - shrink * (double)margin) * (double)scale);
                float y1 = (float)(((double)(-(offsetY += bbYMin)) + shrink * (double)margin) * (double)scale);
                float u0 = (float)atlasX / pageSize;
                float v0 = (float)atlasY / pageSize;
                float x1 = (float)((double)x + ((double)gx + shrink * (double)(atlasWidth - margin)) * (double)scale);
                float y0 = (float)(((double)(-offsetY) - shrink * (double)(atlasHeight - margin)) * (double)scale);
                float u1 = (float)(atlasX + atlasWidth) / pageSize;
                float v1 = (float)(atlasY + atlasHeight) / pageSize;
                float lowerOffset = configuredFont.slant() * y0;
                float upperOffset = configuredFont.slant() * y1;
                y0 += baselineY;
                y1 += baselineY;
                if (x1 >= maxX) break;
                x1 += shadowOffset;
                vertexConsumer.method_22918(matrix, (x0 += shadowOffset) + lowerOffset, y0 += shadowOffset, 0.0f).method_22915(red, green, blue, alpha);
                vertexConsumer.method_22913(u0, v0).method_22916(light).method_1344();
                vertexConsumer.method_22918(matrix, x0 + upperOffset, y1 += shadowOffset, 0.0f).method_22915(red, green, blue, alpha);
                vertexConsumer.method_22913(u0, v1).method_22916(light).method_1344();
                vertexConsumer.method_22918(matrix, x1 + upperOffset, y1, 0.0f).method_22915(red, green, blue, alpha);
                vertexConsumer.method_22913(u1, v1).method_22916(light).method_1344();
                vertexConsumer.method_22918(matrix, x1 + lowerOffset, y0, 0.0f).method_22915(red, green, blue, alpha);
                vertexConsumer.method_22913(u1, v0).method_22916(light).method_1344();
            }
            float x0a = x + (float)cumulAdvanceX * scale;
            float x1a = x + (float)(cumulAdvanceX + advanceX) * scale;
            if (style.method_10965()) {
                drawer.addRectangle(new class_382.class_328(x0a + shadowOffset, y0u + shadowOffset, x1a + shadowOffset, y1u + shadowOffset, drawer.getForegroundZIndex(), red, green, blue, alpha));
            }
            if (style.method_10986()) {
                drawer.addRectangle(new class_382.class_328(x0a + shadowOffset, y0s + shadowOffset, x1a + shadowOffset, y1s + shadowOffset, drawer.getForegroundZIndex(), red, green, blue, alpha));
            }
            cumulAdvanceX += advanceX;
        }
        return x + (float)cumulAdvanceX * scale - configuredFont.shiftX();
    }

    public CaxtonGlyphCache getCache() {
        if (this.cache == null) {
            this.cache = this.cacheSupplier.get();
        }
        return this.cache;
    }

    public void clearCaches() {
        this.handler.clearCaches();
        LOGGER.info("Cleared layout caches");
        if (this.cache != null) {
            this.cache.clear();
        }
        this.renderLayers.clear();
        LOGGER.info("Cleared rendering caches");
    }

    public CaxtonTextHandler getHandler() {
        return this.handler;
    }
}

