/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import xyz.flirora.caxton.mixin.RenderPhaseAccessor;

@Environment(value=EnvType.CLIENT)
public class WorldRendererVertexConsumerProvider
extends class_4597.class_4598 {
    private static final Set<String> CAXTON_TEXT_RENDER_LAYER_NAMES = ImmutableSet.of((Object)"caxton_text", (Object)"caxton_text_see_through", (Object)"caxton_text_outline");
    private static final Map<class_1921, class_287> caxtonTextLayerBuilders = new HashMap<class_1921, class_287>();

    public WorldRendererVertexConsumerProvider(class_287 fallbackBuffer, Map<class_1921, class_287> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    private static boolean isCaxtonTextLayer(class_1921 layer) {
        return CAXTON_TEXT_RENDER_LAYER_NAMES.contains(((RenderPhaseAccessor)layer).getName());
    }

    public class_4588 getBuffer(class_1921 renderLayer) {
        Optional optional = renderLayer.method_24296();
        class_287 bufferBuilder = this.getBufferInternal(renderLayer);
        if (!Objects.equals(this.field_20954, optional)) {
            class_1921 currentLayer;
            if (this.field_20954.isPresent() && !WorldRendererVertexConsumerProvider.isCaxtonTextLayer(currentLayer = (class_1921)this.field_20954.get()) && !this.field_20953.containsKey(currentLayer)) {
                this.method_22994(currentLayer);
            }
            if (this.field_20955.add(bufferBuilder)) {
                bufferBuilder.method_1328(renderLayer.method_23033(), renderLayer.method_23031());
            }
            this.field_20954 = optional;
        }
        return bufferBuilder;
    }

    private class_287 getBufferInternal(class_1921 layer) {
        if (WorldRendererVertexConsumerProvider.isCaxtonTextLayer(layer)) {
            return caxtonTextLayerBuilders.computeIfAbsent(layer, l -> new class_287(256));
        }
        return this.field_20953.getOrDefault(layer, this.field_20952);
    }

    public void method_37104() {
        if (this.field_20954.isPresent()) {
            class_1921 renderLayer = (class_1921)this.field_20954.get();
            if (!WorldRendererVertexConsumerProvider.isCaxtonTextLayer(renderLayer) && !this.field_20953.containsKey(renderLayer)) {
                this.method_22994(renderLayer);
            }
            this.field_20954 = Optional.empty();
        }
    }

    public void method_22993() {
        super.method_22993();
        this.drawCaxtonTextLayers();
    }

    public void drawCaxtonTextLayers() {
        for (class_1921 renderLayer : caxtonTextLayerBuilders.keySet()) {
            this.method_22994(renderLayer);
        }
    }

    public void method_22994(class_1921 layer) {
        class_287 bufferBuilder = this.getBufferInternal(layer);
        boolean layerIsCurrent = Objects.equals(this.field_20954, layer.method_24296());
        if (!layerIsCurrent && bufferBuilder == this.field_20952) {
            return;
        }
        if (!this.field_20955.remove(bufferBuilder)) {
            return;
        }
        layer.method_23012(bufferBuilder, 0, 0, 0);
        if (layerIsCurrent) {
            this.field_20954 = Optional.empty();
        }
    }
}

