/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Bidi;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_377;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.DirectionSetting;
import xyz.flirora.caxton.layout.FcIndexConverter;
import xyz.flirora.caxton.layout.LayoutCache;
import xyz.flirora.caxton.layout.LineWrapper;
import xyz.flirora.caxton.layout.Run;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;
import xyz.flirora.caxton.layout.TextHandlerExt;
import xyz.flirora.caxton.layout.Threshold;
import xyz.flirora.caxton.mixin.TextHandlerAccessor;

@Environment(value=EnvType.CLIENT)
public class CaxtonTextHandler {
    private static final class_377 EMPTY_FONT_STORAGE = new class_377(null);
    public static final Function<class_2960, class_377> EMPTY_FONT_STORAGE_ACCESSOR = fontId -> EMPTY_FONT_STORAGE;
    private final LayoutCache cache = LayoutCache.getInstance();
    private final Function<class_2960, class_377> fontStorageAccessor;
    private final class_5225 vanillaHandler;

    public CaxtonTextHandler(Function<class_2960, class_377> fontStorageAccessor, class_5225 vanillaHandler) {
        this.fontStorageAccessor = fontStorageAccessor;
        this.vanillaHandler = vanillaHandler;
        ((TextHandlerExt)this.vanillaHandler).setCaxtonTextHandler(this);
    }

    public CaxtonText layoutText(class_5481 text, boolean validateAdvance, boolean rtl) {
        return CaxtonText.from(text, this.fontStorageAccessor, validateAdvance, rtl, this.cache);
    }

    public LayoutCache getCache() {
        return this.cache;
    }

    public float getWidth(int codePoint, class_2583 style) {
        return ((TextHandlerAccessor)this.vanillaHandler).getWidthRetriever().getWidth(codePoint, style);
    }

    public float getWidth(@Nullable String text) {
        if (text == null) {
            return 0.0f;
        }
        CaxtonText runGroups = CaxtonText.fromFormatted(text, this.fontStorageAccessor, class_2583.field_24360, false, class_2477.method_10517().method_29428(), this.cache);
        return this.getWidth(runGroups);
    }

    public float getWidth(class_5348 text) {
        CaxtonText runGroups = CaxtonText.fromFormatted(text, this.fontStorageAccessor, class_2583.field_24360, false, class_2477.method_10517().method_29428(), this.cache);
        return this.getWidth(runGroups);
    }

    public float getWidth(class_5481 text) {
        CaxtonText runGroups = CaxtonText.from(text, this.fontStorageAccessor, false, class_2477.method_10517().method_29428(), this.cache);
        return this.getWidth(runGroups);
    }

    public float getWidth(CaxtonText text) {
        float total = 0.0f;
        for (RunGroup runGroup : text.runGroups()) {
            total += this.getWidth(runGroup);
        }
        return total;
    }

    private float getWidth(RunGroup runGroup) {
        float total = 0.0f;
        if (runGroup.getFont() == null) {
            MutableFloat cumulWidth = new MutableFloat();
            runGroup.acceptRender((index, style, codePoint) -> {
                cumulWidth.add(this.getWidth(codePoint, style));
                return true;
            });
            total += cumulWidth.floatValue();
        } else {
            ShapingResult[] shapingResults;
            float scale = runGroup.getFont().getScale();
            for (ShapingResult shapingResult : shapingResults = runGroup.getShapingResults()) {
                total += (float)shapingResult.totalWidth() * scale;
            }
        }
        return total;
    }

    public int getCharIndexAtX(String text, int maxWidth, class_2583 style) {
        CaxtonText runGroups = CaxtonText.fromForwards(text, this.fontStorageAccessor, style, false, class_2477.method_10517().method_29428(), this.cache);
        return this.getCharIndexAtX(runGroups, (float)maxWidth, -1);
    }

    public int getCharIndexAtXFormatted(String text, int maxWidth, class_2583 style) {
        CaxtonText runGroups = CaxtonText.fromFormatted(text, this.fontStorageAccessor, style, false, class_2477.method_10517().method_29428(), this.cache);
        return this.getCharIndexAtX(runGroups, (float)maxWidth, -1);
    }

    public int getCharIndexAtX(CaxtonText text, float x, int from) {
        return this.getCharIndexAtX(text, x, from, false);
    }

    public int getCharIndexAfterX(CaxtonText text, float x, int from) {
        return this.getCharIndexAtX(text, x, from, true);
    }

    public int getCharIndexAtX(CaxtonText text, float x, int from, boolean after) {
        Threshold threshold = new Threshold(from);
        for (RunGroup runGroup : text.runGroups()) {
            if (threshold.shouldSkip(runGroup)) continue;
            if (runGroup.getFont() == null) {
                MutableFloat cumulWidth = new MutableFloat(x);
                MutableInt theIndex = new MutableInt();
                boolean completed = runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = index + runGroup.getCharOffset();
                    if (threshold.updateLegacy(index2)) {
                        return true;
                    }
                    float width = this.getWidth(codePoint, style);
                    float f = cumulWidth.floatValue();
                    float f2 = after ? 0.0f : width;
                    if (f < f2) {
                        theIndex.setValue(index2);
                        return false;
                    }
                    cumulWidth.subtract(width);
                    return true;
                });
                if (!completed) {
                    return theIndex.intValue();
                }
                x = cumulWidth.floatValue();
                continue;
            }
            float scale = runGroup.getFont().getScale();
            ShapingResult[] shapingResults = runGroup.getShapingResults();
            int runIndex = 0;
            for (ShapingResult shapingResult : shapingResults) {
                for (int i = 0; i < shapingResult.numGlyphs(); ++i) {
                    if (threshold.updateCaxton(runGroup, runIndex, shapingResult, i)) continue;
                    float width = scale * (float)shapingResult.advanceX(i);
                    float f = after ? 0.0f : width;
                    if (x < f) {
                        int[] bidiRuns = runGroup.getBidiRuns();
                        int start = bidiRuns[4 * runIndex + 0];
                        return runGroup.getCharOffset() + start + shapingResult.clusterIndex(i);
                    }
                    x -= width;
                }
                ++runIndex;
            }
        }
        return text.totalLength();
    }

    public class_5348 trimToWidth(class_5348 text, int width, class_2583 style) {
        CaxtonText.Full caxtonText = CaxtonText.fromForwardsFull(text, this.fontStorageAccessor, style, false, false, this.cache);
        LineWrapper wrapper = new LineWrapper(caxtonText.text(), caxtonText.bidi(), ((TextHandlerAccessor)this.vanillaHandler).getWidthRetriever(), width, true);
        if (wrapper.isFinished()) {
            return text;
        }
        LineWrapper.Result line = wrapper.nextLine(this.fontStorageAccessor);
        return this.runsToStringVisitable(line.runs());
    }

    @Nullable
    public class_2583 getStyleAt(class_5348 text, int x) {
        CaxtonText caxtonText = CaxtonText.fromFormatted(text, this.fontStorageAccessor, class_2583.field_24360, false, false, this.cache);
        return this.getStyleAt(caxtonText, x, -1);
    }

    @Nullable
    public class_2583 getStyleAt(class_5481 text, int x) {
        CaxtonText caxtonText = CaxtonText.from(text, this.fontStorageAccessor, false, false, this.cache);
        return this.getStyleAt(caxtonText, x, -1);
    }

    @Nullable
    public class_2583 getStyleAt(CaxtonText text, float x, int from) {
        MutableObject styleBox = new MutableObject();
        Threshold threshold = new Threshold(from);
        for (RunGroup runGroup : text.runGroups()) {
            if (threshold.shouldSkip(runGroup)) continue;
            if (runGroup.getFont() == null) {
                MutableFloat cumulWidth = new MutableFloat(x);
                boolean completed = runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = index + runGroup.getCharOffset();
                    if (threshold.updateLegacy(index2)) {
                        return true;
                    }
                    float width = this.getWidth(codePoint, style);
                    if (cumulWidth.floatValue() < width) {
                        styleBox.setValue((Object)style);
                        return false;
                    }
                    cumulWidth.subtract(width);
                    return true;
                });
                if (!completed) {
                    return (class_2583)styleBox.getValue();
                }
                x = cumulWidth.floatValue();
                continue;
            }
            float scale = runGroup.getFont().getScale();
            ShapingResult[] shapingResults = runGroup.getShapingResults();
            int runIndex = 0;
            for (ShapingResult shapingResult : shapingResults) {
                for (int i = 0; i < shapingResult.numGlyphs(); ++i) {
                    if (threshold.updateCaxton(runGroup, runIndex, shapingResult, i)) continue;
                    float width = scale * (float)shapingResult.advanceX(i);
                    if (x < width) {
                        int[] bidiRuns = runGroup.getBidiRuns();
                        int start = bidiRuns[4 * runIndex + 0];
                        return runGroup.getStyleAt(start + shapingResult.clusterIndex(i));
                    }
                    x -= width;
                }
                ++runIndex;
            }
        }
        return null;
    }

    public float getOffsetAtIndex(CaxtonText text, int textIndex, DirectionSetting direction) {
        if (direction.treatAsRtl(text.rtl()) ? textIndex >= text.totalLength() : textIndex < 0) {
            return 0.0f;
        }
        float offset = 0.0f;
        for (RunGroup runGroup : text.runGroups()) {
            ConfiguredCaxtonFont font = runGroup.getFont();
            if (font == null) {
                MutableFloat mutableFloat = new MutableFloat(offset);
                boolean completed = runGroup.acceptRender((index, style, codePoint, rtl) -> {
                    if (index + runGroup.getCharOffset() == textIndex) {
                        if (direction.treatAsRtl(rtl)) {
                            mutableFloat.add(this.getWidth(codePoint, style));
                        }
                        return false;
                    }
                    mutableFloat.add(this.getWidth(codePoint, style));
                    return true;
                });
                offset = mutableFloat.floatValue();
                if (completed) continue;
                return offset;
            }
            float scale = runGroup.getFont().getScale();
            ShapingResult[] shapingResults = runGroup.getShapingResults();
            int[] bidiRuns = runGroup.getBidiRuns();
            int advance = 0;
            int runIndex = 0;
            for (ShapingResult shapingResult : shapingResults) {
                int start = bidiRuns[4 * runIndex + 0];
                int level = bidiRuns[4 * runIndex + 2];
                for (int i = 0; i < shapingResult.numGlyphs(); ++i) {
                    int r0 = runGroup.getCharOffset() + start + shapingResult.clusterIndex(i);
                    int r1 = runGroup.getCharOffset() + start + shapingResult.clusterLimit(i);
                    if (r0 <= textIndex && textIndex < r1) {
                        float frac = (float)(textIndex - r0) / (float)(r1 - r0);
                        if (direction.treatAsRtl(level % 2 != 0)) {
                            frac = 1.0f - frac;
                        }
                        return offset + scale * ((float)advance + frac * (float)shapingResult.advanceX(i));
                    }
                    advance += shapingResult.advanceX(i);
                }
                ++runIndex;
            }
            offset += (float)advance * scale;
        }
        return offset;
    }

    public void getHighlightRanges(CaxtonText text, int startIndex, int endIndex, HighlightConsumer callback) {
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("startIndex must be less than or equal to endIndex");
        }
        Highlighter highlighter = new Highlighter(startIndex, endIndex, callback);
        for (RunGroup runGroup : text.runGroups()) {
            ConfiguredCaxtonFont font = runGroup.getFont();
            if (font == null) {
                runGroup.acceptRender((index, style, codePoint, rtl) -> {
                    int index2 = index + runGroup.getCharOffset();
                    highlighter.accept(index2, index2 + 1, rtl, this.getWidth(codePoint, style));
                    return true;
                });
                continue;
            }
            float scale = runGroup.getFont().getScale();
            ShapingResult[] shapingResults = runGroup.getShapingResults();
            int[] bidiRuns = runGroup.getBidiRuns();
            int runIndex = 0;
            for (ShapingResult shapingResult : shapingResults) {
                int start = bidiRuns[4 * runIndex + 0];
                boolean rtl2 = bidiRuns[4 * runIndex + 2] % 2 != 0;
                for (int i = 0; i < shapingResult.numGlyphs(); ++i) {
                    int r0 = runGroup.getCharOffset() + start + shapingResult.clusterIndex(i);
                    int r1 = runGroup.getCharOffset() + start + shapingResult.clusterLimit(i);
                    highlighter.accept(r0, r1, rtl2, scale * (float)shapingResult.advanceX(i));
                }
                ++runIndex;
            }
        }
        highlighter.finish();
    }

    public void wrapLines(String text, int maxWidth, class_2583 style, boolean retainTrailingWordSplit, class_5225.class_5229 consumer) {
        this.wrapLines(text, maxWidth, style, retainTrailingWordSplit, new FcIndexConverter(), consumer);
    }

    public void wrapLines(String text, int maxWidth, class_2583 style, boolean retainTrailingWordSplit, FcIndexConverter formattingCodeStarts, class_5225.class_5229 consumer) {
        CaxtonText.Full caxtonText = CaxtonText.fromFormattedFull(text, this.fontStorageAccessor, style, false, false, this.cache, formattingCodeStarts);
        this.wrapLines(caxtonText.text(), caxtonText.bidi(), maxWidth, consumer, formattingCodeStarts, retainTrailingWordSplit);
    }

    public void wrapLines(String text, int maxWidth, class_2583 style, boolean retainTrailingWordSplit, FcIndexConverter formattingCodeStarts, IndexedLineWrappingConsumer consumer) {
        CaxtonText.Full caxtonText = CaxtonText.fromFormattedFull(text, this.fontStorageAccessor, style, false, false, this.cache, formattingCodeStarts);
        this.wrapLines(caxtonText.text(), caxtonText.bidi(), maxWidth, consumer, formattingCodeStarts, retainTrailingWordSplit);
    }

    public void wrapLines(CaxtonText text, Bidi bidi, int maxWidth, class_5225.class_5229 lineConsumer, FcIndexConverter formattingCodeStarts, boolean retainTrailingWordSplit) {
        this.wrapLines(text, bidi, maxWidth, IndexedLineWrappingConsumer.from(lineConsumer), formattingCodeStarts, retainTrailingWordSplit);
    }

    public void wrapLines(CaxtonText text, Bidi bidi, int maxWidth, IndexedLineWrappingConsumer lineConsumer, FcIndexConverter formattingCodeStarts, boolean retainTrailingWordSplit) {
        LineWrapper wrapper = new LineWrapper(text, bidi, ((TextHandlerAccessor)this.vanillaHandler).getWidthRetriever(), maxWidth, false);
        String contents = wrapper.getContents();
        if (wrapper.isFinished()) {
            lineConsumer.accept(class_2583.field_24360, 0, text.totalLength() + 2 * formattingCodeStarts.valueOfMaxKey(), false);
        }
        while (!wrapper.isFinished()) {
            boolean rtl = wrapper.isCurrentlyRtl();
            int start = wrapper.getCurrentLineStart();
            wrapper.goToNextLine();
            int end = wrapper.getCurrentLineStart();
            if (!retainTrailingWordSplit && end > start) {
                char trailing = contents.charAt(end - 1);
                if (wrapper.isFinished() ? trailing == '\n' : UCharacter.isWhitespace((int)trailing)) {
                    --end;
                }
            }
            RunGroup rg = wrapper.getRunGroupAt(start);
            lineConsumer.accept(rg.getStyleAt(start - rg.getCharOffset()), formattingCodeStarts.formatlessToFormatful(start), formattingCodeStarts.formatlessToFormatful(end), rtl);
        }
    }

    public void wrapLines(class_5348 text, int maxWidth, class_2583 style, BiConsumer<class_5348, Boolean> lineConsumer) {
        CaxtonText.Full caxtonText = CaxtonText.fromFormattedFull(text, this.fontStorageAccessor, style, false, false, this.cache);
        this.wrapLines(caxtonText.text(), caxtonText.bidi(), maxWidth, lineConsumer);
    }

    public void wrapLines(CaxtonText text, Bidi bidi, int maxWidth, BiConsumer<class_5348, Boolean> lineConsumer) {
        this.wrapLines(text, bidi, maxWidth, DirectionalLineWrappingConsumer.from(lineConsumer));
    }

    public void wrapLines(CaxtonText text, Bidi bidi, int maxWidth, DirectionalLineWrappingConsumer lineConsumer) {
        LineWrapper wrapper = new LineWrapper(text, bidi, ((TextHandlerAccessor)this.vanillaHandler).getWidthRetriever(), maxWidth, false);
        while (!wrapper.isFinished()) {
            boolean continuation = wrapper.isContinuation();
            LineWrapper.Result line = wrapper.nextLine(this.fontStorageAccessor);
            lineConsumer.accept(this.runsToStringVisitable(line.runs()), continuation, line.rtl());
        }
    }

    private class_5348 runsToStringVisitable(final List<Run> runs) {
        return new class_5348(){

            public <T> Optional<T> method_27657(class_5348.class_5245<T> visitor) {
                for (Run run : runs) {
                    Optional result = visitor.accept(run.text());
                    if (!result.isPresent()) continue;
                    return result;
                }
                return Optional.empty();
            }

            public <T> Optional<T> method_27658(class_5348.class_5246<T> styledVisitor, class_2583 style) {
                for (Run run : runs) {
                    Optional result = styledVisitor.accept(run.style().method_27702(style), run.text());
                    if (!result.isPresent()) continue;
                    return result;
                }
                return Optional.empty();
            }
        };
    }

    public void clearCaches() {
        this.cache.clear();
    }

    private static class Highlighter {
        private final int startIndex;
        private final int endIndex;
        private final HighlightConsumer callback;
        private boolean wasRtl = false;
        private float offset = 0.0f;
        private float leftBound = Float.NaN;

        private Highlighter(int startIndex, int endIndex, HighlightConsumer callback) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.callback = callback;
        }

        public void accept(int r0, int r1, boolean rtl, float glyphWidth) {
            if (r1 <= r0) {
                return;
            }
            if (!Float.isNaN(this.leftBound)) {
                float rightBound = Float.NaN;
                if (rtl != this.wasRtl) {
                    rightBound = this.offset;
                } else if (rtl && r1 >= this.startIndex && this.startIndex > r0) {
                    float frac = ((float)this.startIndex - (float)r1) / (float)(r0 - r1);
                    rightBound = this.offset + frac * glyphWidth;
                } else if (!rtl && r0 <= this.endIndex && this.endIndex < r1) {
                    float frac = ((float)this.endIndex - (float)r0) / (float)(r1 - r0);
                    rightBound = this.offset + frac * glyphWidth;
                } else if (r1 < this.startIndex || this.endIndex < r0) {
                    rightBound = this.offset;
                }
                if (!Float.isNaN(rightBound)) {
                    this.callback.accept(this.leftBound, rightBound);
                    this.leftBound = Float.NaN;
                }
            }
            if (Float.isNaN(this.leftBound)) {
                if (rtl && r1 >= this.endIndex && this.endIndex > r0) {
                    frac = ((float)this.endIndex - (float)r1) / (float)(r0 - r1);
                    this.leftBound = this.offset + frac * glyphWidth;
                } else if (!rtl && r0 <= this.startIndex && this.startIndex < r1) {
                    frac = ((float)this.startIndex - (float)r0) / (float)(r1 - r0);
                    this.leftBound = this.offset + frac * glyphWidth;
                } else if (this.startIndex <= r0 && r1 <= this.endIndex) {
                    this.leftBound = this.offset;
                }
            }
            this.offset += glyphWidth;
            this.wasRtl = rtl;
        }

        public void finish() {
            if (!Float.isNaN(this.leftBound)) {
                this.callback.accept(this.leftBound, this.offset);
                this.leftBound = Float.NaN;
            }
        }
    }

    @FunctionalInterface
    public static interface HighlightConsumer {
        public void accept(float var1, float var2);
    }

    @FunctionalInterface
    public static interface IndexedLineWrappingConsumer {
        public static IndexedLineWrappingConsumer from(class_5225.class_5229 callback) {
            return (style, start, end, rtl) -> callback.accept(style, start, end);
        }

        public void accept(class_2583 var1, int var2, int var3, boolean var4);
    }

    @FunctionalInterface
    public static interface DirectionalLineWrappingConsumer {
        public static DirectionalLineWrappingConsumer from(BiConsumer<class_5348, Boolean> callback) {
            return (line, continuation, rtl) -> callback.accept(line, continuation);
        }

        public void accept(class_5348 var1, boolean var2, boolean var3);
    }
}

