/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

public class ForwardTraversedMap {
    protected final IntList entries = new IntArrayList();
    protected int lastAccessedIndex = 0;

    public void reset() {
        this.lastAccessedIndex = 0;
    }

    public int inf(int key) {
        if (key < this.entries.getInt(2 * this.lastAccessedIndex)) {
            throw new IllegalArgumentException("detected inf with descending key");
        }
        while (this.lastAccessedIndex < this.size() - 1 && this.entries.getInt(2 * this.lastAccessedIndex + 2) < key) {
            ++this.lastAccessedIndex;
        }
        return this.entries.getInt(2 * this.lastAccessedIndex + 1);
    }

    public int infp(int key, int factor) {
        if (key < this.entries.getInt(2 * this.lastAccessedIndex) + factor * this.entries.getInt(2 * this.lastAccessedIndex + 1)) {
            throw new IllegalArgumentException("detected inf with descending key");
        }
        while (this.lastAccessedIndex < this.size() - 1 && this.entries.getInt(2 * this.lastAccessedIndex + 2) + factor * this.entries.getInt(2 * this.lastAccessedIndex + 3) < key) {
            ++this.lastAccessedIndex;
        }
        return this.entries.getInt(2 * this.lastAccessedIndex + 1);
    }

    public int getLastResultIndex() {
        return this.lastAccessedIndex;
    }

    public int getLastResultKey() {
        return this.entries.getInt(2 * this.lastAccessedIndex);
    }

    public int getLastResultKey(int offset) {
        return this.entries.getInt(2 * (this.lastAccessedIndex + offset));
    }

    public int getLastResultValue(int offset) {
        return this.entries.getInt(2 * (this.lastAccessedIndex + offset) + 1);
    }

    public int valueOfMaxKey() {
        return this.entries.getInt(this.entries.size() - 1);
    }

    protected int arginfSlow(int key) {
        int lower = 0;
        int upper = this.size();
        while (upper > lower + 1) {
            int mid = lower + upper >>> 1;
            int midVal = this.entries.getInt(2 * mid);
            if (midVal >= key) {
                upper = mid;
                continue;
            }
            lower = mid;
        }
        return lower;
    }

    protected int arginfpSlow(int key, int factor) {
        int lower = 0;
        int upper = this.size();
        while (upper > lower + 1) {
            int mid = lower + upper >>> 1;
            int midVal = this.entries.getInt(2 * mid) + factor * this.entries.getInt(2 * mid + 1);
            if (midVal >= key) {
                upper = mid;
                continue;
            }
            lower = mid;
        }
        return lower;
    }

    public int infSlow(int key, boolean save) {
        int index = this.arginfSlow(key);
        if (save) {
            this.lastAccessedIndex = index;
        }
        return this.entries.getInt(2 * index + 1);
    }

    public int infpSlow(int key, int factor, boolean save) {
        int index = this.arginfpSlow(key, factor);
        if (save) {
            this.lastAccessedIndex = index;
        }
        return this.entries.getInt(2 * index + 1);
    }

    public void put(int key, int value) {
        int size = this.size();
        if (size > 0 && this.entries.getInt(2 * size - 2) == key) {
            this.entries.set(2 * size - 1, value);
        } else {
            this.entries.add(key);
            this.entries.add(value);
        }
    }

    public int size() {
        return this.entries.size() / 2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            if (i == this.lastAccessedIndex) {
                builder.append('(');
            }
            builder.append(this.entries.getInt(2 * i));
            builder.append("=>");
            builder.append(this.entries.getInt(2 * i + 1));
            if (i != this.lastAccessedIndex) continue;
            builder.append(')');
        }
        builder.append('}');
        return builder.toString();
    }
}

