/*
 * Decompiled with CFR 0.152.
 */
package haider.plugin.healthGUI;

import haider.plugin.healthGUI.commands.HealthGUICommand;
import haider.plugin.healthGUI.config.ConfigManager;
import haider.plugin.healthGUI.display.Display3DManager;
import haider.plugin.healthGUI.gui.HealthGUIManager;
import haider.plugin.healthGUI.health.HealthBarManager;
import haider.plugin.healthGUI.language.LanguageManager;
import haider.plugin.healthGUI.selection.SelectionManager;
import java.util.Map;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HealthGUI
extends JavaPlugin {
    private static HealthGUI instance;
    private MiniMessage miniMessage;
    private ConfigManager configManager;
    private LanguageManager languageManager;
    private HealthGUIManager guiManager;
    private HealthBarManager healthBarManager;
    private SelectionManager selectionManager;
    private Display3DManager display3DManager;

    public void onEnable() {
        instance = this;
        this.printStartupBanner();
        this.miniMessage = MiniMessage.miniMessage();
        if (!this.initializeComponents()) {
            this.getLogger().severe("Failed to initialize core components! Disabling plugin...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerEventsAndCommands();
        this.startHealthBarSystem();
        this.printSuccessMessage();
    }

    public void onDisable() {
        this.getLogger().info("Shutting down Mob Health Bars gracefully...");
        if (this.healthBarManager != null) {
            this.healthBarManager.shutdown();
        }
        if (this.display3DManager != null) {
            this.display3DManager.cleanupAllDisplays();
        }
        if (this.selectionManager != null) {
            this.selectionManager.clearAllSelections();
        }
        if (this.configManager != null) {
            this.configManager.saveConfig();
        }
        this.getLogger().info("Mob Health Bars has been disabled successfully!");
        instance = null;
    }

    private void printStartupBanner() {
        this.getLogger().info("===============================================");
        this.getLogger().info("         Mob Health Bars v1.0 Starting        ");
        this.getLogger().info("    Advanced Health Display System with       ");
        this.getLogger().info("      Beautiful GUI & Configuration           ");
        this.getLogger().info("               by Haider                       ");
        this.getLogger().info("===============================================");
    }

    private boolean initializeComponents() {
        try {
            this.getLogger().info("Initializing enhanced core components...");
            this.configManager = new ConfigManager(this);
            this.getLogger().info("\u2713 Configuration Manager initialized with validation");
            this.languageManager = new LanguageManager(this);
            this.getLogger().info("\u2713 Language Manager initialized with multi-language support");
            this.selectionManager = new SelectionManager(this);
            this.getLogger().info("\u2713 Selection Manager initialized for configuration changes");
            this.guiManager = new HealthGUIManager(this);
            this.getLogger().info("\u2713 Enhanced GUI Manager initialized with beautiful interface");
            this.healthBarManager = new HealthBarManager(this);
            this.getLogger().info("\u2713 Health Bar Manager initialized with performance optimization");
            this.display3DManager = new Display3DManager(this);
            this.getLogger().info("\u2713 3D Display Manager initialized for advanced 3D health displays");
            this.getLogger().info("All enhanced components initialized successfully!");
            return true;
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize components: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void registerEventsAndCommands() {
        try {
            this.getLogger().info("Registering enhanced events and commands...");
            Bukkit.getPluginManager().registerEvents((Listener)this.guiManager, (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)this.healthBarManager, (Plugin)this);
            HealthGUICommand commandExecutor = new HealthGUICommand(this);
            this.getCommand("healthgui").setExecutor((CommandExecutor)commandExecutor);
            this.getCommand("healthgui").setTabCompleter((TabCompleter)commandExecutor);
            this.getLogger().info("\u2713 Enhanced events and commands registered successfully");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to register events/commands: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void startHealthBarSystem() {
        try {
            this.healthBarManager.startHealthBarTask();
            this.getLogger().info("\u2713 Enhanced health bar system started with optimization");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to start health bar system: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void printSuccessMessage() {
        this.getLogger().info("===============================================");
        this.getLogger().info("       Mob Health Bars v1.0 Enabled!          ");
        this.getLogger().info("  Beautiful GUI with streamlined config       ");
        this.getLogger().info("     Use /healthgui to open settings          ");
        this.getLogger().info("  No reload/reset - Focus on configuration!   ");
        this.getLogger().info("===============================================");
    }

    public static HealthGUI getInstance() {
        return instance;
    }

    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public HealthGUIManager getGuiManager() {
        return this.guiManager;
    }

    public HealthBarManager getHealthBarManager() {
        return this.healthBarManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public Display3DManager getDisplay3DManager() {
        return this.display3DManager;
    }

    public void applyConfigurationChanges() {
        try {
            this.getLogger().info("Applying configuration changes...");
            this.healthBarManager.shutdown();
            this.healthBarManager.startHealthBarTask();
            this.getLogger().info("\u2713 Configuration changes applied successfully!");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to apply configuration changes: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveCurrentConfiguration() {
        try {
            this.getLogger().info("Saving current configuration...");
            this.configManager.saveConfig();
            this.getLogger().info("\u2713 Configuration saved successfully!");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to save configuration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getSystemStatusSummary() {
        Map<String, Object> status = this.healthBarManager.getSystemStatus();
        StringBuilder summary = new StringBuilder();
        summary.append("System Status: ").append(status.get("running").equals(true) ? "Running" : "Stopped").append("\n");
        summary.append("Active Players: ").append(status.get("activePlayers")).append("\n");
        summary.append("Detection Range: ").append(status.get("detectionRange")).append(" blocks\n");
        summary.append("Optimized Mode: ").append(status.get("optimizedMode").equals(true) ? "Enabled" : "Disabled");
        return summary.toString();
    }
}

