/*
 * Decompiled with CFR 0.152.
 */
package haider.plugin.healthGUI.commands;

import haider.plugin.healthGUI.HealthGUI;
import haider.plugin.healthGUI.selection.SelectionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class HealthGUICommand
implements CommandExecutor,
TabCompleter {
    private final HealthGUI plugin;

    public HealthGUICommand(HealthGUI plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7c\u2717 This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("healthgui.admin")) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<red>\u2717 " + this.plugin.getLanguageManager().getMessage(player, "messages.no.permission", new Object[0]) + "</red>")));
            return true;
        }
        if (args.length == 0) {
            this.plugin.getGuiManager().openMainGUI(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "gui": 
            case "open": 
            case "settings": {
                this.plugin.getGuiManager().openMainGUI(player);
                break;
            }
            case "info": 
            case "status": {
                this.handleInfoCommand(player);
                break;
            }
            case "debug": {
                this.handleDebugCommand(player, args);
                break;
            }
            case "help": {
                this.handleHelpCommand(player);
                break;
            }
            case "version": {
                this.handleVersionCommand(player);
                break;
            }
            case "apply": {
                this.handleApplyCommand(player);
                break;
            }
            case "clear": {
                this.handleClearCommand(player);
                break;
            }
            case "save": {
                this.handleSaveCommand(player);
                break;
            }
            default: {
                this.handleHelpCommand(player);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("healthgui.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            List<String> completions = Arrays.asList("gui", "open", "settings", "info", "status", "debug", "help", "version", "apply", "clear", "save");
            ArrayList<String> result = new ArrayList<String>();
            String partial = args[0].toLowerCase();
            for (String completion : completions) {
                if (!completion.startsWith(partial)) continue;
                result.add(completion);
            }
            return result;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("debug")) {
            return Arrays.asList("selections", "system", "performance", "all");
        }
        return new ArrayList<String>();
    }

    private void handleSaveCommand(Player player) {
        try {
            this.plugin.getConfigManager().saveConfig();
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<green><bold>\ud83d\udcbe Configuration saved successfully!</bold></green>"));
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2022 All current settings have been saved</gray>"));
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2022 Changes are now persistent</gray>"));
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.2f);
            this.plugin.getLogger().info("Configuration saved by " + player.getName());
        }
        catch (Exception e) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<red>\u2717 Failed to save configuration: " + e.getMessage() + "</red>")));
            this.plugin.getLogger().severe("Failed to save configuration: " + e.getMessage());
        }
    }

    private void handleInfoCommand(Player player) {
        Map<String, Object> status = this.plugin.getHealthBarManager().getSystemStatus();
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gradient:#ff6b6b:#4ecdc4><bold>\ud83d\udcca HealthGUI System Information</bold></gradient>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<yellow><bold>\u2728 System Status:</bold></yellow>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Status: " + (status.get("running").equals(true) ? "<green>Running \u2713</green>" : "<red>Stopped \u2717</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Update Interval: <aqua>" + String.valueOf(status.get("updateInterval")) + " ticks</aqua></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Detection Range: <aqua>" + String.valueOf(status.get("detectionRange")) + " blocks</aqua></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Optimized Mode: " + (status.get("optimizedMode").equals(true) ? "<green>Enabled \u2713</green>" : "<red>Disabled \u2717</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<yellow><bold>\ud83d\udc65 Player Statistics:</bold></yellow>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Active Players: <green>" + String.valueOf(status.get("activePlayers")) + "</green></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Total Tracked: <yellow>" + String.valueOf(status.get("totalTrackedPlayers")) + "</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Current Targets: <yellow>" + String.valueOf(status.get("confirmedTargetsCount")) + "</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<yellow><bold>\u2699\ufe0f Current Configuration:</bold></yellow>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Bar Style: <aqua>" + this.plugin.getConfigManager().getFullCharacter() + this.plugin.getConfigManager().getEmptyCharacter() + "</aqua> (Length: <aqua>" + this.plugin.getConfigManager().getBarLength() + "</aqua>)</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Heart Symbol: " + this.plugin.getConfigManager().getHeartSymbol() + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Show Names: " + (this.plugin.getConfigManager().isShowEntityName() ? "<green>Yes</green>" : "<red>No</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Show Percentage: " + (this.plugin.getConfigManager().isShowPercentage() ? "<green>Yes</green>" : "<red>No</red>") + "</gray>")));
        if (this.plugin.getSelectionManager().hasAnyPendingChanges(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<yellow><bold>\ud83d\udcdd Your Pending Changes:</bold></yellow>"));
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Count: <yellow>" + this.plugin.getSelectionManager().getPendingChangesCount(player.getUniqueId()) + "</yellow></gray>")));
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2022 Use <green>/healthgui apply</green> to apply them</gray>"));
        } else {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<green><bold>\u2713 No pending changes</bold></green>"));
        }
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</gray>"));
    }

    private void handleApplyCommand(Player player) {
        if (!this.plugin.getSelectionManager().hasAnyPendingChanges(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<yellow>\u26a0 No pending changes to apply</yellow>"));
            return;
        }
        boolean applied = this.plugin.getSelectionManager().applyPendingSelections(player.getUniqueId());
        if (applied) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<green><bold>\u2705 All pending changes applied successfully!</bold></green>"));
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.2f);
        } else {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<red>\u274c Failed to apply pending changes</red>"));
        }
    }

    private void handleClearCommand(Player player) {
        if (!this.plugin.getSelectionManager().hasAnyPendingChanges(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<yellow>\u26a0 No pending changes to clear</yellow>"));
            return;
        }
        int changesCount = this.plugin.getSelectionManager().getPendingChangesCount(player.getUniqueId());
        this.plugin.getSelectionManager().clearPlayerSelections(player.getUniqueId());
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<yellow>\ud83d\uddd1 Cleared " + changesCount + " pending changes</yellow>")));
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 0.8f);
    }

    private void handleDebugCommand(Player player, String[] args) {
        String debugType;
        if (args.length < 2) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<yellow>Usage: /healthgui debug <selections|system|performance|all></yellow>"));
            return;
        }
        switch (debugType = args[1].toLowerCase()) {
            case "selections": {
                this.debugSelections(player);
                break;
            }
            case "system": {
                this.debugSystem(player);
                break;
            }
            case "performance": {
                this.debugPerformance(player);
                break;
            }
            case "all": {
                this.debugSelections(player);
                this.debugSystem(player);
                this.debugPerformance(player);
                break;
            }
            default: {
                player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<red>Invalid debug type. Use: selections, system, performance, or all</red>"));
            }
        }
    }

    private void debugSelections(Player player) {
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold><bold>\ud83d\udd0d DEBUG: Pending Selections</bold></gold>"));
        SelectionManager.PendingSelection selection = this.plugin.getSelectionManager().getPendingSelection(player.getUniqueId());
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Detection Range: " + (String)(selection.getDetectionRange() != null ? "<yellow>" + selection.getDetectionRange() + "</yellow>" : "<red>null</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Full Character: " + (String)(selection.getFullCharacter() != null ? "<yellow>" + selection.getFullCharacter() + "</yellow>" : "<red>null</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Empty Character: " + (String)(selection.getEmptyCharacter() != null ? "<yellow>" + selection.getEmptyCharacter() + "</yellow>" : "<red>null</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Bar Length: " + (String)(selection.getBarLength() != null ? "<yellow>" + selection.getBarLength() + "</yellow>" : "<red>null</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Heart Symbol: " + (String)(selection.getHeartSymbol() != null ? "<yellow>" + selection.getHeartSymbol() + "</yellow>" : "<red>null</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Show Percentage: " + (String)(selection.getShowPercentage() != null ? "<yellow>" + selection.getShowPercentage() + "</yellow>" : "<red>null</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Show Entity Name: " + (String)(selection.getShowEntityName() != null ? "<yellow>" + selection.getShowEntityName() + "</yellow>" : "<red>null</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Has Changes: <yellow>" + selection.hasAnyChanges() + "</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Changes Count: <yellow>" + selection.getChangesCount() + "</yellow></gray>")));
    }

    private void debugSystem(Player player) {
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold><bold>\ud83d\udd0d DEBUG: System Status</bold></gold>"));
        Map<String, Object> status = this.plugin.getHealthBarManager().getSystemStatus();
        for (Map.Entry<String, Object> entry : status.entrySet()) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 " + entry.getKey() + ": <yellow>" + String.valueOf(entry.getValue()) + "</yellow></gray>")));
        }
    }

    private void debugPerformance(Player player) {
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold><bold>\ud83d\udd0d DEBUG: Performance Metrics</bold></gold>"));
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Used Memory: <yellow>" + usedMemory / 1024L / 1024L + " MB</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Free Memory: <yellow>" + freeMemory / 1024L / 1024L + " MB</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Total Memory: <yellow>" + totalMemory / 1024L / 1024L + " MB</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Online Players: <yellow>" + Bukkit.getOnlinePlayers().size() + "</yellow></gray>")));
    }

    private void handleHelpCommand(Player player) {
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gradient:#ff6b6b:#4ecdc4><bold>\ud83c\udfae HealthGUI Commands</bold></gradient>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui</gold> <gray>- Open the beautiful settings GUI</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui gui</gold> <gray>- Open the main settings interface</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui info</gold> <gray>- Show detailed system information</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui save</gold> <gray>- Save current configuration</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui apply</gold> <gray>- Apply all pending changes</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui clear</gold> <gray>- Clear all pending changes</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui debug <type></gold> <gray>- Show debug information</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui version</gold> <gray>- Show plugin version information</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gold>/healthgui help</gold> <gray>- Show this help message</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\ud83d\udca1 Tip: Use the GUI for easy configuration!</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>Debug types: <yellow>selections</yellow>, <yellow>system</yellow>, <yellow>performance</yellow>, <yellow>all</yellow></gray>"));
    }

    private void handleVersionCommand(Player player) {
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gradient:#ff6b6b:#4ecdc4><bold>HealthGUI Version Information</bold></gradient>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2022 Plugin: <yellow>HealthGUI v2.0-ENHANCED</yellow></gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2022 Author: <yellow>Haider</yellow></gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2022 Features: <green>Beautiful GUI, Multi-language, Performance Optimized</green></gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Minecraft: <yellow>" + Bukkit.getMinecraftVersion() + "</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Server: <yellow>" + Bukkit.getVersion() + "</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>\u2022 Java: <yellow>" + System.getProperty("java.version") + "</yellow></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<gray>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</gray>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<green>\u2728 Focused on beautiful configuration without reload/reset complexity!</green>"));
    }
}

