/*
 * Decompiled with CFR 0.152.
 */
package haider.plugin.healthGUI.config;

import haider.plugin.healthGUI.HealthGUI;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final HealthGUI plugin;
    private FileConfiguration config;
    private int detectionRange;
    private int updateInterval;
    private int barLength;
    private String fullCharacter;
    private String emptyCharacter;
    private boolean showPercentage;
    private boolean showEntityName;
    private boolean showHealthValues;
    private boolean showHealthBar;
    private boolean showHeartSymbol;
    private String heartSymbol;
    private boolean showEntityType;
    private boolean showDistance;
    private boolean showEntityLevel;
    private boolean showArmor;
    private boolean showEffects;
    private boolean showHostilityIndicator;
    private boolean showTamedStatus;
    private boolean showAgeStatus;
    private String displayLocation;
    private int displayDuration;
    private boolean autoHideFullHealth;
    private int autoHideTimeout;
    private int minHealthThreshold;
    private boolean animatedBars;
    private boolean gradientColors;
    private boolean damageIndicators;
    private boolean healingIndicators;
    private boolean unicodeSymbols;
    private boolean compactMode;
    private boolean show3DHealthDisplay;
    private boolean showActionBarDisplay;
    private boolean showPlayerHealth;
    private boolean showNpcHealth;
    private boolean showPassiveMobs;
    private boolean showHostileMobs;
    private boolean showBossHealth;
    private boolean showPetHealth;
    private String standardFormat;
    private String compactFormat;
    private String detailedFormat;
    private String minimalFormat;
    private String customFormat;
    private String activeFormat;
    private String percentageFormat;
    private String distanceFormat;
    private String effectsFormat;
    private String hostileIndicator;
    private String passiveIndicator;
    private String neutralIndicator;
    private String tamedIndicator;
    private String babyIndicator;
    private String healthyColor;
    private String mediumColor;
    private String lowColor;
    private int mediumThreshold;
    private int lowThreshold;
    private boolean optimizedMode;
    private int maxEntitiesPerTick;

    public ConfigManager(HealthGUI plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.detectionRange = this.config.getInt("health-bar.detection-range", 15);
        this.updateInterval = this.config.getInt("health-bar.update-interval", 3);
        this.barLength = this.config.getInt("health-bar.bar-length", 10);
        this.fullCharacter = this.config.getString("health-bar.style.full-char", "\u2588");
        this.emptyCharacter = this.config.getString("health-bar.style.empty-char", "\u2591");
        this.showPercentage = this.config.getBoolean("display.show-percentage", true);
        this.showEntityName = this.config.getBoolean("display.show-entity-name", true);
        this.showHealthValues = this.config.getBoolean("display.show-health-values", true);
        this.showHealthBar = this.config.getBoolean("display.show-health-bar", true);
        this.showHeartSymbol = this.config.getBoolean("display.show-heart-symbol", true);
        this.heartSymbol = this.config.getString("display.heart-symbol", "\u2764");
        this.showEntityType = this.config.getBoolean("display.advanced.show-entity-type", false);
        this.showDistance = this.config.getBoolean("display.advanced.show-distance", false);
        this.showEntityLevel = this.config.getBoolean("display.advanced.show-entity-level", false);
        this.showArmor = this.config.getBoolean("display.advanced.show-armor", false);
        this.showEffects = this.config.getBoolean("display.advanced.show-effects", false);
        this.showHostilityIndicator = this.config.getBoolean("display.advanced.show-hostility-indicator", true);
        this.showTamedStatus = this.config.getBoolean("display.advanced.show-tamed-status", true);
        this.showAgeStatus = this.config.getBoolean("display.advanced.show-age-status", false);
        this.displayLocation = this.config.getString("display.positioning.display-location", "ACTIONBAR");
        this.displayDuration = this.config.getInt("display.positioning.display-duration", 40);
        this.autoHideFullHealth = this.config.getBoolean("display.positioning.auto-hide-full-health", false);
        this.autoHideTimeout = this.config.getInt("display.positioning.auto-hide-timeout", 100);
        this.minHealthThreshold = this.config.getInt("display.positioning.min-health-threshold", 0);
        this.animatedBars = this.config.getBoolean("display.visual.animated-bars", false);
        this.gradientColors = this.config.getBoolean("display.visual.gradient-colors", true);
        this.damageIndicators = this.config.getBoolean("display.visual.damage-indicators", true);
        this.healingIndicators = this.config.getBoolean("display.visual.healing-indicators", true);
        this.unicodeSymbols = this.config.getBoolean("display.visual.unicode-symbols", true);
        this.compactMode = this.config.getBoolean("display.visual.compact-mode", false);
        this.show3DHealthDisplay = this.config.getBoolean("display.visual.show-3d-health-display", true);
        this.showActionBarDisplay = this.config.getBoolean("display.visual.show-action-bar-display", true);
        this.showPlayerHealth = this.config.getBoolean("display.player-options.show-player-health", true);
        this.showNpcHealth = this.config.getBoolean("display.player-options.show-npc-health", true);
        this.showPassiveMobs = this.config.getBoolean("display.player-options.show-passive-mobs", true);
        this.showHostileMobs = this.config.getBoolean("display.player-options.show-hostile-mobs", true);
        this.showBossHealth = this.config.getBoolean("display.player-options.show-boss-health", true);
        this.showPetHealth = this.config.getBoolean("display.player-options.show-pet-health", true);
        this.standardFormat = this.config.getString("display.format.standard", "{hostility} {name} {heart} {health}/{max-health} {percentage} {bar}");
        this.compactFormat = this.config.getString("display.format.compact", "{name} {heart} {percentage} {bar}");
        this.detailedFormat = this.config.getString("display.format.detailed", "{hostility} {name} {type} {heart} {health}/{max-health} {percentage} {bar} {distance} {effects}");
        this.minimalFormat = this.config.getString("display.format.minimal", "{heart} {percentage}");
        this.customFormat = this.config.getString("display.format.custom", "{name} {heart} {health}/{max-health} {percentage} {bar}");
        this.activeFormat = this.config.getString("display.active-format", "standard");
        this.percentageFormat = this.config.getString("display.percentage-format", "({percentage}%)");
        this.distanceFormat = this.config.getString("display.distance-format", "[{distance}m]");
        this.effectsFormat = this.config.getString("display.effects-format", "{effects}");
        this.hostileIndicator = this.config.getString("display.hostility-indicators.hostile", "\u2694");
        this.passiveIndicator = this.config.getString("display.hostility-indicators.passive", "\u262e");
        this.neutralIndicator = this.config.getString("display.hostility-indicators.neutral", "\u2696");
        this.tamedIndicator = this.config.getString("display.hostility-indicators.tamed", "\ud83c\udfe0");
        this.babyIndicator = this.config.getString("display.hostility-indicators.baby", "\ud83c\udf7c");
        this.healthyColor = this.config.getString("colors.healthy", "green");
        this.mediumColor = this.config.getString("colors.medium", "yellow");
        this.lowColor = this.config.getString("colors.low", "red");
        this.mediumThreshold = this.config.getInt("colors.thresholds.medium", 60);
        this.lowThreshold = this.config.getInt("colors.thresholds.low", 30);
        this.optimizedMode = this.config.getBoolean("performance.optimized-mode", true);
        this.maxEntitiesPerTick = this.config.getInt("performance.max-entities-per-tick", 5);
        this.validateConfig();
        this.plugin.getLogger().info("Enhanced configuration loaded successfully with " + this.getEnabledFeaturesCount() + " display features");
    }

    public void saveConfig() {
        try {
            this.config.set("health-bar.detection-range", (Object)this.detectionRange);
            this.config.set("health-bar.update-interval", (Object)this.updateInterval);
            this.config.set("health-bar.bar-length", (Object)this.barLength);
            this.config.set("health-bar.style.full-char", (Object)this.fullCharacter);
            this.config.set("health-bar.style.empty-char", (Object)this.emptyCharacter);
            this.config.set("display.show-percentage", (Object)this.showPercentage);
            this.config.set("display.show-entity-name", (Object)this.showEntityName);
            this.config.set("display.show-health-values", (Object)this.showHealthValues);
            this.config.set("display.show-health-bar", (Object)this.showHealthBar);
            this.config.set("display.show-heart-symbol", (Object)this.showHeartSymbol);
            this.config.set("display.heart-symbol", (Object)this.heartSymbol);
            this.config.set("display.advanced.show-entity-type", (Object)this.showEntityType);
            this.config.set("display.advanced.show-distance", (Object)this.showDistance);
            this.config.set("display.advanced.show-entity-level", (Object)this.showEntityLevel);
            this.config.set("display.advanced.show-armor", (Object)this.showArmor);
            this.config.set("display.advanced.show-effects", (Object)this.showEffects);
            this.config.set("display.advanced.show-hostility-indicator", (Object)this.showHostilityIndicator);
            this.config.set("display.advanced.show-tamed-status", (Object)this.showTamedStatus);
            this.config.set("display.advanced.show-age-status", (Object)this.showAgeStatus);
            this.config.set("display.positioning.display-location", (Object)this.displayLocation);
            this.config.set("display.positioning.display-duration", (Object)this.displayDuration);
            this.config.set("display.positioning.auto-hide-full-health", (Object)this.autoHideFullHealth);
            this.config.set("display.positioning.auto-hide-timeout", (Object)this.autoHideTimeout);
            this.config.set("display.positioning.min-health-threshold", (Object)this.minHealthThreshold);
            this.config.set("display.visual.animated-bars", (Object)this.animatedBars);
            this.config.set("display.visual.gradient-colors", (Object)this.gradientColors);
            this.config.set("display.visual.damage-indicators", (Object)this.damageIndicators);
            this.config.set("display.visual.healing-indicators", (Object)this.healingIndicators);
            this.config.set("display.visual.unicode-symbols", (Object)this.unicodeSymbols);
            this.config.set("display.visual.compact-mode", (Object)this.compactMode);
            this.config.set("display.visual.show-3d-health-display", (Object)this.show3DHealthDisplay);
            this.config.set("display.player-options.show-player-health", (Object)this.showPlayerHealth);
            this.config.set("display.player-options.show-npc-health", (Object)this.showNpcHealth);
            this.config.set("display.player-options.show-passive-mobs", (Object)this.showPassiveMobs);
            this.config.set("display.player-options.show-hostile-mobs", (Object)this.showHostileMobs);
            this.config.set("display.player-options.show-boss-health", (Object)this.showBossHealth);
            this.config.set("display.player-options.show-pet-health", (Object)this.showPetHealth);
            this.config.set("display.format.standard", (Object)this.standardFormat);
            this.config.set("display.format.compact", (Object)this.compactFormat);
            this.config.set("display.format.detailed", (Object)this.detailedFormat);
            this.config.set("display.format.minimal", (Object)this.minimalFormat);
            this.config.set("display.format.custom", (Object)this.customFormat);
            this.config.set("display.active-format", (Object)this.activeFormat);
            this.config.set("colors.healthy", (Object)this.healthyColor);
            this.config.set("colors.medium", (Object)this.mediumColor);
            this.config.set("colors.low", (Object)this.lowColor);
            this.config.set("colors.thresholds.medium", (Object)this.mediumThreshold);
            this.config.set("colors.thresholds.low", (Object)this.lowThreshold);
            this.config.set("performance.optimized-mode", (Object)this.optimizedMode);
            this.config.set("performance.max-entities-per-tick", (Object)this.maxEntitiesPerTick);
            this.plugin.saveConfig();
            this.plugin.getLogger().info("Enhanced configuration saved successfully");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to save enhanced configuration: " + e.getMessage());
        }
    }

    public String getCurrentFormatTemplate() {
        switch (this.activeFormat.toLowerCase()) {
            case "compact": {
                return this.compactFormat;
            }
            case "detailed": {
                return this.detailedFormat;
            }
            case "minimal": {
                return this.minimalFormat;
            }
            case "custom": {
                return this.customFormat;
            }
        }
        return this.standardFormat;
    }

    public String formatEnhancedHealthMessage(String entityName, String entityType, double currentHealth, double maxHealth, double distance, String effects, boolean isHostile, boolean isTamed, boolean isBaby) {
        String template;
        double percentage = maxHealth > 0.0 ? currentHealth / maxHealth * 100.0 : 0.0;
        String healthBar = this.showHealthBar ? this.createHealthBar(currentHealth, maxHealth) : "";
        String message = template = this.getCurrentFormatTemplate();
        message = this.showEntityName && entityName != null ? message.replace("{name}", entityName) : message.replace("{name}", "");
        message = this.showEntityType && entityType != null ? message.replace("{type}", entityType) : message.replace("{type}", "");
        message = this.showHeartSymbol ? message.replace("{heart}", this.heartSymbol) : message.replace("{heart}", "");
        if (this.showHealthValues) {
            message = message.replace("{health}", String.valueOf((int)Math.round(currentHealth)));
            message = message.replace("{max-health}", String.valueOf((int)Math.round(maxHealth)));
        } else {
            message = message.replace("{health}", "").replace("{max-health}", "");
        }
        message = message.replace("{bar}", healthBar);
        if (this.showPercentage) {
            String formattedPercentage = this.percentageFormat.replace("{percentage}", String.valueOf((int)Math.round(percentage)));
            message = message.replace("{percentage}", formattedPercentage);
        } else {
            message = message.replace("{percentage}", "");
        }
        if (this.showDistance) {
            String formattedDistance = this.distanceFormat.replace("{distance}", String.valueOf((int)Math.round(distance)));
            message = message.replace("{distance}", formattedDistance);
        } else {
            message = message.replace("{distance}", "");
        }
        if (this.showEffects && effects != null && !effects.isEmpty()) {
            String formattedEffects = this.effectsFormat.replace("{effects}", effects);
            message = message.replace("{effects}", formattedEffects);
        } else {
            message = message.replace("{effects}", "");
        }
        if (this.showHostilityIndicator) {
            String indicator = "";
            indicator = isTamed && this.showTamedStatus ? this.tamedIndicator : (isBaby && this.showAgeStatus ? this.babyIndicator : (isHostile ? this.hostileIndicator : this.passiveIndicator));
            message = message.replace("{hostility}", indicator);
        } else {
            message = message.replace("{hostility}", "");
        }
        return message.replaceAll("\\s+", " ").trim();
    }

    public String createHealthBar(double currentHealth, double maxHealth) {
        if (maxHealth <= 0.0) {
            return "[" + this.emptyCharacter.repeat(this.barLength) + "]";
        }
        double percentage = Math.max(0.0, Math.min(1.0, currentHealth / maxHealth));
        int filledBars = (int)Math.round(percentage * (double)this.barLength);
        int emptyBars = this.barLength - filledBars;
        StringBuilder bar = new StringBuilder();
        bar.append("[");
        bar.append(this.fullCharacter.repeat(Math.max(0, filledBars)));
        bar.append(this.emptyCharacter.repeat(Math.max(0, emptyBars)));
        bar.append("]");
        return bar.toString();
    }

    public String formatHealthMessage(String entityName, double currentHealth, double maxHealth) {
        return this.formatEnhancedHealthMessage(entityName, null, currentHealth, maxHealth, 0.0, null, false, false, false);
    }

    private void validateConfig() {
        boolean needsSave = false;
        if (this.detectionRange < 1 || this.detectionRange > 100) {
            this.plugin.getLogger().warning("Detection range out of bounds, resetting to 15");
            this.detectionRange = 15;
            needsSave = true;
        }
        if (this.updateInterval < 1 || this.updateInterval > 20) {
            this.plugin.getLogger().warning("Update interval out of bounds, resetting to 3");
            this.updateInterval = 3;
            needsSave = true;
        }
        if (this.barLength < 1 || this.barLength > 50) {
            this.plugin.getLogger().warning("Bar length out of bounds, resetting to 10");
            this.barLength = 10;
            needsSave = true;
        }
        if (this.mediumThreshold <= this.lowThreshold) {
            this.plugin.getLogger().warning("Invalid health thresholds, resetting to defaults");
            this.mediumThreshold = 60;
            this.lowThreshold = 30;
            needsSave = true;
        }
        if (this.maxEntitiesPerTick < 1 || this.maxEntitiesPerTick > 20) {
            this.plugin.getLogger().warning("Max entities per tick out of bounds, resetting to 5");
            this.maxEntitiesPerTick = 5;
            needsSave = true;
        }
        if (needsSave) {
            this.saveConfig();
        }
    }

    public String getHealthColorByPercentage(double percentage) {
        if (percentage >= (double)this.mediumThreshold) {
            return this.healthyColor;
        }
        if (percentage >= (double)this.lowThreshold) {
            return this.mediumColor;
        }
        return this.lowColor;
    }

    public void resetToDefaults() {
        this.detectionRange = 15;
        this.updateInterval = 3;
        this.barLength = 10;
        this.fullCharacter = "\u2588";
        this.emptyCharacter = "\u2591";
        this.showPercentage = true;
        this.showEntityName = true;
        this.showHealthValues = true;
        this.showHealthBar = true;
        this.showHeartSymbol = true;
        this.heartSymbol = "\u2764";
        this.showEntityType = false;
        this.showDistance = false;
        this.showEntityLevel = false;
        this.showArmor = false;
        this.showEffects = false;
        this.showHostilityIndicator = true;
        this.showTamedStatus = true;
        this.showAgeStatus = false;
        this.displayLocation = "ACTIONBAR";
        this.animatedBars = false;
        this.gradientColors = true;
        this.compactMode = false;
        this.activeFormat = "standard";
        this.showPlayerHealth = true;
        this.showHostileMobs = true;
        this.showPassiveMobs = true;
        this.showBossHealth = true;
        this.healthyColor = "green";
        this.mediumColor = "yellow";
        this.lowColor = "red";
        this.mediumThreshold = 60;
        this.lowThreshold = 30;
        this.optimizedMode = true;
        this.maxEntitiesPerTick = 5;
        this.saveConfig();
        this.plugin.getLogger().info("Configuration reset to defaults");
    }

    public int getEnabledFeaturesCount() {
        int count = 0;
        if (this.showPercentage) {
            ++count;
        }
        if (this.showEntityName) {
            ++count;
        }
        if (this.showHealthValues) {
            ++count;
        }
        if (this.showHealthBar) {
            ++count;
        }
        if (this.showHeartSymbol) {
            ++count;
        }
        if (this.showEntityType) {
            ++count;
        }
        if (this.showDistance) {
            ++count;
        }
        if (this.showEntityLevel) {
            ++count;
        }
        if (this.showArmor) {
            ++count;
        }
        if (this.showEffects) {
            ++count;
        }
        if (this.showHostilityIndicator) {
            ++count;
        }
        if (this.showTamedStatus) {
            ++count;
        }
        if (this.showAgeStatus) {
            ++count;
        }
        return count;
    }

    public boolean isOptionEnabled(int slot) {
        switch (slot) {
            case 10: {
                return this.showEntityName;
            }
            case 11: {
                return this.showPercentage;
            }
            case 12: {
                return this.showHealthValues;
            }
            case 13: {
                return this.showHealthBar;
            }
            case 14: {
                return this.showHeartSymbol;
            }
            case 19: {
                return this.showEntityType;
            }
            case 20: {
                return this.showDistance;
            }
            case 21: {
                return this.showHostilityIndicator;
            }
            case 22: {
                return this.showTamedStatus;
            }
            case 23: {
                return this.showAgeStatus;
            }
            case 28: {
                return this.showPlayerHealth;
            }
            case 29: {
                return this.showHostileMobs;
            }
            case 30: {
                return this.showPassiveMobs;
            }
            case 31: {
                return this.showBossHealth;
            }
        }
        return false;
    }

    public void setOptionEnabled(int slot, boolean enabled) {
        switch (slot) {
            case 10: {
                this.showEntityName = enabled;
                break;
            }
            case 11: {
                this.showPercentage = enabled;
                break;
            }
            case 12: {
                this.showHealthValues = enabled;
                break;
            }
            case 13: {
                this.showHealthBar = enabled;
                break;
            }
            case 14: {
                this.showHeartSymbol = enabled;
                break;
            }
            case 19: {
                this.showEntityType = enabled;
                break;
            }
            case 20: {
                this.showDistance = enabled;
                break;
            }
            case 21: {
                this.showHostilityIndicator = enabled;
                break;
            }
            case 22: {
                this.showTamedStatus = enabled;
                break;
            }
            case 23: {
                this.showAgeStatus = enabled;
                break;
            }
            case 28: {
                this.showPlayerHealth = enabled;
                break;
            }
            case 29: {
                this.showHostileMobs = enabled;
                break;
            }
            case 30: {
                this.showPassiveMobs = enabled;
                break;
            }
            case 31: {
                this.showBossHealth = enabled;
            }
        }
    }

    public int getDetectionRange() {
        return this.detectionRange;
    }

    public void setDetectionRange(int detectionRange) {
        this.detectionRange = Math.max(1, Math.min(100, detectionRange));
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = Math.max(1, Math.min(20, updateInterval));
    }

    public int getBarLength() {
        return this.barLength;
    }

    public void setBarLength(int barLength) {
        this.barLength = Math.max(1, Math.min(50, barLength));
    }

    public String getFullCharacter() {
        return this.fullCharacter;
    }

    public void setFullCharacter(String fullCharacter) {
        this.fullCharacter = fullCharacter != null ? fullCharacter : "\u2588";
    }

    public String getEmptyCharacter() {
        return this.emptyCharacter;
    }

    public void setEmptyCharacter(String emptyCharacter) {
        this.emptyCharacter = emptyCharacter != null ? emptyCharacter : "\u2591";
    }

    public boolean isShowPercentage() {
        return this.showPercentage;
    }

    public void setShowPercentage(boolean showPercentage) {
        this.showPercentage = showPercentage;
    }

    public boolean isShowEntityName() {
        return this.showEntityName;
    }

    public void setShowEntityName(boolean showEntityName) {
        this.showEntityName = showEntityName;
    }

    public String getHeartSymbol() {
        return this.heartSymbol;
    }

    public void setHeartSymbol(String heartSymbol) {
        this.heartSymbol = heartSymbol != null ? heartSymbol : "\u2764";
    }

    public String getHealthyColor() {
        return this.healthyColor;
    }

    public void setHealthyColor(String healthyColor) {
        this.healthyColor = healthyColor != null ? healthyColor : "green";
    }

    public String getMediumColor() {
        return this.mediumColor;
    }

    public void setMediumColor(String mediumColor) {
        this.mediumColor = mediumColor != null ? mediumColor : "yellow";
    }

    public String getLowColor() {
        return this.lowColor;
    }

    public void setLowColor(String lowColor) {
        this.lowColor = lowColor != null ? lowColor : "red";
    }

    public int getMediumThreshold() {
        return this.mediumThreshold;
    }

    public void setMediumThreshold(int mediumThreshold) {
        this.mediumThreshold = Math.max(1, Math.min(99, mediumThreshold));
    }

    public int getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(int lowThreshold) {
        this.lowThreshold = Math.max(1, Math.min(this.mediumThreshold - 1, lowThreshold));
    }

    public boolean isOptimizedMode() {
        return this.optimizedMode;
    }

    public void setOptimizedMode(boolean optimizedMode) {
        this.optimizedMode = optimizedMode;
    }

    public int getMaxEntitiesPerTick() {
        return this.maxEntitiesPerTick;
    }

    public void setMaxEntitiesPerTick(int maxEntitiesPerTick) {
        this.maxEntitiesPerTick = Math.max(1, Math.min(20, maxEntitiesPerTick));
    }

    public boolean isShowEntityType() {
        return this.showEntityType;
    }

    public void setShowEntityType(boolean showEntityType) {
        this.showEntityType = showEntityType;
    }

    public boolean isShowDistance() {
        return this.showDistance;
    }

    public void setShowDistance(boolean showDistance) {
        this.showDistance = showDistance;
    }

    public boolean isShowEntityLevel() {
        return this.showEntityLevel;
    }

    public void setShowEntityLevel(boolean showEntityLevel) {
        this.showEntityLevel = showEntityLevel;
    }

    public boolean isShowArmor() {
        return this.showArmor;
    }

    public void setShowArmor(boolean showArmor) {
        this.showArmor = showArmor;
    }

    public boolean isShowEffects() {
        return this.showEffects;
    }

    public void setShowEffects(boolean showEffects) {
        this.showEffects = showEffects;
    }

    public boolean isShowHostilityIndicator() {
        return this.showHostilityIndicator;
    }

    public void setShowHostilityIndicator(boolean showHostilityIndicator) {
        this.showHostilityIndicator = showHostilityIndicator;
    }

    public boolean isShowTamedStatus() {
        return this.showTamedStatus;
    }

    public void setShowTamedStatus(boolean showTamedStatus) {
        this.showTamedStatus = showTamedStatus;
    }

    public boolean isShowAgeStatus() {
        return this.showAgeStatus;
    }

    public void setShowAgeStatus(boolean showAgeStatus) {
        this.showAgeStatus = showAgeStatus;
    }

    public boolean isShowHealthValues() {
        return this.showHealthValues;
    }

    public void setShowHealthValues(boolean showHealthValues) {
        this.showHealthValues = showHealthValues;
    }

    public boolean isShowHealthBar() {
        return this.showHealthBar;
    }

    public void setShowHealthBar(boolean showHealthBar) {
        this.showHealthBar = showHealthBar;
    }

    public boolean isShowHeartSymbol() {
        return this.showHeartSymbol;
    }

    public void setShowHeartSymbol(boolean showHeartSymbol) {
        this.showHeartSymbol = showHeartSymbol;
    }

    public String getDisplayLocation() {
        return this.displayLocation;
    }

    public void setDisplayLocation(String displayLocation) {
        this.displayLocation = displayLocation;
    }

    public boolean isAnimatedBars() {
        return this.animatedBars;
    }

    public void setAnimatedBars(boolean animatedBars) {
        this.animatedBars = animatedBars;
    }

    public boolean isGradientColors() {
        return this.gradientColors;
    }

    public void setGradientColors(boolean gradientColors) {
        this.gradientColors = gradientColors;
    }

    public boolean isCompactMode() {
        return this.compactMode;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public String getActiveFormat() {
        return this.activeFormat;
    }

    public void setActiveFormat(String activeFormat) {
        this.activeFormat = activeFormat;
    }

    public boolean isShowPlayerHealth() {
        return this.showPlayerHealth;
    }

    public void setShowPlayerHealth(boolean showPlayerHealth) {
        this.showPlayerHealth = showPlayerHealth;
    }

    public boolean isShowHostileMobs() {
        return this.showHostileMobs;
    }

    public void setShowHostileMobs(boolean showHostileMobs) {
        this.showHostileMobs = showHostileMobs;
    }

    public boolean isShowPassiveMobs() {
        return this.showPassiveMobs;
    }

    public void setShowPassiveMobs(boolean showPassiveMobs) {
        this.showPassiveMobs = showPassiveMobs;
    }

    public boolean isShowBossHealth() {
        return this.showBossHealth;
    }

    public void setShowBossHealth(boolean showBossHealth) {
        this.showBossHealth = showBossHealth;
    }

    public boolean isShowNpcHealth() {
        return this.showNpcHealth;
    }

    public void setShowNpcHealth(boolean showNpcHealth) {
        this.showNpcHealth = showNpcHealth;
    }

    public boolean isShowPetHealth() {
        return this.showPetHealth;
    }

    public void setShowPetHealth(boolean showPetHealth) {
        this.showPetHealth = showPetHealth;
    }

    public int getDisplayDuration() {
        return this.displayDuration;
    }

    public void setDisplayDuration(int displayDuration) {
        this.displayDuration = displayDuration;
    }

    public boolean isAutoHideFullHealth() {
        return this.autoHideFullHealth;
    }

    public void setAutoHideFullHealth(boolean autoHideFullHealth) {
        this.autoHideFullHealth = autoHideFullHealth;
    }

    public int getAutoHideTimeout() {
        return this.autoHideTimeout;
    }

    public void setAutoHideTimeout(int autoHideTimeout) {
        this.autoHideTimeout = autoHideTimeout;
    }

    public int getMinHealthThreshold() {
        return this.minHealthThreshold;
    }

    public void setMinHealthThreshold(int minHealthThreshold) {
        this.minHealthThreshold = minHealthThreshold;
    }

    public boolean isDamageIndicators() {
        return this.damageIndicators;
    }

    public void setDamageIndicators(boolean damageIndicators) {
        this.damageIndicators = damageIndicators;
    }

    public boolean isHealingIndicators() {
        return this.healingIndicators;
    }

    public void setHealingIndicators(boolean healingIndicators) {
        this.healingIndicators = healingIndicators;
    }

    public boolean isUnicodeSymbols() {
        return this.unicodeSymbols;
    }

    public void setUnicodeSymbols(boolean unicodeSymbols) {
        this.unicodeSymbols = unicodeSymbols;
    }

    public String getStandardFormat() {
        return this.standardFormat;
    }

    public void setStandardFormat(String standardFormat) {
        this.standardFormat = standardFormat;
    }

    public String getCompactFormat() {
        return this.compactFormat;
    }

    public void setCompactFormat(String compactFormat) {
        this.compactFormat = compactFormat;
    }

    public String getDetailedFormat() {
        return this.detailedFormat;
    }

    public void setDetailedFormat(String detailedFormat) {
        this.detailedFormat = detailedFormat;
    }

    public String getMinimalFormat() {
        return this.minimalFormat;
    }

    public void setMinimalFormat(String minimalFormat) {
        this.minimalFormat = minimalFormat;
    }

    public String getCustomFormat() {
        return this.customFormat;
    }

    public void setCustomFormat(String customFormat) {
        this.customFormat = customFormat;
    }

    public String getPercentageFormat() {
        return this.percentageFormat;
    }

    public void setPercentageFormat(String percentageFormat) {
        this.percentageFormat = percentageFormat;
    }

    public String getDistanceFormat() {
        return this.distanceFormat;
    }

    public void setDistanceFormat(String distanceFormat) {
        this.distanceFormat = distanceFormat;
    }

    public String getEffectsFormat() {
        return this.effectsFormat;
    }

    public void setEffectsFormat(String effectsFormat) {
        this.effectsFormat = effectsFormat;
    }

    public String getHostileIndicator() {
        return this.hostileIndicator;
    }

    public void setHostileIndicator(String hostileIndicator) {
        this.hostileIndicator = hostileIndicator;
    }

    public String getPassiveIndicator() {
        return this.passiveIndicator;
    }

    public void setPassiveIndicator(String passiveIndicator) {
        this.passiveIndicator = passiveIndicator;
    }

    public String getNeutralIndicator() {
        return this.neutralIndicator;
    }

    public void setNeutralIndicator(String neutralIndicator) {
        this.neutralIndicator = neutralIndicator;
    }

    public String getTamedIndicator() {
        return this.tamedIndicator;
    }

    public void setTamedIndicator(String tamedIndicator) {
        this.tamedIndicator = tamedIndicator;
    }

    public String getBabyIndicator() {
        return this.babyIndicator;
    }

    public void setBabyIndicator(String babyIndicator) {
        this.babyIndicator = babyIndicator;
    }

    public boolean isShow3DHealthDisplay() {
        return this.show3DHealthDisplay;
    }

    public void setShow3DHealthDisplay(boolean show3DHealthDisplay) {
        boolean wasEnabled = this.show3DHealthDisplay;
        this.show3DHealthDisplay = show3DHealthDisplay;
        this.config.set("display.visual.show-3d-health-display", (Object)show3DHealthDisplay);
        this.saveConfig();
        if (this.plugin.getDisplay3DManager() != null) {
            if (show3DHealthDisplay && !wasEnabled) {
                this.plugin.getDisplay3DManager().restart3DSystem();
            } else if (!show3DHealthDisplay && wasEnabled) {
                this.plugin.getDisplay3DManager().cleanupAllDisplays();
            }
        }
    }

    public boolean isShowActionBarDisplay() {
        return this.showActionBarDisplay;
    }

    public void setShowActionBarDisplay(boolean showActionBarDisplay) {
        this.showActionBarDisplay = showActionBarDisplay;
        this.config.set("display.visual.show-action-bar-display", (Object)showActionBarDisplay);
        this.saveConfig();
    }
}

