/*
 * Decompiled with CFR 0.152.
 */
package haider.plugin.healthGUI.gui;

import haider.plugin.healthGUI.HealthGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class HealthGUIManager
implements Listener {
    private final HealthGUI plugin;

    public HealthGUIManager(HealthGUI plugin) {
        this.plugin = plugin;
    }

    public void openMainGUI(Player player) {
        int i;
        String translatedTitle = this.plugin.getLanguageManager().getTranslatedGUITitle(player, "main");
        Component titleComponent = this.plugin.getMiniMessage().deserialize((Object)translatedTitle);
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)titleComponent);
        String titleText = this.plugin.getLanguageManager().getMessage(player, "gui.main.title", new Object[0]);
        ItemStack titleItem = this.createItem(Material.NETHER_STAR, "<gradient:#ff6b6b:#4ecdc4><bold>" + titleText + "</bold></gradient>", Arrays.asList("<gray>Configure your health bar display system</gray>", "<gray>Choose from the options below</gray>", "", "<yellow>\u2728 Beautiful and organized interface \u2728</yellow>"));
        gui.setItem(4, titleItem);
        String rangeTitle = this.plugin.getLanguageManager().getMessage(player, "gui.detection.range", new Object[0]);
        ItemStack rangeItem = this.createItem(Material.ENDER_EYE, "<gold><bold>\ud83d\udd0d " + rangeTitle + "</bold></gold>", Arrays.asList("<gray>Current: <green>" + this.plugin.getConfigManager().getDetectionRange() + " blocks</green></gray>", "<gray>Entities within this range will show health bars</gray>", "<gray>Recommended: 10-20 blocks</gray>", "", "<yellow>\u25b6 " + this.plugin.getLanguageManager().getMessage(player, "gui.click.to.configure", new Object[0]) + "</yellow>"));
        gui.setItem(19, rangeItem);
        String styleTitle = this.plugin.getLanguageManager().getMessage(player, "gui.health.bar.style", new Object[0]);
        ItemStack styleItem = this.createItem(Material.PAINTING, "<light_purple><bold>\ud83c\udfa8 " + styleTitle + "</bold></light_purple>", Arrays.asList("<gray>Style: <green>" + this.plugin.getConfigManager().getFullCharacter() + this.plugin.getConfigManager().getEmptyCharacter() + "</green></gray>", "<gray>Length: <green>" + this.plugin.getConfigManager().getBarLength() + " bars</green></gray>", "<gray>20+ beautiful styles available</gray>", "", "<yellow>\u25b6 " + this.plugin.getLanguageManager().getMessage(player, "gui.click.to.configure", new Object[0]) + "</yellow>"));
        gui.setItem(21, styleItem);
        String heartTitle = this.plugin.getLanguageManager().getMessage(player, "gui.heart.symbols", new Object[0]);
        ItemStack heartItem = this.createItem(Material.RED_DYE, "<red><bold>\u2764 " + heartTitle + "</bold></red>", Arrays.asList("<gray>Current: " + this.plugin.getConfigManager().getHeartSymbol() + "</gray>", "<gray>Choose from 20+ beautiful heart symbols</gray>", "<gray>Customize your health display</gray>", "", "<yellow>\u25b6 " + this.plugin.getLanguageManager().getMessage(player, "gui.click.to.configure", new Object[0]) + "</yellow>"));
        gui.setItem(23, heartItem);
        ItemStack colorItem = this.createItem(Material.PRISMARINE_CRYSTALS, "<blue><bold>\ud83c\udf08 Color Settings</bold></blue>", Arrays.asList("<gray>Healthy: <color:" + this.plugin.getConfigManager().getHealthyColor() + ">\u25a0\u25a0\u25a0</color> " + this.plugin.getConfigManager().getHealthyColor() + "</gray>", "<gray>Medium: <color:" + this.plugin.getConfigManager().getMediumColor() + ">\u25a0\u25a0\u25a0</color> " + this.plugin.getConfigManager().getMediumColor() + "</gray>", "<gray>Low: <color:" + this.plugin.getConfigManager().getLowColor() + ">\u25a0\u25a0\u25a0</color> " + this.plugin.getConfigManager().getLowColor() + "</gray>", "<gray>Configure beautiful health bar colors</gray>", "", "<yellow>\u25b6 Click to configure</yellow>"));
        gui.setItem(25, colorItem);
        String display3DTitle = this.plugin.getLanguageManager().getMessage(player, "gui.3d.health.display", new Object[0]);
        ItemStack display3DItem = this.createItem(Material.ARMOR_STAND, "<gold><bold>\ud83c\udfaf " + display3DTitle + "</bold></gold>", Arrays.asList("<gray>Status: " + (this.plugin.getConfigManager().isShow3DHealthDisplay() ? "<green>\u2713 Enabled</green>" : "<red>\u2717 Disabled</red>") + "</gray>", "<gray>Show floating health displays above entities</gray>", "<gray>Professional 3D health bars with animations</gray>", "<gray>Uses armor stands for optimal performance</gray>", "", "<yellow>\u25b6 " + this.plugin.getLanguageManager().getMessage(player, "gui.click.to.toggle", new Object[0]) + "</yellow>"));
        gui.setItem(28, display3DItem);
        ItemStack actionBarItem = this.createItem(Material.BOOK, "<blue><bold>\ud83d\udcf1 Action Bar Display</bold></blue>", Arrays.asList("<gray>Status: " + (this.plugin.getConfigManager().isShowActionBarDisplay() ? "<green>\u2713 Enabled</green>" : "<red>\u2717 Disabled</red>") + "</gray>", "<gray>Show health bars at the bottom of screen</gray>", "<gray>Displays health information in action bar</gray>", "<gray>Clean and unobtrusive display</gray>", "", "<yellow>\u25b6 " + this.plugin.getLanguageManager().getMessage(player, "gui.click.to.toggle", new Object[0]) + "</yellow>"));
        gui.setItem(29, actionBarItem);
        String displayTitle = this.plugin.getLanguageManager().getMessage(player, "gui.display.options", new Object[0]);
        ItemStack displayItem = this.createItem(Material.ITEM_FRAME, "<green><bold>\ud83d\udc41 " + displayTitle + "</bold></green>", Arrays.asList("<gray>Entity Names: " + (this.plugin.getConfigManager().isShowEntityName() ? "<green>\u2713 Enabled</green>" : "<red>\u2717 Disabled</red>") + "</gray>", "<gray>Percentage: " + (this.plugin.getConfigManager().isShowPercentage() ? "<green>\u2713 Enabled</green>" : "<red>\u2717 Disabled</red>") + "</gray>", "<gray>Toggle what information to display</gray>", "", "<yellow>\u25b6 Click to toggle options</yellow>"));
        gui.setItem(30, displayItem);
        ItemStack perfItem = this.createItem(Material.REDSTONE, "<red><bold>\u26a1 Performance Settings</bold></red>", Arrays.asList("<gray>Optimized Mode: " + (this.plugin.getConfigManager().isOptimizedMode() ? "<green>\u2713 Enabled</green>" : "<red>\u2717 Disabled</red>") + "</gray>", "<gray>Max entities/tick: <green>" + this.plugin.getConfigManager().getMaxEntitiesPerTick() + "</green></gray>", "<gray>Optimize for better server performance</gray>", "", "<yellow>\u25b6 Click to configure</yellow>"));
        gui.setItem(32, perfItem);
        ItemStack infoItem = this.createItem(Material.BOOK, "<aqua><bold>\ud83d\udcca System Information</bold></aqua>", Arrays.asList("<gray>View detailed system status</gray>", "<gray>Active players, performance metrics</gray>", "<gray>Configuration summary</gray>", "", "<yellow>\u25b6 Click for details</yellow>"));
        gui.setItem(34, infoItem);
        String saveTitle = this.plugin.getLanguageManager().getMessage(player, "gui.save.settings", new Object[0]);
        ItemStack saveItem = this.createItem(Material.EMERALD, "<green><bold>\ud83d\udcbe " + saveTitle + "</bold></green>", Arrays.asList("<gray>Save all current configuration</gray>", "<gray>Apply changes to the system</gray>", "<gray>Restart health bar display</gray>", "", "<green>\u25b6 Click to save</green>"));
        gui.setItem(49, saveItem);
        if (this.plugin.getSelectionManager().hasAnyPendingChanges(player.getUniqueId())) {
            int changesCount = this.plugin.getSelectionManager().getPendingChangesCount(player.getUniqueId());
            ItemStack applyItem = this.createItem(Material.LIME_DYE, "<lime><bold>\u2705 Apply Changes (" + changesCount + ")</bold></lime>", Arrays.asList("<gray>You have " + changesCount + " pending changes</gray>", "<gray>Click to apply all changes</gray>", "", "<lime>\u25b6 Click to apply</lime>"));
            gui.setItem(47, applyItem);
        }
        if (this.plugin.getSelectionManager().hasAnyPendingChanges(player.getUniqueId())) {
            ItemStack clearItem = this.createItem(Material.ORANGE_DYE, "<orange><bold>\ud83d\uddd1 Clear Changes</bold></orange>", Arrays.asList("<gray>Clear all pending changes</gray>", "<gray>Discard unsaved modifications</gray>", "", "<orange>\u25b6 Click to clear</orange>"));
            gui.setItem(51, clearItem);
        }
        ItemStack borderPane = this.createItem(Material.CYAN_STAINED_GLASS_PANE, " ", Arrays.asList(new String[0]));
        for (i = 0; i < 9; ++i) {
            if (i == 4) continue;
            gui.setItem(i, borderPane);
        }
        for (i = 45; i < 54; ++i) {
            if (i == 47 || i == 49 || i == 51) continue;
            gui.setItem(i, borderPane);
        }
        gui.setItem(9, borderPane);
        gui.setItem(17, borderPane);
        gui.setItem(18, borderPane);
        gui.setItem(26, borderPane);
        gui.setItem(27, borderPane);
        gui.setItem(35, borderPane);
        gui.setItem(36, borderPane);
        gui.setItem(44, borderPane);
        player.openInventory(gui);
    }

    public void openRangeSettingsGUI(Player player) {
        Component titleComponent = this.plugin.getMiniMessage().deserialize((Object)"<gold>\ud83d\udd0d Detection Range Configuration</gold>");
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)titleComponent);
        int currentRange = this.plugin.getConfigManager().getDetectionRange();
        ItemStack currentItem = this.createItem(Material.ENDER_EYE, "<gold><bold>Current Detection Range</bold></gold>", Arrays.asList("<gray>Current: <green>" + currentRange + " blocks</green></gray>", "<gray>Choose a new range below</gray>", "", "<yellow>\u25bc Available ranges \u25bc</yellow>"));
        gui.setItem(4, currentItem);
        int[] ranges = new int[]{5, 8, 10, 12, 15, 18, 20, 25, 30, 40, 50, 75, 100};
        for (int i = 0; i < ranges.length; ++i) {
            int range = ranges[i];
            Material material = range == currentRange ? Material.LIME_DYE : Material.GRAY_DYE;
            String title = range == currentRange ? "<green><bold>\u2713 " + range + " Blocks (Current)</bold></green>" : "<white>" + range + " Blocks</white>";
            ItemStack rangeItem = this.createItem(material, title, Arrays.asList("<gray>Detection range: " + range + " blocks</gray>", "<gray>Entities within " + range + " blocks will show health bars</gray>", "<gray>Performance impact: " + this.getPerformanceImpact(range) + "</gray>", "", range == currentRange ? "<green>\u25b6 Currently active</green>" : "<yellow>\u25b6 Click to select</yellow>"));
            int row = i / 7;
            int col = i % 7;
            int slot = 19 + row * 9 + col;
            if (slot >= 45) continue;
            gui.setItem(slot, rangeItem);
        }
        gui.setItem(45, this.createItem(Material.ARROW, "<gray>\u2190 Back to Main Menu</gray>", Arrays.asList("<gray>Return to main settings</gray>")));
        gui.setItem(49, this.createItem(Material.EMERALD_BLOCK, "<green><bold>\u2713 Apply Changes</bold></green>", Arrays.asList("<gray>Save and apply selected range</gray>")));
        player.openInventory(gui);
    }

    private String getPerformanceImpact(int range) {
        if (range <= 10) {
            return "<green>Low</green>";
        }
        if (range <= 25) {
            return "<yellow>Medium</yellow>";
        }
        if (range <= 50) {
            return "<orange>High</orange>";
        }
        return "<red>Very High</red>";
    }

    public void openHeartSymbolsGUI(Player player) {
        Component titleComponent = this.plugin.getMiniMessage().deserialize((Object)"<red>\u2764 Heart Symbols Selection</red>");
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)titleComponent);
        String currentHeart = this.plugin.getConfigManager().getHeartSymbol();
        ItemStack currentItem = this.createItem(Material.RED_DYE, "<red><bold>Current Heart Symbol</bold></red>", Arrays.asList("<gray>Current: " + currentHeart + "</gray>", "<gray>Preview: Player " + currentHeart + " 20/20 (100%)</gray>", "", "<yellow>\u25bc Choose from symbols below \u25bc</yellow>"));
        gui.setItem(4, currentItem);
        String[] hearts = new String[]{"\u2764", "\u2665", "\ud83d\udc96", "\ud83d\udc9a", "\ud83d\udda4", "\ud83d\udc99", "\ud83d\udc9c", "\ud83e\udde1", "\ud83d\udc9b", "\ud83e\udd0d", "\u2763", "\ud83d\udc95", "\ud83d\udc97", "\ud83d\udc93", "\ud83d\udc9d", "\ud83d\udc9f", "\u2661", "\ud83d\udc98", "\ud83d\udc8c", "\ud83d\udc8b"};
        String[] names = new String[]{"Classic Red", "Solid Heart", "Sparkling", "Green Heart", "Black Heart", "Blue Heart", "Purple Heart", "Orange Heart", "Yellow Heart", "White Heart", "Heart Exclamation", "Two Hearts", "Growing Heart", "Beating Heart", "Heart with Ribbon", "Heart Decoration", "Outline Heart", "Heart with Arrow", "Love Letter", "Kiss Mark"};
        for (int i = 0; i < hearts.length && i < 20; ++i) {
            String heart = hearts[i];
            String name = names[i];
            boolean isCurrent = heart.equals(currentHeart);
            Material material = isCurrent ? Material.LIME_CONCRETE : Material.RED_CONCRETE;
            String title = isCurrent ? "<lime><bold>\u2713 " + heart + " " + name + " (Active)</bold></lime>" : "<red><bold>" + heart + " " + name + "</bold></red>";
            ItemStack heartItem = this.createItem(material, title, Arrays.asList("<gray>Symbol: " + heart + "</gray>", "<gray>Style: " + name + "</gray>", "<gray>Preview: Entity " + heart + " 15/20 (75%)</gray>", "", isCurrent ? "<lime>\u25b6 Currently active</lime>" : "<yellow>\u25b6 Click to select</yellow>"));
            int row = i / 5;
            int col = i % 5;
            int slot = 19 + row * 9 + col + 2;
            gui.setItem(slot, heartItem);
        }
        gui.setItem(45, this.createItem(Material.ARROW, "<gray>\u2190 Back</gray>", Arrays.asList("<gray>Return to main menu</gray>")));
        gui.setItem(49, this.createItem(Material.CRAFTING_TABLE, "<purple><bold>\ud83d\udee0 Custom Symbol</bold></purple>", Arrays.asList("<gray>Enter custom Unicode symbol</gray>")));
        gui.setItem(53, this.createItem(Material.SPLASH_POTION, "<light_purple><bold>\ud83c\udfb2 Random</bold></light_purple>", Arrays.asList("<gray>Select random heart symbol</gray>")));
        player.openInventory(gui);
    }

    public void openHealthBarStyleGUI(Player player) {
        Component titleComponent = this.plugin.getMiniMessage().deserialize((Object)"<light_purple>\ud83c\udfa8 Advanced Health Bar Styles</light_purple>");
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)titleComponent);
        String currentFull = this.plugin.getConfigManager().getFullCharacter();
        String currentEmpty = this.plugin.getConfigManager().getEmptyCharacter();
        int currentLength = this.plugin.getConfigManager().getBarLength();
        ItemStack currentItem = this.createItem(Material.PAINTING, "<light_purple><bold>Current Health Bar Style</bold></light_purple>", Arrays.asList("<gray>Current Style: <green>" + currentFull + currentEmpty + "</green></gray>", "<gray>Length: <green>" + currentLength + " bars</green></gray>", "<gray>Preview: <yellow>Entity " + currentFull.repeat(7) + currentEmpty.repeat(3) + " 70%</yellow></gray>", "", "<yellow>\u25bc Choose from styles below \u25bc</yellow>"));
        gui.setItem(4, currentItem);
        String[][] styles = new String[][]{{"\u2588", "\u2591", "Solid Blocks"}, {"\u25b0", "\u25b1", "Thick Lines"}, {"\u25a0", "\u25a1", "Squares"}, {"\u25cf", "\u25cb", "Circles"}, {"\u25ac", "\u25ad", "Bars"}, {"\u2501", "\u254c", "Dashes"}, {"\u2593", "\u2592", "Shaded"}, {"\u2666", "\u2662", "Diamonds"}, {"\u25b2", "\u25b3", "Triangles"}, {"\u2b1b", "\u2b1c", "Large Blocks"}, {"\ud83d\udfe9", "\u2b1c", "Green Squares"}, {"\ud83d\udd25", "\ud83d\udca7", "Fire & Water"}, {"\u2b50", "\u2606", "Stars"}, {"\ud83d\udc9a", "\ud83e\udd0d", "Hearts"}, {"\ud83d\udfe2", "\u26aa", "Circles Color"}, {"\u26a1", "\ud83d\udca4", "Energy"}, {"\ud83c\udf1f", "\ud83d\udcab", "Sparkles"}, {"\ud83d\udd34", "\u26ab", "Red Dots"}, {"\ud83d\udc8e", "\ud83d\udca0", "Gems"}, {"\ud83d\udfeb", "\ud83d\udfe4", "Brown Style"}};
        for (int i = 0; i < styles.length && i < 35; ++i) {
            String fullChar = styles[i][0];
            String emptyChar = styles[i][1];
            String styleName = styles[i][2];
            boolean isCurrent = fullChar.equals(currentFull) && emptyChar.equals(currentEmpty);
            Material material = isCurrent ? Material.LIME_CONCRETE : Material.GRAY_CONCRETE;
            String title = isCurrent ? "<lime><bold>\u2713 " + styleName + " (Active)</bold></lime>" : "<white><bold>" + styleName + "</bold></white>";
            ItemStack styleItem = this.createItem(material, title, Arrays.asList("<gray>Style: " + fullChar + emptyChar + "</gray>", "<gray>Full: " + fullChar + " | Empty: " + emptyChar + "</gray>", "<gray>Preview: " + fullChar.repeat(6) + emptyChar.repeat(4) + " 60%</gray>", "", isCurrent ? "<lime>\u25b6 Currently active</lime>" : "<yellow>\u25b6 Click to select</yellow>"));
            int row = i / 7;
            int col = i % 7;
            int slot = 10 + row * 9 + col;
            if (slot >= 45) continue;
            gui.setItem(slot, styleItem);
        }
        gui.setItem(45, this.createItem(Material.STICK, "<aqua><bold>\ud83d\udccf Bar Length</bold></aqua>", Arrays.asList("<gray>Current: " + currentLength + " bars</gray>", "<yellow>\u25b6 Click to configure</yellow>")));
        gui.setItem(46, this.createItem(Material.CRAFTING_TABLE, "<purple><bold>\ud83d\udee0 Custom Style</bold></purple>", Arrays.asList("<gray>Create your own style</gray>", "<yellow>\u25b6 Click to customize</yellow>")));
        gui.setItem(47, this.createItem(Material.BLAZE_POWDER, "<gold><bold>\u2728 Animation Effects</bold></gold>", Arrays.asList("<gray>Add animation to health bars</gray>", "<yellow>\u25b6 Click to configure</yellow>")));
        gui.setItem(48, this.createItem(Material.ARROW, "<gray>\u2190 Back</gray>", Arrays.asList("<gray>Return to main menu</gray>")));
        gui.setItem(53, this.createItem(Material.EMERALD_BLOCK, "<green><bold>\u2713 Apply Style</bold></green>", Arrays.asList("<gray>Save and apply selected style</gray>")));
        player.openInventory(gui);
    }

    public void openBarLengthGUI(Player player) {
        Component titleComponent = this.plugin.getMiniMessage().deserialize((Object)"<aqua>\ud83d\udccf Health Bar Length Configuration</aqua>");
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)titleComponent);
        int currentLength = this.plugin.getConfigManager().getBarLength();
        String fullChar = this.plugin.getConfigManager().getFullCharacter();
        String emptyChar = this.plugin.getConfigManager().getEmptyCharacter();
        ItemStack currentItem = this.createItem(Material.STICK, "<aqua><bold>Current Bar Length</bold></aqua>", Arrays.asList("<gray>Current: <green>" + currentLength + " bars</green></gray>", "<gray>Preview: " + fullChar.repeat(Math.min(currentLength, 10)) + (currentLength > 10 ? "..." : "") + "</gray>", "", "<yellow>\u25bc Choose length below \u25bc</yellow>"));
        gui.setItem(4, currentItem);
        int[] lengths = new int[]{5, 8, 10, 12, 15, 18, 20, 25, 30, 35, 40, 50};
        for (int i = 0; i < lengths.length; ++i) {
            String preview;
            String title;
            int length = lengths[i];
            boolean isCurrent = length == currentLength;
            Material material = isCurrent ? Material.LIME_DYE : Material.GRAY_DYE;
            String string = title = isCurrent ? "<lime><bold>\u2713 " + length + " Bars (Current)</bold></lime>" : "<white>" + length + " Bars</white>";
            if (length <= 15) {
                int filled = (int)((double)length * 0.7);
                preview = fullChar.repeat(filled) + emptyChar.repeat(length - filled);
            } else {
                preview = fullChar.repeat(8) + emptyChar.repeat(4) + "... (" + length + " total)";
            }
            ItemStack lengthItem = this.createItem(material, title, Arrays.asList("<gray>Length: " + length + " characters</gray>", "<gray>Preview: " + preview + "</gray>", "<gray>Recommended for: " + this.getLengthRecommendation(length) + "</gray>", "", isCurrent ? "<lime>\u25b6 Currently active</lime>" : "<yellow>\u25b6 Click to select</yellow>"));
            int slot = 19 + i % 6 + i / 6 * 9;
            if (slot >= 54) continue;
            gui.setItem(slot, lengthItem);
        }
        gui.setItem(45, this.createItem(Material.ARROW, "<gray>\u2190 Back</gray>", Arrays.asList("<gray>Return to style menu</gray>")));
        player.openInventory(gui);
    }

    public void openColorSettingsGUI(Player player) {
        Component titleComponent = this.plugin.getMiniMessage().deserialize((Object)"<blue>\ud83c\udfa8 Health Bar Color Settings</blue>");
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)titleComponent);
        ItemStack currentItem = this.createItem(Material.PRISMARINE_CRYSTALS, "<blue><bold>Current Color Settings</bold></blue>", Arrays.asList("<gray>Healthy (\u2265" + this.plugin.getConfigManager().getMediumThreshold() + "%): <color:" + this.plugin.getConfigManager().getHealthyColor() + ">\u25a0\u25a0\u25a0\u25a0\u25a0</color></gray>", "<gray>Medium (\u2265" + this.plugin.getConfigManager().getLowThreshold() + "%): <color:" + this.plugin.getConfigManager().getMediumColor() + ">\u25a0\u25a0\u25a0\u25a0\u25a0</color></gray>", "<gray>Low (<" + this.plugin.getConfigManager().getLowThreshold() + "%): <color:" + this.plugin.getConfigManager().getLowColor() + ">\u25a0\u25a0\u25a0\u25a0\u25a0</color></gray>", "", "<yellow>\u25bc Configure colors below \u25bc</yellow>"));
        gui.setItem(4, currentItem);
        String[] healthyColors = new String[]{"#00FF00", "#32CD32", "#90EE90", "#98FB98", "#00FA9A", "#00FF7F", "#7CFC00"};
        String[] healthyNames = new String[]{"Bright Green", "Lime Green", "Light Green", "Pale Green", "Medium Spring", "Spring Green", "Lawn Green"};
        for (int i = 0; i < healthyColors.length; ++i) {
            boolean isCurrent = healthyColors[i].equals(this.plugin.getConfigManager().getHealthyColor());
            ItemStack colorItem = this.createItem(isCurrent ? Material.LIME_CONCRETE : Material.GREEN_CONCRETE, "<color:" + healthyColors[i] + "><bold>" + healthyNames[i] + "</bold></color>", Arrays.asList("<gray>Color: " + healthyColors[i] + "</gray>", "<gray>Preview: <color:" + healthyColors[i] + ">\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588</color></gray>", "<gray>For: Healthy entities</gray>", "", isCurrent ? "<lime>\u25b6 Currently active</lime>" : "<yellow>\u25b6 Click to select</yellow>"));
            gui.setItem(19 + i, colorItem);
        }
        String[] mediumColors = new String[]{"#FFFF00", "#FFD700", "#FFA500", "#FF8C00", "#FFDAB9", "#F0E68C", "#BDB76B"};
        String[] mediumNames = new String[]{"Yellow", "Gold", "Orange", "Dark Orange", "Peach", "Khaki", "Dark Khaki"};
        for (int i = 0; i < mediumColors.length; ++i) {
            boolean isCurrent = mediumColors[i].equals(this.plugin.getConfigManager().getMediumColor());
            ItemStack colorItem = this.createItem(isCurrent ? Material.YELLOW_CONCRETE : Material.ORANGE_CONCRETE, "<color:" + mediumColors[i] + "><bold>" + mediumNames[i] + "</bold></color>", Arrays.asList("<gray>Color: " + mediumColors[i] + "</gray>", "<gray>Preview: <color:" + mediumColors[i] + ">\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588</color></gray>", "<gray>For: Medium health entities</gray>", "", isCurrent ? "<yellow>\u25b6 Currently active</yellow>" : "<yellow>\u25b6 Click to select</yellow>"));
            gui.setItem(28 + i, colorItem);
        }
        String[] lowColors = new String[]{"#FF0000", "#DC143C", "#B22222", "#8B0000", "#CD5C5C", "#F08080", "#FA8072"};
        String[] lowNames = new String[]{"Red", "Crimson", "Fire Brick", "Dark Red", "Indian Red", "Light Coral", "Salmon"};
        for (int i = 0; i < lowColors.length; ++i) {
            boolean isCurrent = lowColors[i].equals(this.plugin.getConfigManager().getLowColor());
            ItemStack colorItem = this.createItem(isCurrent ? Material.RED_CONCRETE : Material.TERRACOTTA, "<color:" + lowColors[i] + "><bold>" + lowNames[i] + "</bold></color>", Arrays.asList("<gray>Color: " + lowColors[i] + "</gray>", "<gray>Preview: <color:" + lowColors[i] + ">\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588</color></gray>", "<gray>For: Low health entities</gray>", "", isCurrent ? "<red>\u25b6 Currently active</red>" : "<yellow>\u25b6 Click to select</yellow>"));
            gui.setItem(37 + i, colorItem);
        }
        gui.setItem(46, this.createItem(Material.COMPARATOR, "<purple><bold>\u2696 Health Thresholds</bold></purple>", Arrays.asList("<gray>Medium threshold: " + this.plugin.getConfigManager().getMediumThreshold() + "%</gray>", "<gray>Low threshold: " + this.plugin.getConfigManager().getLowThreshold() + "%</gray>", "<yellow>\u25b6 Click to configure</yellow>")));
        gui.setItem(45, this.createItem(Material.ARROW, "<gray>\u2190 Back</gray>", Arrays.asList("<gray>Return to main menu</gray>")));
        gui.setItem(53, this.createItem(Material.EMERALD_BLOCK, "<green><bold>\u2713 Apply Colors</bold></green>", Arrays.asList("<gray>Save and apply color settings</gray>")));
        player.openInventory(gui);
    }

    private String getLengthRecommendation(int length) {
        if (length <= 8) {
            return "Small screens, minimal display";
        }
        if (length <= 15) {
            return "Standard display, most users";
        }
        if (length <= 25) {
            return "Detailed display, large screens";
        }
        return "Maximum detail, high-res displays";
    }

    public void openDisplayOptionsGUI(Player player) {
        Component titleComponent = this.plugin.getMiniMessage().deserialize((Object)"<green>\ud83d\udc41 Advanced Display Options</green>");
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)titleComponent);
        ItemStack overviewItem = this.createItem(Material.ENDER_EYE, "<green><bold>\ud83d\udcca Display Overview</bold></green>", Arrays.asList("<gray>Enabled Features: <green>" + this.plugin.getConfigManager().getEnabledFeaturesCount() + "/13</green></gray>", "<gray>Active Format: <yellow>" + this.plugin.getConfigManager().getActiveFormat() + "</yellow></gray>", "<gray>Location: <aqua>" + this.plugin.getConfigManager().getDisplayLocation() + "</aqua></gray>", "", "<yellow>\u25bc Configure options below \u25bc</yellow>"));
        gui.setItem(4, overviewItem);
        ItemStack nameItem = this.createItem(this.plugin.getConfigManager().isShowEntityName() ? Material.NAME_TAG : Material.GRAY_DYE, this.plugin.getConfigManager().isShowEntityName() ? "<green><bold>\u2713 Entity Names</bold></green>" : "<gray><bold>\u2717 Entity Names</bold></gray>", Arrays.asList("<gray>Display entity names in health bar</gray>", "<gray>Example: <white>Zombie \u2764 20/20</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowEntityName() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(10, nameItem);
        ItemStack percentageItem = this.createItem(this.plugin.getConfigManager().isShowPercentage() ? Material.LIME_DYE : Material.GRAY_DYE, this.plugin.getConfigManager().isShowPercentage() ? "<green><bold>\u2713 Health Percentage</bold></green>" : "<gray><bold>\u2717 Health Percentage</bold></gray>", Arrays.asList("<gray>Show health as percentage</gray>", "<gray>Example: <white>Zombie \u2764 (75%)</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowPercentage() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(11, percentageItem);
        ItemStack valuesItem = this.createItem(this.plugin.getConfigManager().isShowHealthValues() ? Material.RED_DYE : Material.GRAY_DYE, this.plugin.getConfigManager().isShowHealthValues() ? "<green><bold>\u2713 Health Values</bold></green>" : "<gray><bold>\u2717 Health Values</bold></gray>", Arrays.asList("<gray>Show current/max health numbers</gray>", "<gray>Example: <white>Zombie \u2764 15/20</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowHealthValues() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(12, valuesItem);
        ItemStack barItem = this.createItem(this.plugin.getConfigManager().isShowHealthBar() ? Material.STICK : Material.GRAY_DYE, this.plugin.getConfigManager().isShowHealthBar() ? "<green><bold>\u2713 Health Bar</bold></green>" : "<gray><bold>\u2717 Health Bar</bold></gray>", Arrays.asList("<gray>Show visual health bar</gray>", "<gray>Example: <white>Zombie [\u2588\u2588\u2588\u2588\u2591\u2591\u2591\u2591\u2591\u2591]</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowHealthBar() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(13, barItem);
        ItemStack heartItem = this.createItem(this.plugin.getConfigManager().isShowHeartSymbol() ? Material.RED_DYE : Material.GRAY_DYE, this.plugin.getConfigManager().isShowHeartSymbol() ? "<green><bold>\u2713 Heart Symbol</bold></green>" : "<gray><bold>\u2717 Heart Symbol</bold></gray>", Arrays.asList("<gray>Show heart symbol in display</gray>", "<gray>Current: " + this.plugin.getConfigManager().getHeartSymbol() + "</gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowHeartSymbol() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(14, heartItem);
        ItemStack typeItem = this.createItem(this.plugin.getConfigManager().isShowEntityType() ? Material.SPAWNER : Material.GRAY_DYE, this.plugin.getConfigManager().isShowEntityType() ? "<green><bold>\u2713 Entity Type</bold></green>" : "<gray><bold>\u2717 Entity Type</bold></gray>", Arrays.asList("<gray>Show entity type (Zombie, Skeleton, etc.)</gray>", "<gray>Example: <white>Zombie [Hostile] \u2764 20/20</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowEntityType() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(19, typeItem);
        ItemStack distanceItem = this.createItem(this.plugin.getConfigManager().isShowDistance() ? Material.COMPASS : Material.GRAY_DYE, this.plugin.getConfigManager().isShowDistance() ? "<green><bold>\u2713 Distance</bold></green>" : "<gray><bold>\u2717 Distance</bold></gray>", Arrays.asList("<gray>Show distance to entity</gray>", "<gray>Example: <white>Zombie \u2764 20/20 [5m]</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowDistance() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(20, distanceItem);
        ItemStack hostilityItem = this.createItem(this.plugin.getConfigManager().isShowHostilityIndicator() ? Material.IRON_SWORD : Material.GRAY_DYE, this.plugin.getConfigManager().isShowHostilityIndicator() ? "<green><bold>\u2713 Hostility Indicator</bold></green>" : "<gray><bold>\u2717 Hostility Indicator</bold></gray>", Arrays.asList("<gray>Show \u2694 for hostile, \u262e for passive</gray>", "<gray>Example: <white>\u2694 Zombie \u2764 20/20</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowHostilityIndicator() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(21, hostilityItem);
        ItemStack tamedItem = this.createItem(this.plugin.getConfigManager().isShowTamedStatus() ? Material.BONE : Material.GRAY_DYE, this.plugin.getConfigManager().isShowTamedStatus() ? "<green><bold>\u2713 Tamed Status</bold></green>" : "<gray><bold>\u2717 Tamed Status</bold></gray>", Arrays.asList("<gray>Show \ud83c\udfe0 indicator for tamed animals</gray>", "<gray>Example: <white>\ud83c\udfe0 Wolf \u2764 20/20</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowTamedStatus() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(22, tamedItem);
        ItemStack ageItem = this.createItem(this.plugin.getConfigManager().isShowAgeStatus() ? Material.EGG : Material.GRAY_DYE, this.plugin.getConfigManager().isShowAgeStatus() ? "<green><bold>\u2713 Age Status</bold></green>" : "<gray><bold>\u2717 Age Status</bold></gray>", Arrays.asList("<gray>Show \ud83c\udf7c indicator for baby animals</gray>", "<gray>Example: <white>\ud83c\udf7c Baby Cow \u2764 10/10</white></gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowAgeStatus() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(23, ageItem);
        ItemStack playersItem = this.createItem(this.plugin.getConfigManager().isShowPlayerHealth() ? Material.PLAYER_HEAD : Material.GRAY_DYE, this.plugin.getConfigManager().isShowPlayerHealth() ? "<green><bold>\u2713 Players</bold></green>" : "<gray><bold>\u2717 Players</bold></gray>", Arrays.asList("<gray>Show health for other players</gray>", "<gray>Display health bars above players</gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowPlayerHealth() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(28, playersItem);
        ItemStack hostileItem = this.createItem(this.plugin.getConfigManager().isShowHostileMobs() ? Material.ZOMBIE_HEAD : Material.GRAY_DYE, this.plugin.getConfigManager().isShowHostileMobs() ? "<green><bold>\u2713 Hostile Mobs</bold></green>" : "<gray><bold>\u2717 Hostile Mobs</bold></gray>", Arrays.asList("<gray>Show health for hostile creatures</gray>", "<gray>Zombies, Skeletons, Creepers, etc.</gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowHostileMobs() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(29, hostileItem);
        ItemStack passiveItem = this.createItem(this.plugin.getConfigManager().isShowPassiveMobs() ? Material.COW_SPAWN_EGG : Material.GRAY_DYE, this.plugin.getConfigManager().isShowPassiveMobs() ? "<green><bold>\u2713 Passive Mobs</bold></green>" : "<gray><bold>\u2717 Passive Mobs</bold></gray>", Arrays.asList("<gray>Show health for passive animals</gray>", "<gray>Cows, Pigs, Sheep, Chickens, etc.</gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowPassiveMobs() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(30, passiveItem);
        ItemStack bossItem = this.createItem(this.plugin.getConfigManager().isShowBossHealth() ? Material.WITHER_SKELETON_SKULL : Material.GRAY_DYE, this.plugin.getConfigManager().isShowBossHealth() ? "<green><bold>\u2713 Boss Entities</bold></green>" : "<gray><bold>\u2717 Boss Entities</bold></gray>", Arrays.asList("<gray>Show health for boss creatures</gray>", "<gray>Ender Dragon, Wither, etc.</gray>", "<gray>Status: " + (this.plugin.getConfigManager().isShowBossHealth() ? "<green>Enabled</green>" : "<red>Disabled</red>") + "</gray>", "", "<yellow>\u25b6 Click to toggle</yellow>"));
        gui.setItem(31, bossItem);
        String[] formats = new String[]{"standard", "compact", "detailed", "minimal", "custom"};
        String[] formatNames = new String[]{"Standard", "Compact", "Detailed", "Minimal", "Custom"};
        String[] formatDescriptions = new String[]{"Full information display", "Essential info only", "All available information", "Just health percentage", "User customizable"};
        for (int i = 0; i < formats.length; ++i) {
            String format = formats[i];
            String name = formatNames[i];
            String description = formatDescriptions[i];
            boolean isActive = format.equals(this.plugin.getConfigManager().getActiveFormat());
            Material material = isActive ? Material.LIME_CONCRETE : Material.GRAY_CONCRETE;
            String title = isActive ? "<lime><bold>\u2713 " + name + " (Active)</bold></lime>" : "<white><bold>" + name + "</bold></white>";
            ItemStack formatItem = this.createItem(material, title, Arrays.asList("<gray>Format: " + description + "</gray>", "<gray>Template: <yellow>" + this.getFormatPreview(format) + "</yellow></gray>", "", isActive ? "<lime>\u25b6 Currently active</lime>" : "<yellow>\u25b6 Click to select</yellow>"));
            gui.setItem(37 + i, formatItem);
        }
        gui.setItem(45, this.createItem(Material.ARROW, "<gray>\u2190 Back to Main Menu</gray>", Arrays.asList("<gray>Return to main settings</gray>")));
        gui.setItem(49, this.createItem(Material.EMERALD, "<green><bold>\u2713 Save Changes</bold></green>", Arrays.asList("<gray>Save all display settings</gray>")));
        gui.setItem(53, this.createItem(Material.BARRIER, "<red><bold>\u21ba Reset to Defaults</bold></red>", Arrays.asList("<gray>Reset all display options to defaults</gray>", "<red>\u26a0 This will reset all settings</red>", "", "<red>\u25b6 Click to reset</red>")));
        player.openInventory(gui);
    }

    private String getFormatPreview(String format) {
        switch (format.toLowerCase()) {
            case "standard": {
                return "\u2694 Zombie \u2764 15/20 (75%) [\u2588\u2588\u2588\u2588\u2588\u2588\u2591\u2591\u2591\u2591]";
            }
            case "compact": {
                return "Zombie \u2764 (75%) [\u2588\u2588\u2588\u2588\u2588\u2588\u2591\u2591\u2591\u2591]";
            }
            case "detailed": {
                return "\u2694 Zombie [Hostile] \u2764 15/20 (75%) [\u2588\u2588\u2588\u2588\u2588\u2588\u2591\u2591\u2591\u2591] [5m]";
            }
            case "minimal": {
                return "\u2764 (75%)";
            }
            case "custom": {
                return "{custom format}";
            }
        }
        return "Unknown format";
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Component titleComponent = event.getView().title();
        String title = this.plugin.getMiniMessage().stripTags((String)this.plugin.getMiniMessage().serialize(titleComponent));
        if (this.isHealthGUITitle(title)) {
            event.setCancelled(true);
            String guiType = this.detectGUIType(title);
            this.handleGUIClick(player, guiType, event.getSlot());
        }
    }

    private boolean isHealthGUITitle(String title) {
        return title.contains("HealthGUI") || title.contains("Detection Range") || title.contains("Heart Symbols") || title.contains("Health Bar Styles") || title.contains("Health Bar Length") || title.contains("Color Settings") || title.contains("Display Options") || title.contains("Advanced Display Options") || title.contains("\u0627\u0644\u0635\u062d\u0629") || title.contains("Configuraci\u00f3n") || title.contains("Param\u00e8tres") || title.contains("\u062e\u064a\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0636");
    }

    private String detectGUIType(String title) {
        if (title.contains("Main Settings") || title.contains("\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629")) {
            return "main";
        }
        if (title.contains("Detection Range") || title.contains("\u0645\u062f\u0649 \u0627\u0644\u0627\u0643\u062a\u0634\u0627\u0641")) {
            return "range";
        }
        if (title.contains("Heart Symbols") || title.contains("\u0631\u0645\u0648\u0632 \u0627\u0644\u0642\u0644\u0628")) {
            return "heart";
        }
        if (title.contains("Health Bar Styles")) {
            return "style";
        }
        if (title.contains("Health Bar Length")) {
            return "length";
        }
        if (title.contains("Color Settings")) {
            return "color";
        }
        if (title.contains("Display Options") || title.contains("\u062e\u064a\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0636")) {
            return "display";
        }
        return "main";
    }

    private void handleGUIClick(Player player, String guiType, int slot) {
        switch (guiType) {
            case "main": {
                this.handleMainMenuClick(player, slot);
                break;
            }
            case "range": {
                this.handleRangeMenuClick(player, slot);
                break;
            }
            case "heart": {
                this.handleHeartMenuClick(player, slot);
                break;
            }
            case "style": {
                this.handleStyleMenuClick(player, slot);
                break;
            }
            case "length": {
                this.handleLengthMenuClick(player, slot);
                break;
            }
            case "color": {
                this.handleColorMenuClick(player, slot);
                break;
            }
            case "display": {
                this.handleDisplayMenuClick(player, slot);
            }
        }
    }

    private void handleMainMenuClick(Player player, int slot) {
        switch (slot) {
            case 19: {
                this.openRangeSettingsGUI(player);
                break;
            }
            case 21: {
                this.openHealthBarStyleGUI(player);
                break;
            }
            case 23: {
                this.openHeartSymbolsGUI(player);
                break;
            }
            case 25: {
                this.openColorSettingsGUI(player);
                break;
            }
            case 28: {
                this.toggle3DHealthDisplay(player);
                break;
            }
            case 29: {
                this.toggleActionBarDisplay(player);
                break;
            }
            case 30: {
                this.openDisplayOptionsGUI(player);
                break;
            }
            case 32: {
                this.togglePerformanceSettings(player);
                break;
            }
            case 34: {
                this.showSystemInfo(player);
                break;
            }
            case 47: {
                this.applyPendingChanges(player);
                break;
            }
            case 49: {
                this.saveSettings(player);
                break;
            }
            case 51: {
                this.clearPendingChanges(player);
            }
        }
    }

    private void handleStyleMenuClick(Player player, int slot) {
        if (slot == 48) {
            this.openMainGUI(player);
            return;
        }
        if (slot == 45) {
            this.openBarLengthGUI(player);
            return;
        }
        if (slot == 53) {
            this.saveSettings(player);
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<green>\u2713 Health bar style applied!</green>"));
            return;
        }
        if (slot >= 10 && slot <= 44) {
            String[][] styles = new String[][]{{"\u2588", "\u2591", "Solid Blocks"}, {"\u25b0", "\u25b1", "Thick Lines"}, {"\u25a0", "\u25a1", "Squares"}, {"\u25cf", "\u25cb", "Circles"}, {"\u25ac", "\u25ad", "Bars"}, {"\u2501", "\u254c", "Dashes"}, {"\u2593", "\u2592", "Shaded"}, {"\u2666", "\u2662", "Diamonds"}, {"\u25b2", "\u25b3", "Triangles"}, {"\u2b1b", "\u2b1c", "Large Blocks"}, {"\ud83d\udfe9", "\u2b1c", "Green Squares"}, {"\ud83d\udd25", "\ud83d\udca7", "Fire & Water"}, {"\u2b50", "\u2606", "Stars"}, {"\ud83d\udc9a", "\ud83e\udd0d", "Hearts"}, {"\ud83d\udfe2", "\u26aa", "Circles Color"}, {"\u26a1", "\ud83d\udca4", "Energy"}, {"\ud83c\udf1f", "\ud83d\udcab", "Sparkles"}, {"\ud83d\udd34", "\u26ab", "Red Dots"}, {"\ud83d\udc8e", "\ud83d\udca0", "Gems"}, {"\ud83d\udfeb", "\ud83d\udfe4", "Brown Style"}};
            int index = this.calculateStyleIndex(slot);
            if (index >= 0 && index < styles.length) {
                String fullChar = styles[index][0];
                String emptyChar = styles[index][1];
                String styleName = styles[index][2];
                this.plugin.getConfigManager().setFullCharacter(fullChar);
                this.plugin.getConfigManager().setEmptyCharacter(emptyChar);
                player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Health bar style changed to: " + styleName + " (" + fullChar + emptyChar + ")</green>")));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
                this.openHealthBarStyleGUI(player);
            }
        }
    }

    private void handleRangeMenuClick(Player player, int slot) {
        if (slot == 45) {
            this.openMainGUI(player);
            return;
        }
        if (slot >= 19 && slot <= 45) {
            int[] ranges = new int[]{5, 8, 10, 12, 15, 18, 20, 25, 30, 40, 50, 75, 100};
            int index = this.calculateRangeIndex(slot);
            if (index >= 0 && index < ranges.length) {
                int selectedRange = ranges[index];
                this.applyRangeChange(player, selectedRange);
            }
        }
    }

    private void handleHeartMenuClick(Player player, int slot) {
        if (slot == 45) {
            this.openMainGUI(player);
            return;
        }
        if (slot >= 19 && slot <= 51) {
            String[] hearts = new String[]{"\u2764", "\u2665", "\ud83d\udc96", "\ud83d\udc9a", "\ud83d\udda4", "\ud83d\udc99", "\ud83d\udc9c", "\ud83e\udde1", "\ud83d\udc9b", "\ud83e\udd0d", "\u2763", "\ud83d\udc95", "\ud83d\udc97", "\ud83d\udc93", "\ud83d\udc9d", "\ud83d\udc9f", "\u2661", "\ud83d\udc98", "\ud83d\udc8c", "\ud83d\udc8b"};
            int index = this.calculateHeartIndex(slot);
            if (index >= 0 && index < hearts.length) {
                String selectedHeart = hearts[index];
                this.applyHeartChange(player, selectedHeart);
            }
        }
    }

    private void handleLengthMenuClick(Player player, int slot) {
        if (slot == 45) {
            this.openHealthBarStyleGUI(player);
            return;
        }
        if (slot >= 19 && slot <= 45) {
            int[] lengths = new int[]{5, 8, 10, 12, 15, 18, 20, 25, 30, 35, 40, 50};
            int index = this.calculateLengthIndex(slot);
            if (index >= 0 && index < lengths.length) {
                int selectedLength = lengths[index];
                this.plugin.getConfigManager().setBarLength(selectedLength);
                player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Health bar length set to " + selectedLength + " bars</green>")));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
                this.openBarLengthGUI(player);
            }
        }
    }

    private void handleColorMenuClick(Player player, int slot) {
        int index;
        if (slot == 45) {
            this.openMainGUI(player);
            return;
        }
        if (slot == 53) {
            this.saveSettings(player);
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<green>\u2713 Color settings applied!</green>"));
            return;
        }
        if (slot >= 19 && slot <= 25) {
            String[] healthyColors = new String[]{"#00FF00", "#32CD32", "#90EE90", "#98FB98", "#00FA9A", "#00FF7F", "#7CFC00"};
            String[] healthyNames = new String[]{"Bright Green", "Lime Green", "Light Green", "Pale Green", "Medium Spring", "Spring Green", "Lawn Green"};
            index = slot - 19;
            if (index >= 0 && index < healthyColors.length) {
                this.plugin.getConfigManager().setHealthyColor(healthyColors[index]);
                player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Healthy color changed to: " + healthyNames[index] + "</green>")));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
                this.openColorSettingsGUI(player);
            }
        }
        if (slot >= 28 && slot <= 34) {
            String[] mediumColors = new String[]{"#FFFF00", "#FFD700", "#FFA500", "#FF8C00", "#FFDAB9", "#F0E68C", "#BDB76B"};
            String[] mediumNames = new String[]{"Yellow", "Gold", "Orange", "Dark Orange", "Peach", "Khaki", "Dark Khaki"};
            index = slot - 28;
            if (index >= 0 && index < mediumColors.length) {
                this.plugin.getConfigManager().setMediumColor(mediumColors[index]);
                player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<yellow>\u2713 Medium color changed to: " + mediumNames[index] + "</yellow>")));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
                this.openColorSettingsGUI(player);
            }
        }
        if (slot >= 37 && slot <= 43) {
            String[] lowColors = new String[]{"#FF0000", "#DC143C", "#B22222", "#8B0000", "#CD5C5C", "#F08080", "#FA8072"};
            String[] lowNames = new String[]{"Red", "Crimson", "Fire Brick", "Dark Red", "Indian Red", "Light Coral", "Salmon"};
            index = slot - 37;
            if (index >= 0 && index < lowColors.length) {
                this.plugin.getConfigManager().setLowColor(lowColors[index]);
                player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<red>\u2713 Low color changed to: " + lowNames[index] + "</red>")));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
                this.openColorSettingsGUI(player);
            }
        }
    }

    private void handleDisplayMenuClick(Player player, int slot) {
        if (slot == 45) {
            this.openMainGUI(player);
            return;
        }
        if (slot >= 10 && slot <= 23) {
            boolean newValue = !this.plugin.getConfigManager().isOptionEnabled(slot);
            this.plugin.getConfigManager().setOptionEnabled(slot, newValue);
            String optionName = this.getDisplayOptionName(slot);
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 " + optionName + " " + (newValue ? "enabled" : "disabled") + "</green>")));
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
            this.openDisplayOptionsGUI(player);
        }
        if (slot >= 37 && slot <= 43) {
            String[] formats = new String[]{"standard", "compact", "detailed", "minimal", "custom"};
            int index = slot - 37;
            if (index >= 0 && index < formats.length) {
                String selectedFormat = formats[index];
                this.plugin.getConfigManager().setActiveFormat(selectedFormat);
                player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Display format changed to: " + selectedFormat + "</green>")));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
                this.openDisplayOptionsGUI(player);
            }
        }
    }

    private String getDisplayOptionName(int slot) {
        switch (slot) {
            case 10: {
                return "Entity Names";
            }
            case 11: {
                return "Health Percentage";
            }
            case 12: {
                return "Health Values";
            }
            case 13: {
                return "Health Bar";
            }
            case 14: {
                return "Heart Symbol";
            }
            case 19: {
                return "Entity Type";
            }
            case 20: {
                return "Distance";
            }
            case 21: {
                return "Hostility Indicator";
            }
            case 22: {
                return "Tamed Status";
            }
            case 23: {
                return "Age Status";
            }
        }
        return "Unknown Option";
    }

    private int calculateStyleIndex(int slot) {
        int row = (slot - 10) / 9;
        int col = (slot - 10) % 9;
        if (col >= 7) {
            return -1;
        }
        return row * 7 + col;
    }

    private int calculateLengthIndex(int slot) {
        int row = (slot - 19) / 9;
        int col = (slot - 19) % 9;
        if (col >= 6) {
            return -1;
        }
        return row * 6 + col;
    }

    private int calculateRangeIndex(int slot) {
        int row = (slot - 19) / 9;
        int col = (slot - 19) % 9;
        if (col >= 7) {
            return -1;
        }
        return row * 7 + col;
    }

    private int calculateHeartIndex(int slot) {
        if (slot >= 21 && slot <= 25) {
            return slot - 21;
        }
        if (slot >= 30 && slot <= 34) {
            return 5 + (slot - 30);
        }
        if (slot >= 39 && slot <= 43) {
            return 10 + (slot - 39);
        }
        if (slot >= 48 && slot <= 52) {
            return 15 + (slot - 48);
        }
        return -1;
    }

    private void applyRangeChange(Player player, int range) {
        this.plugin.getConfigManager().setDetectionRange(range);
        this.plugin.getConfigManager().saveConfig();
        this.plugin.getHealthBarManager().restart();
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Detection range set to " + range + " blocks</green>")));
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
        this.openRangeSettingsGUI(player);
    }

    private void applyHeartChange(Player player, String heart) {
        String currentHeart = this.plugin.getConfigManager().getHeartSymbol();
        if (heart.equals(currentHeart)) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<yellow>This heart is already active!</yellow>"));
            return;
        }
        this.plugin.getConfigManager().setHeartSymbol(heart);
        this.plugin.getConfigManager().saveConfig();
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Heart symbol changed to " + heart + "</green>")));
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.4f);
        this.openHeartSymbolsGUI(player);
    }

    private void togglePerformanceSettings(Player player) {
        boolean optimized = this.plugin.getConfigManager().isOptimizedMode();
        this.plugin.getConfigManager().setOptimizedMode(!optimized);
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>Optimized mode " + (optimized ? "disabled" : "enabled") + "</green>")));
        this.openMainGUI(player);
    }

    private void showSystemInfo(Player player) {
        Map<String, Object> status = this.plugin.getHealthBarManager().getSystemStatus();
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<blue><bold>\ud83d\udcca System Information</bold></blue>"));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>Status: " + (status.get("running").equals(true) ? "<green>Running</green>" : "<red>Stopped</red>") + "</gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>Active Players: <green>" + String.valueOf(status.get("activePlayers")) + "</green></gray>")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<gray>Detection Range: <yellow>" + String.valueOf(status.get("detectionRange")) + " blocks</yellow></gray>")));
    }

    private void saveSettings(Player player) {
        this.plugin.getConfigManager().saveConfig();
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<green>\u2713 Settings saved successfully!</green>"));
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.2f);
    }

    private void applyPendingChanges(Player player) {
        boolean applied = this.plugin.getSelectionManager().applyPendingSelections(player.getUniqueId());
        if (applied) {
            this.openMainGUI(player);
        }
    }

    private void clearPendingChanges(Player player) {
        int changesCount = this.plugin.getSelectionManager().getPendingChangesCount(player.getUniqueId());
        this.plugin.getSelectionManager().clearPlayerSelections(player.getUniqueId());
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<yellow>\ud83d\uddd1 Cleared " + changesCount + " pending changes</yellow>")));
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 0.8f);
        this.openMainGUI(player);
    }

    private ItemStack createItem(Material material, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(this.plugin.getMiniMessage().deserialize((Object)displayName));
            if (lore != null && !lore.isEmpty()) {
                ArrayList<Object> loreComponents = new ArrayList<Object>();
                for (String line : lore) {
                    if (!line.isEmpty()) {
                        loreComponents.add(this.plugin.getMiniMessage().deserialize((Object)line));
                        continue;
                    }
                    loreComponents.add(Component.empty());
                }
                meta.lore(loreComponents);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void toggle3DHealthDisplay(Player player) {
        boolean currentSetting = this.plugin.getConfigManager().isShow3DHealthDisplay();
        this.plugin.getConfigManager().setShow3DHealthDisplay(!currentSetting);
        boolean newSetting = !currentSetting;
        String statusMsg = newSetting ? this.plugin.getLanguageManager().getMessage(player, "gui.enabled", new Object[0]) : this.plugin.getLanguageManager().getMessage(player, "gui.disabled", new Object[0]);
        String message = "<gold>\ud83c\udfaf 3D Health Display: " + (newSetting ? "<green>\u2713 " + statusMsg + "</green>" : "<red>\u2717 " + statusMsg + "</red>") + "</gold>";
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)message));
        if (newSetting) {
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.2f);
        } else {
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 0.8f);
        }
        this.openMainGUI(player);
    }

    private void toggleActionBarDisplay(Player player) {
        boolean currentSetting = this.plugin.getConfigManager().isShowActionBarDisplay();
        boolean newSetting = !currentSetting;
        this.plugin.getConfigManager().setShowActionBarDisplay(newSetting);
        String statusMsg = newSetting ? this.plugin.getLanguageManager().getMessage(player, "gui.enabled", new Object[0]) : this.plugin.getLanguageManager().getMessage(player, "gui.disabled", new Object[0]);
        String message = "<blue>\ud83d\udcf1 Action Bar Display: " + (newSetting ? "<green>\u2713 " + statusMsg + "</green>" : "<red>\u2717 " + statusMsg + "</red>") + "</blue>";
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)message));
        if (newSetting) {
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.2f);
        } else {
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 0.8f);
        }
        this.openMainGUI(player);
    }
}

