/*
 * Decompiled with CFR 0.152.
 */
package haider.plugin.healthGUI.health;

import haider.plugin.healthGUI.HealthGUI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.RayTraceResult;

public class HealthBarManager
implements Listener {
    private final HealthGUI plugin;
    private BukkitTask healthBarTask;
    private final Map<UUID, LivingEntity> lastTargets;
    private final Map<UUID, LivingEntity> confirmedTargets;
    private final Map<UUID, Long> lastUpdateTime;
    private final Map<UUID, Boolean> playerActiveStatus;

    public HealthBarManager(HealthGUI plugin) {
        this.plugin = plugin;
        this.lastTargets = new ConcurrentHashMap<UUID, LivingEntity>();
        this.confirmedTargets = new ConcurrentHashMap<UUID, LivingEntity>();
        this.lastUpdateTime = new ConcurrentHashMap<UUID, Long>();
        this.playerActiveStatus = new ConcurrentHashMap<UUID, Boolean>();
    }

    public void startHealthBarTask() {
        if (this.healthBarTask != null && !this.healthBarTask.isCancelled()) {
            this.healthBarTask.cancel();
        }
        this.healthBarTask = new HealthBarTask().runTaskTimer((Plugin)this.plugin, 0L, this.plugin.getConfigManager().getUpdateInterval());
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (this.plugin.getConfigManager().isShow3DHealthDisplay()) {
                this.plugin.getDisplay3DManager().cleanupInvalidDisplays();
            }
        }, 200L, 200L);
        this.plugin.getLogger().info("\u2713 Health bar task started with " + this.plugin.getConfigManager().getUpdateInterval() + " tick interval");
    }

    public void shutdown() {
        if (this.healthBarTask != null && !this.healthBarTask.isCancelled()) {
            this.healthBarTask.cancel();
            this.healthBarTask = null;
        }
        this.clearAllPlayerData();
        this.plugin.getLogger().info("\u2717 Health bar system shutdown complete");
    }

    private void clearAllPlayerData() {
        this.lastTargets.clear();
        this.confirmedTargets.clear();
        this.lastUpdateTime.clear();
        this.playerActiveStatus.clear();
    }

    private void clearPlayerData(UUID playerId) {
        this.lastTargets.remove(playerId);
        this.confirmedTargets.remove(playerId);
        this.lastUpdateTime.remove(playerId);
        this.playerActiveStatus.remove(playerId);
    }

    private void processPlayer(Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.isPlayerActive(player)) {
            return;
        }
        LivingEntity target = this.getTargetEntity(player);
        LivingEntity lastTarget = this.lastTargets.get(playerId);
        LivingEntity confirmedTarget = this.confirmedTargets.get(playerId);
        if (target != null && target != player && !target.isDead()) {
            if (lastTarget != target) {
                this.sendTargetIndicator(player, target);
                this.confirmedTargets.put(playerId, target);
                this.lastUpdateTime.put(playerId, System.currentTimeMillis());
            }
            if (confirmedTarget != null && confirmedTarget.equals((Object)target)) {
                this.displayHealthBar(player, target);
            }
            this.lastTargets.put(playerId, target);
        } else if (lastTarget != null || confirmedTarget != null) {
            this.clearPlayerTarget(player);
        }
    }

    private boolean isPlayerActive(Player player) {
        UUID playerId = player.getUniqueId();
        boolean isActive = !player.isSneaking() && !player.isSleeping();
        this.playerActiveStatus.put(playerId, isActive);
        return isActive;
    }

    private LivingEntity getTargetEntity(Player player) {
        try {
            int range = this.plugin.getConfigManager().getDetectionRange();
            RayTraceResult result = player.rayTraceEntities(range);
            if (result != null && result.getHitEntity() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)result.getHitEntity();
                if (entity.equals((Object)player)) {
                    return null;
                }
                if (!entity.isDead() && entity.isValid()) {
                    return entity;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void sendTargetIndicator(Player player, LivingEntity target) {
        if (!this.plugin.getConfigManager().isShowActionBarDisplay()) {
            return;
        }
        String entityName = this.getEntityDisplayName(target);
        String indicator = "<green><bold>\u25b6</bold></green> <gray>" + this.plugin.getLanguageManager().getMessage(player, "targeting", new Object[0]) + ":</gray> <white>" + entityName + "</white> <green><bold>\u25c0</bold></green>";
        Component indicatorComponent = this.plugin.getMiniMessage().deserialize((Object)indicator);
        player.sendActionBar(indicatorComponent);
    }

    private void displayHealthBar(Player player, LivingEntity target) {
        try {
            double health = target.getHealth();
            AttributeInstance maxHealthAttr = target.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (maxHealthAttr == null) {
                return;
            }
            double maxHealth = maxHealthAttr.getValue();
            if (maxHealth <= 0.0) {
                return;
            }
            String entityName = this.getEntityDisplayName(target);
            String message = this.plugin.getConfigManager().formatHealthMessage(entityName, health, maxHealth);
            double percentage = health / maxHealth * 100.0;
            String color = this.plugin.getConfigManager().getHealthColorByPercentage(percentage);
            if (this.plugin.getConfigManager().isShowActionBarDisplay()) {
                String coloredMessage = "<" + color + ">" + message + "</" + color + ">";
                Component component = this.plugin.getMiniMessage().deserialize((Object)coloredMessage);
                player.sendActionBar(component);
            }
            if (this.plugin.getConfigManager().isShow3DHealthDisplay()) {
                this.plugin.getDisplay3DManager().show3DHealthDisplay(target, player);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error displaying health bar for " + player.getName() + ": " + e.getMessage());
        }
    }

    private String getEntityDisplayName(LivingEntity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).getName();
        }
        Component customName = entity.customName();
        if (customName != null) {
            return (String)this.plugin.getMiniMessage().serialize(customName);
        }
        String typeName = entity.getType().name();
        return typeName.substring(0, 1).toUpperCase() + typeName.substring(1).toLowerCase().replace("_", " ");
    }

    private void clearPlayerTarget(Player player) {
        UUID playerId = player.getUniqueId();
        LivingEntity lastTarget = this.lastTargets.remove(playerId);
        LivingEntity confirmedTarget = this.confirmedTargets.remove(playerId);
        if (lastTarget != null || confirmedTarget != null) {
            if (this.plugin.getConfigManager().isShowActionBarDisplay()) {
                player.sendActionBar((Component)Component.empty());
            }
            if (lastTarget != null) {
                this.plugin.getDisplay3DManager().hide3DHealthDisplay(lastTarget);
            }
            if (confirmedTarget != null) {
                this.plugin.getDisplay3DManager().hide3DHealthDisplay(confirmedTarget);
            }
            if (confirmedTarget != null && confirmedTarget.isDead() && this.plugin.getConfigManager().isShowActionBarDisplay()) {
                String eliminatedMsg = this.plugin.getLanguageManager().getMessage(player, "target.eliminated", new Object[0]);
                player.sendActionBar(this.plugin.getMiniMessage().deserialize((Object)("<red>\u2717 " + eliminatedMsg + "</red>")));
            }
        }
    }

    public void restart() {
        this.shutdown();
        this.startHealthBarTask();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.playerActiveStatus.put(playerId, true);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.clearPlayerData(event.getPlayer().getUniqueId());
    }

    public boolean isRunning() {
        return this.healthBarTask != null && !this.healthBarTask.isCancelled();
    }

    public int getActivePlayersCount() {
        return (int)this.playerActiveStatus.values().stream().filter(active -> active).count();
    }

    public int getTotalTrackedPlayers() {
        return this.playerActiveStatus.size();
    }

    public Map<String, Object> getSystemStatus() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("running", this.isRunning());
        status.put("updateInterval", this.plugin.getConfigManager().getUpdateInterval());
        status.put("detectionRange", this.plugin.getConfigManager().getDetectionRange());
        status.put("optimizedMode", this.plugin.getConfigManager().isOptimizedMode());
        status.put("activePlayers", this.getActivePlayersCount());
        status.put("totalTrackedPlayers", this.getTotalTrackedPlayers());
        status.put("lastTargetsCount", this.lastTargets.size());
        status.put("confirmedTargetsCount", this.confirmedTargets.size());
        return status;
    }

    private class HealthBarTask
    extends BukkitRunnable {
        private int currentPlayerIndex = 0;

        private HealthBarTask() {
        }

        public void run() {
            try {
                Collection onlinePlayers = Bukkit.getOnlinePlayers();
                if (onlinePlayers.isEmpty()) {
                    return;
                }
                Player[] players = onlinePlayers.toArray(new Player[0]);
                int maxPlayersPerTick = HealthBarManager.this.plugin.getConfigManager().isOptimizedMode() ? HealthBarManager.this.plugin.getConfigManager().getMaxEntitiesPerTick() : players.length;
                for (int processed = 0; processed < maxPlayersPerTick && processed < players.length; ++processed) {
                    Player player;
                    if (this.currentPlayerIndex >= players.length) {
                        this.currentPlayerIndex = 0;
                    }
                    if ((player = players[this.currentPlayerIndex]) != null && player.isOnline()) {
                        HealthBarManager.this.processPlayer(player);
                    }
                    ++this.currentPlayerIndex;
                }
            }
            catch (Exception e) {
                HealthBarManager.this.plugin.getLogger().warning("Error in health bar task: " + e.getMessage());
            }
        }
    }
}

