/*
 * Decompiled with CFR 0.152.
 */
package haider.plugin.healthGUI.language;

import haider.plugin.healthGUI.HealthGUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;

public class LanguageManager {
    private final HealthGUI plugin;
    private final Map<String, Map<String, String>> translations;
    private final List<String> supportedLanguages;
    private final String defaultLanguage;

    public LanguageManager(HealthGUI plugin) {
        this.plugin = plugin;
        this.translations = new HashMap<String, Map<String, String>>();
        this.supportedLanguages = Arrays.asList("en", "ar", "es", "fr", "de", "pt", "ru", "zh", "ja", "ko");
        this.defaultLanguage = "en";
        this.initializeTranslations();
        plugin.getLogger().info("\u00a7a\u2713 Language system initialized with " + this.supportedLanguages.size() + " languages");
    }

    private void initializeTranslations() {
        this.initializeEnglishTranslations();
        this.initializeArabicTranslations();
        this.initializeSpanishTranslations();
        this.initializeFrenchTranslations();
        this.initializeGermanTranslations();
        this.initializeOtherLanguages();
    }

    private void initializeEnglishTranslations() {
        HashMap<String, String> en = new HashMap<String, String>();
        en.put("gui.main.title", "HealthGUI - Main Settings");
        en.put("gui.detection.range", "\ud83c\udfaf Detection Range");
        en.put("gui.health.bar.style", "\ud83c\udfa8 Health Bar Style");
        en.put("gui.display.options", "\ud83d\udccb Display Options");
        en.put("gui.heart.symbols", "\u2764 Heart Symbols");
        en.put("gui.language.settings", "\ud83c\udf0d Language Settings");
        en.put("gui.performance.settings", "\u26a1 Performance Settings");
        en.put("gui.color.settings", "\ud83c\udfa8 Color Settings");
        en.put("gui.3d.health.display", "\ud83c\udfaf 3D Health Display");
        en.put("gui.current", "Current");
        en.put("gui.enabled", "Enabled");
        en.put("gui.disabled", "Disabled");
        en.put("gui.click.to.configure", "Click to configure");
        en.put("gui.click.to.toggle", "Click to toggle");
        en.put("gui.save.settings", "Save Settings");
        en.put("gui.reset.defaults", "Reset to Defaults");
        en.put("gui.close", "Close");
        en.put("gui.back", "Back");
        en.put("targeting", "Targeting");
        en.put("target.eliminated", "Target eliminated");
        en.put("messages.settings.saved", "Settings saved successfully!");
        en.put("messages.settings.reset", "Settings reset to defaults!");
        en.put("messages.language.changed", "Language changed to English");
        en.put("messages.reload.success", "HealthGUI reloaded successfully!");
        en.put("messages.no.permission", "You don't have permission to use this command!");
        this.translations.put("en", en);
    }

    private void initializeArabicTranslations() {
        HashMap<String, String> ar = new HashMap<String, String>();
        ar.put("gui.main.title", "\u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u0635\u062d\u0629 - \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629");
        ar.put("gui.detection.range", "\ud83c\udfaf \u0645\u062f\u0649 \u0627\u0644\u0627\u0643\u062a\u0634\u0627\u0641");
        ar.put("gui.health.bar.style", "\ud83c\udfa8 \u0623\u0633\u0644\u0648\u0628 \u0634\u0631\u064a\u0637 \u0627\u0644\u0635\u062d\u0629");
        ar.put("gui.display.options", "\ud83d\udccb \u062e\u064a\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0636");
        ar.put("gui.heart.symbols", "\u2764 \u0631\u0645\u0648\u0632 \u0627\u0644\u0642\u0644\u0628");
        ar.put("gui.language.settings", "\ud83c\udf0d \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0644\u063a\u0629");
        ar.put("gui.performance.settings", "\u26a1 \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0623\u062f\u0627\u0621");
        ar.put("gui.color.settings", "\ud83c\udfa8 \u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0623\u0644\u0648\u0627\u0646");
        ar.put("gui.3d.health.display", "\ud83c\udfaf \u0639\u0631\u0636 \u0627\u0644\u0635\u062d\u0629 \u062b\u0644\u0627\u062b\u064a \u0627\u0644\u0623\u0628\u0639\u0627\u062f");
        ar.put("gui.current", "\u0627\u0644\u062d\u0627\u0644\u064a");
        ar.put("gui.enabled", "\u0645\u0641\u0639\u0644");
        ar.put("gui.disabled", "\u0645\u0639\u0637\u0644");
        ar.put("gui.click.to.configure", "\u0627\u0646\u0642\u0631 \u0644\u0644\u062a\u0643\u0648\u064a\u0646");
        ar.put("gui.click.to.toggle", "\u0627\u0646\u0642\u0631 \u0644\u0644\u062a\u0628\u062f\u064a\u0644");
        ar.put("gui.save.settings", "\u062d\u0641\u0638 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a");
        ar.put("gui.reset.defaults", "\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0644\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a");
        ar.put("gui.close", "\u0625\u063a\u0644\u0627\u0642");
        ar.put("gui.back", "\u0631\u062c\u0648\u0639");
        ar.put("targeting", "\u0627\u0633\u062a\u0647\u062f\u0627\u0641");
        ar.put("target.eliminated", "\u062a\u0645 \u0627\u0644\u0642\u0636\u0627\u0621 \u0639\u0644\u0649 \u0627\u0644\u0647\u062f\u0641");
        ar.put("messages.settings.saved", "\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0628\u0646\u062c\u0627\u062d!");
        ar.put("messages.settings.reset", "\u062a\u0645 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0644\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a!");
        ar.put("messages.language.changed", "\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0644\u063a\u0629 \u0625\u0644\u0649 \u0627\u0644\u0639\u0631\u0628\u064a\u0629");
        ar.put("messages.reload.success", "\u062a\u0645 \u0625\u0639\u0627\u062f\u0629 \u062a\u062d\u0645\u064a\u0644 HealthGUI \u0628\u0646\u062c\u0627\u062d!");
        ar.put("messages.no.permission", "\u0644\u064a\u0633 \u0644\u062f\u064a\u0643 \u0625\u0630\u0646 \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0627 \u0627\u0644\u0623\u0645\u0631!");
        this.translations.put("ar", ar);
    }

    private void initializeSpanishTranslations() {
        HashMap<String, String> es = new HashMap<String, String>();
        es.put("gui.main.title", "HealthGUI - Configuraci\u00f3n Principal");
        es.put("gui.detection.range", "\ud83c\udfaf Rango de Detecci\u00f3n");
        es.put("gui.health.bar.style", "\ud83c\udfa8 Estilo de Barra de Salud");
        es.put("gui.display.options", "\ud83d\udccb Opciones de Visualizaci\u00f3n");
        es.put("gui.heart.symbols", "\u2764 S\u00edmbolos de Coraz\u00f3n");
        es.put("gui.language.settings", "\ud83c\udf0d Configuraci\u00f3n de Idioma");
        es.put("gui.performance.settings", "\u26a1 Configuraci\u00f3n de Rendimiento");
        es.put("gui.color.settings", "\ud83c\udfa8 Configuraci\u00f3n de Colores");
        es.put("gui.current", "Actual");
        es.put("gui.enabled", "Habilitado");
        es.put("gui.disabled", "Deshabilitado");
        es.put("gui.click.to.configure", "Clic para configurar");
        es.put("gui.click.to.toggle", "Clic para alternar");
        es.put("gui.save.settings", "Guardar Configuraci\u00f3n");
        es.put("gui.reset.defaults", "Restablecer Predeterminados");
        es.put("gui.close", "Cerrar");
        es.put("gui.back", "Atr\u00e1s");
        es.put("messages.settings.saved", "\u00a1Configuraci\u00f3n guardada exitosamente!");
        es.put("messages.settings.reset", "\u00a1Configuraci\u00f3n restablecida a predeterminados!");
        es.put("messages.language.changed", "Idioma cambiado a Espa\u00f1ol");
        es.put("messages.reload.success", "\u00a1HealthGUI recargado exitosamente!");
        es.put("messages.no.permission", "\u00a1No tienes permiso para usar este comando!");
        this.translations.put("es", es);
    }

    private void initializeFrenchTranslations() {
        HashMap<String, String> fr = new HashMap<String, String>();
        fr.put("gui.main.title", "HealthGUI - Param\u00e8tres Principaux");
        fr.put("gui.detection.range", "\ud83c\udfaf Port\u00e9e de D\u00e9tection");
        fr.put("gui.health.bar.style", "\ud83c\udfa8 Style de Barre de Sant\u00e9");
        fr.put("gui.display.options", "\ud83d\udccb Options d'Affichage");
        fr.put("gui.heart.symbols", "\u2764 Symboles de C\u0153ur");
        fr.put("gui.language.settings", "\ud83c\udf0d Param\u00e8tres de Langue");
        fr.put("gui.performance.settings", "\u26a1 Param\u00e8tres de Performance");
        fr.put("gui.color.settings", "\ud83c\udfa8 Param\u00e8tres de Couleur");
        fr.put("gui.current", "Actuel");
        fr.put("gui.enabled", "Activ\u00e9");
        fr.put("gui.disabled", "D\u00e9sactiv\u00e9");
        fr.put("gui.click.to.configure", "Cliquez pour configurer");
        fr.put("gui.click.to.toggle", "Cliquez pour basculer");
        fr.put("gui.save.settings", "Sauvegarder les Param\u00e8tres");
        fr.put("gui.reset.defaults", "R\u00e9initialiser aux D\u00e9fauts");
        fr.put("gui.close", "Fermer");
        fr.put("gui.back", "Retour");
        fr.put("messages.settings.saved", "Param\u00e8tres sauvegard\u00e9s avec succ\u00e8s!");
        fr.put("messages.settings.reset", "Param\u00e8tres r\u00e9initialis\u00e9s aux d\u00e9fauts!");
        fr.put("messages.language.changed", "Langue chang\u00e9e en Fran\u00e7ais");
        fr.put("messages.reload.success", "HealthGUI recharg\u00e9 avec succ\u00e8s!");
        fr.put("messages.no.permission", "Vous n'avez pas la permission d'utiliser cette commande!");
        this.translations.put("fr", fr);
    }

    private void initializeGermanTranslations() {
        HashMap<String, String> de = new HashMap<String, String>();
        de.put("gui.main.title", "HealthGUI - Haupteinstellungen");
        de.put("gui.detection.range", "\ud83c\udfaf Erkennungsbereich");
        de.put("gui.health.bar.style", "\ud83c\udfa8 Gesundheitsbalken-Stil");
        de.put("gui.display.options", "\ud83d\udccb Anzeigeoptionen");
        de.put("gui.heart.symbols", "\u2764 Herzsymbole");
        de.put("gui.language.settings", "\ud83c\udf0d Spracheinstellungen");
        de.put("gui.performance.settings", "\u26a1 Leistungseinstellungen");
        de.put("gui.color.settings", "\ud83c\udfa8 Farbeinstellungen");
        de.put("gui.current", "Aktuell");
        de.put("gui.enabled", "Aktiviert");
        de.put("gui.disabled", "Deaktiviert");
        de.put("gui.click.to.configure", "Klicken zum Konfigurieren");
        de.put("gui.click.to.toggle", "Klicken zum Umschalten");
        de.put("gui.save.settings", "Einstellungen Speichern");
        de.put("gui.reset.defaults", "Auf Standard Zur\u00fccksetzen");
        de.put("gui.close", "Schlie\u00dfen");
        de.put("gui.back", "Zur\u00fcck");
        de.put("messages.settings.saved", "Einstellungen erfolgreich gespeichert!");
        de.put("messages.settings.reset", "Einstellungen auf Standard zur\u00fcckgesetzt!");
        de.put("messages.language.changed", "Sprache auf Deutsch ge\u00e4ndert");
        de.put("messages.reload.success", "HealthGUI erfolgreich neu geladen!");
        de.put("messages.no.permission", "Du hast keine Berechtigung, diesen Befehl zu verwenden!");
        this.translations.put("de", de);
    }

    private void initializeOtherLanguages() {
        HashMap<String, String> pt = new HashMap<String, String>();
        pt.put("gui.main.title", "HealthGUI - Configura\u00e7\u00f5es Principais");
        pt.put("messages.language.changed", "Idioma alterado para Portugu\u00eas");
        this.translations.put("pt", pt);
        HashMap<String, String> ru = new HashMap<String, String>();
        ru.put("gui.main.title", "HealthGUI - \u041e\u0441\u043d\u043e\u0432\u043d\u044b\u0435 \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438");
        ru.put("messages.language.changed", "\u042f\u0437\u044b\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u043d\u0430 \u0420\u0443\u0441\u0441\u043a\u0438\u0439");
        this.translations.put("ru", ru);
        HashMap<String, String> zh = new HashMap<String, String>();
        zh.put("gui.main.title", "HealthGUI - \u4e3b\u8981\u8bbe\u7f6e");
        zh.put("messages.language.changed", "\u8bed\u8a00\u5df2\u66f4\u6539\u4e3a\u4e2d\u6587");
        this.translations.put("zh", zh);
        HashMap<String, String> ja = new HashMap<String, String>();
        ja.put("gui.main.title", "HealthGUI - \u30e1\u30a4\u30f3\u8a2d\u5b9a");
        ja.put("messages.language.changed", "\u8a00\u8a9e\u304c\u65e5\u672c\u8a9e\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f");
        this.translations.put("ja", ja);
        HashMap<String, String> ko = new HashMap<String, String>();
        ko.put("gui.main.title", "HealthGUI - \uba54\uc778 \uc124\uc815");
        ko.put("messages.language.changed", "\uc5b8\uc5b4\uac00 \ud55c\uad6d\uc5b4\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4");
        this.translations.put("ko", ko);
    }

    public String getMessage(String key, Object ... args) {
        return this.getMessage(this.defaultLanguage, key, args);
    }

    public String getMessage(String language, String key, Object ... args) {
        Map<String, String> langTranslations = this.translations.get(language);
        if (langTranslations == null) {
            langTranslations = this.translations.get(this.defaultLanguage);
        }
        String message = langTranslations.getOrDefault(key, this.translations.get(this.defaultLanguage).getOrDefault(key, key));
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                message = message.replace("{" + i + "}", String.valueOf(args[i]));
            }
        }
        return message;
    }

    public String getMessage(Player player, String key, Object ... args) {
        String playerLang = this.getPlayerLanguage(player);
        return this.getMessage(playerLang, key, args);
    }

    public String getPlayerLanguage(Player player) {
        try {
            String langCode;
            String locale = player.locale().toLanguageTag();
            if (locale != null && locale.length() >= 2 && this.supportedLanguages.contains(langCode = locale.substring(0, 2).toLowerCase())) {
                return langCode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.defaultLanguage;
    }

    public String getTranslatedGUITitle(Player player, String guiType) {
        String key = "gui." + guiType + ".title";
        return this.getMessage(player, key, new Object[0]);
    }

    public Component getTranslatedTitle(Player player, String key) {
        return MiniMessage.miniMessage().deserialize((Object)this.getMessage(player, key, new Object[0]));
    }

    public String getLanguageDisplayName(String language) {
        switch (language) {
            case "en": {
                return "English";
            }
            case "ar": {
                return "\u0627\u0644\u0639\u0631\u0628\u064a\u0629";
            }
            case "es": {
                return "Espa\u00f1ol";
            }
            case "fr": {
                return "Fran\u00e7ais";
            }
            case "de": {
                return "Deutsch";
            }
            case "pt": {
                return "Portugu\u00eas";
            }
            case "ru": {
                return "\u0420\u0443\u0441\u0441\u043a\u0438\u0439";
            }
            case "zh": {
                return "\u4e2d\u6587";
            }
            case "ja": {
                return "\u65e5\u672c\u8a9e";
            }
            case "ko": {
                return "\ud55c\uad6d\uc5b4";
            }
        }
        return "English";
    }

    public List<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public boolean isLanguageLoaded(String language) {
        return this.translations.containsKey(language);
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setPlayerLanguage(Player player, String language) {
        if (this.supportedLanguages.contains(language)) {
            String message = this.getMessage(language, "messages.language.changed", new Object[0]);
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>" + message + "</green>")));
        } else {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<yellow>Language not supported. Available: " + String.join((CharSequence)", ", this.supportedLanguages) + "</yellow>")));
        }
    }

    public void reloadLanguages() {
        this.translations.clear();
        this.initializeTranslations();
        this.plugin.getLogger().info("Language system reloaded with " + this.supportedLanguages.size() + " languages");
    }
}

