/*
 * Decompiled with CFR 0.152.
 */
package haider.plugin.healthGUI.selection;

import haider.plugin.healthGUI.HealthGUI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SelectionManager {
    private final HealthGUI plugin;
    private final Map<UUID, PendingSelection> pendingSelections;

    public SelectionManager(HealthGUI plugin) {
        this.plugin = plugin;
        this.pendingSelections = new ConcurrentHashMap<UUID, PendingSelection>();
    }

    public PendingSelection getPendingSelection(UUID playerId) {
        return this.pendingSelections.computeIfAbsent(playerId, k -> new PendingSelection());
    }

    public boolean hasAnyPendingChanges(UUID playerId) {
        PendingSelection selection = this.pendingSelections.get(playerId);
        return selection != null && selection.hasAnyChanges();
    }

    public int getPendingChangesCount(UUID playerId) {
        PendingSelection selection = this.pendingSelections.get(playerId);
        return selection != null ? selection.getChangesCount() : 0;
    }

    public void clearPlayerSelections(UUID playerId) {
        PendingSelection selection = this.pendingSelections.get(playerId);
        if (selection != null) {
            selection.clearAll();
        }
        this.pendingSelections.remove(playerId);
    }

    public void clearAllSelections() {
        this.pendingSelections.clear();
    }

    public boolean applyPendingSelections(UUID playerId) {
        PendingSelection selection = this.pendingSelections.get(playerId);
        if (selection == null || !selection.hasAnyChanges()) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)playerId);
        boolean applied = false;
        try {
            if (selection.getDetectionRange() != null) {
                this.plugin.getConfigManager().setDetectionRange(selection.getDetectionRange());
                applied = true;
                if (player != null) {
                    player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Detection Range: <yellow>" + selection.getDetectionRange() + " blocks</yellow></green>")));
                }
            }
            if (selection.getFullCharacter() != null) {
                this.plugin.getConfigManager().setFullCharacter(selection.getFullCharacter());
                applied = true;
            }
            if (selection.getEmptyCharacter() != null) {
                this.plugin.getConfigManager().setEmptyCharacter(selection.getEmptyCharacter());
                applied = true;
            }
            if (selection.getBarLength() != null) {
                this.plugin.getConfigManager().setBarLength(selection.getBarLength());
                applied = true;
                if (player != null) {
                    player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Bar Length: <yellow>" + selection.getBarLength() + " bars</yellow></green>")));
                }
            }
            if (selection.getHeartSymbol() != null) {
                this.plugin.getConfigManager().setHeartSymbol(selection.getHeartSymbol());
                applied = true;
                if (player != null) {
                    player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 Heart Symbol: <yellow>" + selection.getHeartSymbol() + "</yellow></green>")));
                }
            }
            if (selection.getShowPercentage() != null) {
                this.plugin.getConfigManager().setShowPercentage(selection.getShowPercentage());
                applied = true;
            }
            if (selection.getShowEntityName() != null) {
                this.plugin.getConfigManager().setShowEntityName(selection.getShowEntityName());
                applied = true;
            }
            if (selection.getHealthyColor() != null) {
                this.plugin.getConfigManager().setHealthyColor(selection.getHealthyColor());
                applied = true;
            }
            if (selection.getMediumColor() != null) {
                this.plugin.getConfigManager().setMediumColor(selection.getMediumColor());
                applied = true;
            }
            if (selection.getLowColor() != null) {
                this.plugin.getConfigManager().setLowColor(selection.getLowColor());
                applied = true;
            }
            if (selection.getMediumThreshold() != null) {
                this.plugin.getConfigManager().setMediumThreshold(selection.getMediumThreshold());
                applied = true;
            }
            if (selection.getLowThreshold() != null) {
                this.plugin.getConfigManager().setLowThreshold(selection.getLowThreshold());
                applied = true;
            }
            if (selection.getOptimizedMode() != null) {
                this.plugin.getConfigManager().setOptimizedMode(selection.getOptimizedMode());
                applied = true;
            }
            if (selection.getMaxEntitiesPerTick() != null) {
                this.plugin.getConfigManager().setMaxEntitiesPerTick(selection.getMaxEntitiesPerTick());
                applied = true;
            }
            if (selection.getShow3DHealthDisplay() != null) {
                this.plugin.getConfigManager().setShow3DHealthDisplay(selection.getShow3DHealthDisplay());
                applied = true;
                if (player != null) {
                    String statusMsg = selection.getShow3DHealthDisplay() != false ? this.plugin.getLanguageManager().getMessage(player, "gui.enabled", new Object[0]) : this.plugin.getLanguageManager().getMessage(player, "gui.disabled", new Object[0]);
                    player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<green>\u2713 3D Health Display: <yellow>" + statusMsg + "</yellow></green>")));
                }
            }
            if (applied) {
                this.plugin.getConfigManager().saveConfig();
                this.plugin.getHealthBarManager().restart();
                this.clearPlayerSelections(playerId);
                if (player != null) {
                    player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)"<green><bold>\u2705 All changes applied successfully!</bold></green>"));
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.2f);
                }
                this.plugin.getLogger().info("Applied " + selection.getChangesCount() + " configuration changes for player: " + (player != null ? player.getName() : playerId.toString()));
            }
            return applied;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to apply pending selections for " + String.valueOf(playerId) + ": " + e.getMessage());
            if (player != null) {
                player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)("<red>\u274c Error applying changes: " + e.getMessage() + "</red>")));
            }
            return false;
        }
    }

    public String getPendingChangesSummary(UUID playerId) {
        PendingSelection selection = this.pendingSelections.get(playerId);
        if (selection == null || !selection.hasAnyChanges()) {
            return "<gray>No pending changes</gray>";
        }
        StringBuilder summary = new StringBuilder();
        summary.append("<gold><bold>Pending Changes:</bold></gold>\n");
        if (selection.getDetectionRange() != null) {
            summary.append("<gray>\u2022 Range: </gray><aqua>").append(selection.getDetectionRange()).append(" blocks</aqua>\n");
        }
        if (selection.getFullCharacter() != null && selection.getEmptyCharacter() != null) {
            summary.append("<gray>\u2022 Style: </gray><aqua>").append(selection.getFullCharacter()).append(selection.getEmptyCharacter()).append("</aqua>\n");
        }
        if (selection.getBarLength() != null) {
            summary.append("<gray>\u2022 Length: </gray><aqua>").append(selection.getBarLength()).append(" bars</aqua>\n");
        }
        if (selection.getHeartSymbol() != null) {
            summary.append("<gray>\u2022 Heart: </gray><aqua>").append(selection.getHeartSymbol()).append("</aqua>\n");
        }
        if (selection.getShowPercentage() != null) {
            summary.append("<gray>\u2022 Percentage: </gray><aqua>").append(selection.getShowPercentage() != false ? "Enabled" : "Disabled").append("</aqua>\n");
        }
        if (selection.getShowEntityName() != null) {
            summary.append("<gray>\u2022 Entity Name: </gray><aqua>").append(selection.getShowEntityName() != false ? "Enabled" : "Disabled").append("</aqua>\n");
        }
        return summary.toString().trim();
    }

    public static class PendingSelection {
        private Integer detectionRange;
        private String fullCharacter;
        private String emptyCharacter;
        private Integer barLength;
        private String heartSymbol;
        private Boolean showPercentage;
        private Boolean showEntityName;
        private String healthyColor;
        private String mediumColor;
        private String lowColor;
        private Integer mediumThreshold;
        private Integer lowThreshold;
        private String messageFormat;
        private Boolean optimizedMode;
        private Integer maxEntitiesPerTick;
        private Boolean show3DHealthDisplay;

        public Integer getDetectionRange() {
            return this.detectionRange;
        }

        public void setDetectionRange(Integer detectionRange) {
            this.detectionRange = detectionRange;
        }

        public void clearDetectionRange() {
            this.detectionRange = null;
        }

        public String getFullCharacter() {
            return this.fullCharacter;
        }

        public void setFullCharacter(String fullCharacter) {
            this.fullCharacter = fullCharacter;
        }

        public void clearFullCharacter() {
            this.fullCharacter = null;
        }

        public String getEmptyCharacter() {
            return this.emptyCharacter;
        }

        public void setEmptyCharacter(String emptyCharacter) {
            this.emptyCharacter = emptyCharacter;
        }

        public void clearEmptyCharacter() {
            this.emptyCharacter = null;
        }

        public Integer getBarLength() {
            return this.barLength;
        }

        public void setBarLength(Integer barLength) {
            this.barLength = barLength;
        }

        public void clearBarLength() {
            this.barLength = null;
        }

        public String getHeartSymbol() {
            return this.heartSymbol;
        }

        public void setHeartSymbol(String heartSymbol) {
            this.heartSymbol = heartSymbol;
        }

        public void clearHeartSymbol() {
            this.heartSymbol = null;
        }

        public Boolean getShowPercentage() {
            return this.showPercentage;
        }

        public void setShowPercentage(Boolean showPercentage) {
            this.showPercentage = showPercentage;
        }

        public void clearShowPercentage() {
            this.showPercentage = null;
        }

        public Boolean getShowEntityName() {
            return this.showEntityName;
        }

        public void setShowEntityName(Boolean showEntityName) {
            this.showEntityName = showEntityName;
        }

        public void clearShowEntityName() {
            this.showEntityName = null;
        }

        public String getHealthyColor() {
            return this.healthyColor;
        }

        public void setHealthyColor(String healthyColor) {
            this.healthyColor = healthyColor;
        }

        public void clearHealthyColor() {
            this.healthyColor = null;
        }

        public String getMediumColor() {
            return this.mediumColor;
        }

        public void setMediumColor(String mediumColor) {
            this.mediumColor = mediumColor;
        }

        public void clearMediumColor() {
            this.mediumColor = null;
        }

        public String getLowColor() {
            return this.lowColor;
        }

        public void setLowColor(String lowColor) {
            this.lowColor = lowColor;
        }

        public void clearLowColor() {
            this.lowColor = null;
        }

        public Integer getMediumThreshold() {
            return this.mediumThreshold;
        }

        public void setMediumThreshold(Integer mediumThreshold) {
            this.mediumThreshold = mediumThreshold;
        }

        public void clearMediumThreshold() {
            this.mediumThreshold = null;
        }

        public Integer getLowThreshold() {
            return this.lowThreshold;
        }

        public void setLowThreshold(Integer lowThreshold) {
            this.lowThreshold = lowThreshold;
        }

        public void clearLowThreshold() {
            this.lowThreshold = null;
        }

        public String getMessageFormat() {
            return this.messageFormat;
        }

        public void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public void clearMessageFormat() {
            this.messageFormat = null;
        }

        public Boolean getOptimizedMode() {
            return this.optimizedMode;
        }

        public void setOptimizedMode(Boolean optimizedMode) {
            this.optimizedMode = optimizedMode;
        }

        public void clearOptimizedMode() {
            this.optimizedMode = null;
        }

        public Integer getMaxEntitiesPerTick() {
            return this.maxEntitiesPerTick;
        }

        public void setMaxEntitiesPerTick(Integer maxEntitiesPerTick) {
            this.maxEntitiesPerTick = maxEntitiesPerTick;
        }

        public void clearMaxEntitiesPerTick() {
            this.maxEntitiesPerTick = null;
        }

        public Boolean getShow3DHealthDisplay() {
            return this.show3DHealthDisplay;
        }

        public void setShow3DHealthDisplay(Boolean show3DHealthDisplay) {
            this.show3DHealthDisplay = show3DHealthDisplay;
        }

        public void clearShow3DHealthDisplay() {
            this.show3DHealthDisplay = null;
        }

        public boolean hasAnyChanges() {
            return this.detectionRange != null || this.fullCharacter != null || this.emptyCharacter != null || this.barLength != null || this.heartSymbol != null || this.showPercentage != null || this.showEntityName != null || this.healthyColor != null || this.mediumColor != null || this.lowColor != null || this.mediumThreshold != null || this.lowThreshold != null || this.messageFormat != null || this.optimizedMode != null || this.maxEntitiesPerTick != null || this.show3DHealthDisplay != null;
        }

        public int getChangesCount() {
            int count = 0;
            if (this.detectionRange != null) {
                ++count;
            }
            if (this.fullCharacter != null) {
                ++count;
            }
            if (this.emptyCharacter != null) {
                ++count;
            }
            if (this.barLength != null) {
                ++count;
            }
            if (this.heartSymbol != null) {
                ++count;
            }
            if (this.showPercentage != null) {
                ++count;
            }
            if (this.showEntityName != null) {
                ++count;
            }
            if (this.healthyColor != null) {
                ++count;
            }
            if (this.mediumColor != null) {
                ++count;
            }
            if (this.lowColor != null) {
                ++count;
            }
            if (this.mediumThreshold != null) {
                ++count;
            }
            if (this.lowThreshold != null) {
                ++count;
            }
            if (this.messageFormat != null) {
                ++count;
            }
            if (this.optimizedMode != null) {
                ++count;
            }
            if (this.maxEntitiesPerTick != null) {
                ++count;
            }
            if (this.show3DHealthDisplay != null) {
                ++count;
            }
            return count;
        }

        public void clearAll() {
            this.detectionRange = null;
            this.fullCharacter = null;
            this.emptyCharacter = null;
            this.barLength = null;
            this.heartSymbol = null;
            this.showPercentage = null;
            this.showEntityName = null;
            this.healthyColor = null;
            this.mediumColor = null;
            this.lowColor = null;
            this.mediumThreshold = null;
            this.lowThreshold = null;
            this.messageFormat = null;
            this.optimizedMode = null;
            this.maxEntitiesPerTick = null;
            this.show3DHealthDisplay = null;
        }
    }
}

