/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.blooming.blossom.world.gen.treedecorator;

import com.devnemo.blooming.blossom.world.gen.treedecorator.ModTreeDecoratorType;
import com.mojang.serialization.MapCodec;
import java.util.Random;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3746;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_5281;
import org.jetbrains.annotations.NotNull;

public class FallenLeavesTreeDecorator
extends class_4662 {
    public static final FallenLeavesTreeDecorator INSTANCE = new FallenLeavesTreeDecorator();
    public static final MapCodec<FallenLeavesTreeDecorator> CODEC = MapCodec.unit(() -> INSTANCE);

    @NotNull
    protected class_4663<?> method_28893() {
        return ModTreeDecoratorType.FALLEN_LEAVES_TREE_DECORATOR;
    }

    public void method_23469(class_4662.class_7402 context) {
        class_2338 logPosition = (class_2338)context.method_43321().get(0);
        this.generateRandomLeavesBlock(context, logPosition);
    }

    private void generateRandomLeavesBlock(class_4662.class_7402 context, class_2338 logPosition) {
        Random random = new Random();
        int probability = 3;
        int from = 0;
        int to = 3;
        for (int i = from; i < to; ++i) {
            for (int j = from; j < to; ++j) {
                this.generateFallenLeavesByProbability(random, probability, context, logPosition, to - i + from, j + 1);
                this.generateFallenLeavesByProbability(random, probability, context, logPosition, to - i + from, -j - 1);
                this.generateFallenLeavesByProbability(random, probability, context, logPosition, -to + i - from, j + 1);
                this.generateFallenLeavesByProbability(random, probability, context, logPosition, -to + i - from, -j - 1);
                this.generateFallenLeavesByProbability(random, probability, context, logPosition, i + 1, 0);
                this.generateFallenLeavesByProbability(random, probability, context, logPosition, -i - 1, 0);
                this.generateFallenLeavesByProbability(random, probability, context, logPosition, 0, i + 1);
                this.generateFallenLeavesByProbability(random, probability, context, logPosition, 0, i - 1);
            }
        }
    }

    private void generateFallenLeavesByProbability(Random random, int probability, class_4662.class_7402 context, class_2338 logPosition, int i, int j) {
        int randomNumber = random.nextInt(100) + 1;
        if (randomNumber < probability) {
            this.placeFallenLeavesBlockUpAndDown(context, logPosition.method_10076(i).method_10089(j).method_10084());
        }
    }

    private void placeFallenLeavesBlockUpAndDown(class_4662.class_7402 context, class_2338 petalPosition) {
        for (int i = 0; i < 3; ++i) {
            this.placeFallenLeavesBlock(context, petalPosition.method_10086(i));
            this.placeFallenLeavesBlock(context, petalPosition.method_10087(i));
        }
    }

    private void placeFallenLeavesBlock(class_4662.class_7402 context, class_2338 fallenLeavesPosition) {
        class_3746 world = context.method_43316();
        if (world instanceof class_5281 && this.areLeavesBlockPlantable(context, fallenLeavesPosition)) {
            class_2338 leavesPosition = (class_2338)context.method_43322().get(0);
            class_2248 leavesBlock = ((class_5281)world).method_8320(leavesPosition).method_26204();
            if (!context.method_43317(leavesPosition)) {
                context.method_43318(fallenLeavesPosition, (class_2680)leavesBlock.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    private boolean areLeavesBlockPlantable(class_4662.class_7402 context, class_2338 leavesPosition) {
        class_2338 groundPosition = leavesPosition.method_10074();
        boolean isGroundSoil = class_3031.method_27368((class_3746)context.method_43316(), (class_2338)groundPosition);
        boolean isLeavesPositionAir = context.method_43317(leavesPosition);
        boolean isAboveBlockPositionAir = context.method_43317(leavesPosition.method_10084());
        return isGroundSoil && isLeavesPositionAir && isAboveBlockPositionAir;
    }
}

