/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justenoughprofessions;

import com.mrbysco.justenoughprofessions.Constants;
import com.mrbysco.justenoughprofessions.compat.CompatibilityHelper;
import com.mrbysco.justenoughprofessions.jei.ProfessionCategory;
import com.mrbysco.justenoughprofessions.jei.ProfessionEntry;
import com.mrbysco.justenoughprofessions.jei.ProfessionWrapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@JeiPlugin
public class NeoForgeProfessionPlugin
implements IModPlugin {
    private static final ResourceLocation UID = Constants.modLoc("jei_plugin");
    public static final IRecipeType<ProfessionWrapper> PROFESSION_TYPE = IRecipeType.create((String)"justenoughprofessions", (String)"professions", ProfessionWrapper.class);

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ProfessionCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(PROFESSION_TYPE, new ItemStack[]{new ItemStack((ItemLike)Items.EMERALD)});
        registration.addCraftingStation(PROFESSION_TYPE, new ItemStack[]{new ItemStack((ItemLike)Items.VILLAGER_SPAWN_EGG)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        LinkedList<ProfessionWrapper> entries = new LinkedList<ProfessionWrapper>();
        for (Map.Entry entry : BuiltInRegistries.VILLAGER_PROFESSION.entrySet()) {
            ResourceKey resourceKey = (ResourceKey)entry.getKey();
            VillagerProfession profession = (VillagerProfession)entry.getValue();
            if (((ResourceKey)entry.getKey()).location().equals((Object)VillagerProfession.NONE.location())) continue;
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            List types = BuiltInRegistries.POINT_OF_INTEREST_TYPE.stream().toList();
            for (PoiType poiType : types) {
                Optional poiKey = BuiltInRegistries.POINT_OF_INTEREST_TYPE.getResourceKey((Object)poiType);
                if (!poiKey.isPresent() || !profession.acquirableJobSite().test(BuiltInRegistries.POINT_OF_INTEREST_TYPE.get((ResourceKey)poiKey.get()).orElse(null))) continue;
                for (BlockState state : poiType.matchingStates()) {
                    Block block = state.getBlock();
                    if (block == null) continue;
                    ItemStack stack = CompatibilityHelper.compatibilityCheck(new ItemStack((ItemLike)block), BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession));
                    ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                    if (stack.isEmpty() || knownItems.contains(location)) continue;
                    stacks.add(stack);
                    knownItems.add(location);
                }
            }
            if (stacks.isEmpty()) continue;
            entries.add(new ProfessionWrapper(new ProfessionEntry((Holder<VillagerProfession>)BuiltInRegistries.VILLAGER_PROFESSION.getOrThrow(resourceKey), stacks)));
        }
        registration.addRecipes(PROFESSION_TYPE, entries);
    }
}

