/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justenoughprofessions;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RenderHelper {
    public static final Vector3f TRANSLATION = new Vector3f();
    public static final Quaternionf ANGLE = new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.PI);

    public static void renderVillager(GuiGraphics guiGraphics, int x, int y, double scale, double yaw, double pitch, Villager villager) {
        if (villager.level() == null) {
            return;
        }
        int startX = x - 60;
        int startY = y - 60;
        int endX = x + 60;
        int endY = y + 60;
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        poseStack.scale((float)scale, (float)scale);
        villager.yBodyRot = (float)(-(yaw / 40.0)) * 20.0f + 180.0f;
        villager.setYRot((float)(-(yaw / 40.0)) * 20.0f);
        villager.yHeadRot = villager.getYRot() + 180.0f;
        villager.yHeadRotO = villager.getYRot() + 180.0f;
        villager.setXRot((float)(-(pitch / 5.0)));
        poseStack.translate(0.0f, (float)villager.getVehicleAttachmentPoint((Entity)villager).y());
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)startX, (int)startY, (int)endX, (int)endY, (float)((float)scale), (Vector3f)TRANSLATION, (Quaternionf)ANGLE, (Quaternionf)null, (LivingEntity)villager);
        poseStack.popMatrix();
    }
}

