/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justenoughprofessions.jei;

import com.mrbysco.justenoughprofessions.Constants;
import com.mrbysco.justenoughprofessions.jei.ProfessionWrapper;
import com.mrbysco.justenoughprofessions.platform.Services;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2fStack;

public class ProfessionCategory
implements IRecipeCategory<ProfessionWrapper> {
    private final IDrawableStatic icon;

    public ProfessionCategory(IGuiHelper guiHelper) {
        ResourceLocation iconLocation = Constants.modLoc("textures/gui/profession_icon.png");
        this.icon = guiHelper.createDrawable(iconLocation, 0, 0, 16, 16);
    }

    public IRecipeType<ProfessionWrapper> getRecipeType() {
        return Services.PLATFORM.getProfessionType();
    }

    public Component getTitle() {
        return Component.translatable((String)"justenoughprofessions.professions.title");
    }

    public int getHeight() {
        return 62;
    }

    public int getWidth() {
        return 72;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ProfessionWrapper recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 56, 23).addItemStacks(recipe.getBlockStacks())).setStandardSlotBackground();
    }

    public void draw(ProfessionWrapper professionWrapper, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        String text;
        professionWrapper.drawInfo(professionWrapper, this.getWidth(), this.getHeight(), guiGraphics, mouseX, mouseY);
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        String string = text = mc.hasShiftDown() ? professionWrapper.getProfessionName().toString() : professionWrapper.getDisplayName().getString();
        if (font.width(text) > 122) {
            poseStack.scale(0.75f, 0.75f);
        }
        this.renderScrollingString(guiGraphics, font, (Component)Component.literal((String)text), 0, 0, 0, 74, 9, ARGB.opaque((int)8));
        poseStack.popMatrix();
    }

    private void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int i = font.width((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            guiGraphics.drawString(font, text, minX - (int)d3, j, color, false);
            guiGraphics.disableScissor();
        } else {
            guiGraphics.drawString(font, text, 0, 0, ARGB.opaque((int)8), false);
        }
    }
}

