/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justenoughprofessions.jei;

import com.mrbysco.justenoughprofessions.RenderHelper;
import com.mrbysco.justenoughprofessions.jei.ProfessionEntry;
import java.util.List;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;

public record ProfessionWrapper(ProfessionEntry entry) implements IRecipeCategoryExtension<ProfessionWrapper>
{
    public ResourceLocation getProfessionName() {
        return this.entry.professionHolder().unwrapKey().map(ResourceKey::location).orElse(null);
    }

    public Component getDisplayName() {
        ResourceLocation professionKey = this.getProfessionName();
        String languageKey = professionKey.toLanguageKey();
        if (languageKey.startsWith("minecraft.")) {
            languageKey = languageKey.replace("minecraft.", "");
        }
        return Component.translatable((String)("entity.minecraft.villager." + languageKey));
    }

    public List<ItemStack> getBlockStacks() {
        return this.entry.blockStacks();
    }

    public void drawInfo(ProfessionWrapper recipe, int recipeWidth, int recipeHeight, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        Villager entityVillager = this.entry.getVillagerEntity();
        if (entityVillager != null) {
            Vector2f position = new Vector2f(26.0f, 62.0f);
            position = poseStack.transformPosition(position);
            int x = Math.round(position.x);
            int y = Math.round(position.y);
            RenderHelper.renderVillager(guiGraphics, x, y, 25.0, 38.0 - mouseX, 15.0 - mouseY, entityVillager);
        }
    }
}

