/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common.antixray;

import dev.booky.betterview.common.antixray.ReplacementPresets;
import dev.booky.betterview.common.antixray.ReplacementStrategy;
import dev.booky.betterview.common.config.BvLevelConfig;
import dev.booky.betterview.common.util.MathUtil;
import dev.booky.betterview.common.util.VarIntUtil;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.Function;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class AntiXrayProcessor {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int STORAGE_BITS = 4;
    private static final int STORAGE_SIZE = 16;
    private static final int STORAGE_SIZE_2D = 256;
    private static final int STORAGE_SIZE_3D = 4096;
    private final ReplacementStrategy.Ctor strategy;
    private final ReplacementPresets presets;
    private final BitSet obfuscatedStates;
    private final int stateRegistrySize;

    public AntiXrayProcessor(ReplacementStrategy.Ctor strategy, ReplacementPresets presets, int[] obfuscatedStates, int stateRegistrySize) {
        this.strategy = strategy;
        this.presets = presets;
        this.stateRegistrySize = stateRegistrySize;
        this.obfuscatedStates = BitSet.valueOf(EMPTY_LONG_ARRAY);
        this.obfuscatedStates.set(stateRegistrySize);
        int len = obfuscatedStates.length;
        for (int i = 0; i < len; ++i) {
            this.obfuscatedStates.set(obfuscatedStates[i]);
        }
    }

    public static @Nullable AntiXrayProcessor createProcessor(BvLevelConfig.AntiXrayConfig config, ReplacementPresets levelPresets, Function<Key, Stream<Integer>> stateListFn, int stateRegistrySize) {
        if (!config.isEnabled()) {
            return null;
        }
        int[] states = config.getHiddenBlocks().stream().flatMap(stateListFn).mapToInt(i -> i).distinct().toArray();
        return new AntiXrayProcessor(config.getEngineMode().getStrategy(), config.getEngineMode() == BvLevelConfig.AntiXrayConfig.EngineMode.HIDE ? levelPresets : ReplacementPresets.createStatic(states), states, stateRegistrySize);
    }

    private static int storageIndex(int blockX, int blockY, int blockZ) {
        return (blockY << 4 | blockZ) << 4 | blockX;
    }

    private static int storageIndex(int blockXZ, int blockY) {
        return blockY << 8 | blockXZ;
    }

    public synchronized void process(ByteBuf buf, int sectionY, boolean storageLength) {
        int i;
        long[] newStorage;
        char newValuesPerWord;
        boolean resize;
        long[] storage;
        char valuesPerWord;
        long entryMask;
        int paletteBits;
        int[] presets = this.presets.getPresets(sectionY);
        int presetCount = presets.length;
        if (presetCount < 1) {
            return;
        }
        int readerIndex = buf.readerIndex();
        int paletteStorageBits = paletteBits = buf.readByte();
        int newPaletteBits = paletteBits;
        int[] newPalette = null;
        BitSet obfuscatedPalette = null;
        int[] presetPalette = null;
        switch (paletteBits) {
            case 0: {
                int value = VarIntUtil.readVarInt(buf);
                if (!this.obfuscatedStates.get(value)) {
                    return;
                }
                if (presetCount == 1 && presets[0] == value) {
                    return;
                }
                obfuscatedPalette = BitSet.valueOf(EMPTY_LONG_ARRAY);
                obfuscatedPalette.set(0);
                presetPalette = new int[presetCount];
                int presetIndex = Arrays.binarySearch(presets, value);
                if (presetIndex < 0) {
                    newPalette = new int[1 + presetCount];
                    System.arraycopy(presets, 0, newPalette, 1, presetCount);
                    for (i = 0; i < presetCount; ++i) {
                        presetPalette[i] = i + 1;
                    }
                } else {
                    newPalette = new int[presetCount];
                    System.arraycopy(presets, 0, newPalette, 1, presetIndex);
                    System.arraycopy(presets, presetIndex + 1, newPalette, 1 + presetIndex, presetCount - (presetIndex + 1));
                    for (i = 0; i < presetIndex; ++i) {
                        presetPalette[i] = i + 1;
                    }
                    for (i = presetIndex + 1; i < presetCount; ++i) {
                        presetPalette[i] = i;
                    }
                    presetPalette[presetIndex] = 0;
                }
                newPalette[0] = value;
                newPaletteBits = Math.max(4, MathUtil.ceilLog2(newPalette.length));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                paletteStorageBits = 4;
                newPaletteBits = 4;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                int i2;
                int paletteSize = VarIntUtil.readVarInt(buf);
                int[] palette = new int[paletteSize];
                int extraPaletteSize = presetCount;
                for (i2 = 0; i2 < paletteSize; ++i2) {
                    int presetIndex;
                    int value;
                    palette[i2] = value = VarIntUtil.readVarInt(buf);
                    if (this.obfuscatedStates.get(value) && (presetCount != 1 || presets[0] != value)) {
                        if (obfuscatedPalette == null) {
                            obfuscatedPalette = BitSet.valueOf(EMPTY_LONG_ARRAY);
                            obfuscatedPalette.set(paletteSize);
                        }
                        obfuscatedPalette.set(i2);
                    }
                    if ((presetIndex = Arrays.binarySearch(presets, value)) < 0) continue;
                    --extraPaletteSize;
                    if (presetPalette == null) {
                        presetPalette = new int[presetCount];
                        if (paletteSize != 1) {
                            Arrays.fill(presetPalette, -1);
                        }
                    }
                    presetPalette[presetIndex] = i2;
                }
                if (obfuscatedPalette == null) {
                    return;
                }
                if (extraPaletteSize <= 0) break;
                newPalette = new int[paletteSize + extraPaletteSize];
                System.arraycopy(palette, 0, newPalette, 0, paletteSize);
                if (presetPalette != null) {
                    int j = paletteSize;
                    for (i2 = 0; i2 < presetCount; ++i2) {
                        if (presetPalette[i2] != -1) continue;
                        newPalette[j] = presets[i2];
                        presetPalette[i2] = j++;
                    }
                } else {
                    System.arraycopy(presets, 0, newPalette, paletteSize, presetCount);
                    presetPalette = new int[presetCount];
                    for (i2 = 0; i2 < presetCount; ++i2) {
                        presetPalette[i2] = i2 + paletteSize;
                    }
                }
                int predictedBits = MathUtil.ceilLog2(paletteSize + extraPaletteSize);
                newPaletteBits = Math.max(predictedBits, newPaletteBits);
                break;
            }
            default: {
                newPaletteBits = paletteStorageBits = MathUtil.ceilLog2(this.stateRegistrySize);
                obfuscatedPalette = this.obfuscatedStates;
                presetPalette = presets;
            }
        }
        int storageIndex = buf.readerIndex();
        if (paletteStorageBits == 0) {
            entryMask = 0L;
            valuesPerWord = '\u0000';
            if (storageLength) {
                int bufWordCount = VarIntUtil.readVarInt(buf);
                assert (bufWordCount == 0);
            }
            storage = EMPTY_LONG_ARRAY;
        } else {
            entryMask = (1L << paletteStorageBits) - 1L;
            valuesPerWord = (char)(64 / paletteStorageBits);
            int wordCount = (4096 + valuesPerWord - 1) / valuesPerWord;
            if (storageLength) {
                int bufWordCount = VarIntUtil.readVarInt(buf);
                assert (bufWordCount == wordCount);
            }
            storage = new long[wordCount];
            for (int i3 = 0; i3 < wordCount; ++i3) {
                storage[i3] = buf.readLong();
            }
        }
        assert (newPaletteBits >= paletteStorageBits);
        boolean bl = resize = paletteStorageBits != newPaletteBits;
        if (!resize) {
            newValuesPerWord = valuesPerWord;
            newStorage = storage;
        } else {
            newValuesPerWord = (char)(64 / newPaletteBits);
            int newWordCount = (4096 + newValuesPerWord - 1) / newValuesPerWord;
            newStorage = new long[newWordCount];
        }
        ReplacementStrategy strategy = this.strategy.construct(presetCount);
        for (int y = 0; y < 16; ++y) {
            boolean advanced = false;
            for (int xz = 0; xz < 256; ++xz) {
                int newValue;
                int value;
                long word;
                int bitIndex;
                int blockIndex = AntiXrayProcessor.storageIndex(xz, y);
                if (paletteStorageBits != 0) {
                    wordIndex = blockIndex / valuesPerWord;
                    bitIndex = (blockIndex - wordIndex * valuesPerWord) * paletteStorageBits;
                    word = storage[wordIndex];
                    value = (int)(word >> bitIndex & entryMask);
                } else {
                    wordIndex = 0;
                    bitIndex = 0;
                    word = 0L;
                    value = 0;
                }
                if (obfuscatedPalette.get(value)) {
                    if (!advanced) {
                        advanced = true;
                        strategy.advance();
                    }
                    newValue = presetPalette[strategy.get()];
                    if (!resize && newValue != value) {
                        storage[wordIndex] = word & (entryMask << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | (long)newValue << bitIndex;
                        continue;
                    }
                } else {
                    newValue = value;
                }
                if (!resize) continue;
                int newWordIndex = blockIndex / newValuesPerWord;
                int newBitIndex = (blockIndex - newWordIndex * newValuesPerWord) * newPaletteBits;
                int n = newWordIndex;
                newStorage[n] = newStorage[n] | (long)newValue << newBitIndex;
            }
        }
        buf.readerIndex(readerIndex);
        if (newPalette != null) {
            buf.writerIndex(readerIndex);
            buf.writeByte(newPaletteBits);
            switch (newPaletteBits) {
                case 0: {
                    VarIntUtil.writeVarInt(buf, newPalette[0]);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    int newPaletteSize = newPalette.length;
                    VarIntUtil.writeVarInt(buf, newPaletteSize);
                    for (i = 0; i < newPaletteSize; ++i) {
                        VarIntUtil.writeVarInt(buf, newPalette[i]);
                    }
                    break;
                }
            }
        } else {
            buf.writerIndex(storageIndex);
        }
        int newStorageSize = newStorage.length;
        if (storageLength) {
            VarIntUtil.writeVarInt(buf, newStorageSize);
        }
        for (i = 0; i < newStorageSize; ++i) {
            buf.writeLong(newStorage[i]);
        }
    }
}

