/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common.antixray;

import java.util.concurrent.ThreadLocalRandom;
import org.jspecify.annotations.NullMarked;

@NullMarked
@FunctionalInterface
public interface ReplacementStrategy {
    public static final ReplacementStrategy STATIC_ZERO = () -> 0;

    public static ReplacementStrategy replaceStaticZero(int ignoredBlockCount) {
        return STATIC_ZERO;
    }

    public static ReplacementStrategy replaceRandom(final int blockCount) {
        return new ReplacementStrategy(){
            private int state;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public int get() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                return (int)(Integer.toUnsignedLong(this.state) * (long)blockCount >>> 32);
            }
        };
    }

    public static ReplacementStrategy replaceRandomLayered(final int blockCount) {
        return new ReplacementStrategy(){
            private int state;
            private int next;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public void advance() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                this.next = (int)(Integer.toUnsignedLong(this.state) * (long)blockCount >>> 32);
            }

            @Override
            public int get() {
                return this.next;
            }
        };
    }

    default public void advance() {
    }

    public int get();

    @FunctionalInterface
    public static interface Ctor {
        public ReplacementStrategy construct(int var1);
    }
}

