/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.nms.v1213;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.util.SaveUtil;
import com.destroystokyo.paper.util.SneakyThrow;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.booky.betterview.common.antixray.AntiXrayProcessor;
import dev.booky.betterview.nms.ReflectionUtil;
import dev.booky.betterview.nms.v1213.ChunkWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ChunkTagTransformer {
    private static final MethodHandle MAKE_BIOME_CODEC_RW = ReflectionUtil.getMethod(SerializableChunkData.class, MethodType.methodType(Codec.class, Registry.class), 1);

    private ChunkTagTransformer() {
    }

    private static Codec<PalettedContainer<Holder<Biome>>> makeBiomeCodecRW(Registry<Biome> registry) {
        try {
            return MAKE_BIOME_CODEC_RW.invoke(registry);
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
            throw new AssertionError();
        }
    }

    public static boolean isChunkLit(CompoundTag tag) {
        ChunkStatus status = ChunkStatus.byName((String)tag.getString("Status"));
        if (!status.isOrAfter(ChunkStatus.LIGHT)) {
            return false;
        }
        if (tag.get("isLightOn") == null) {
            return false;
        }
        int lightVersion = tag.getInt("starlight.light_version");
        return lightVersion == SaveUtil.getLightVersion();
    }

    private static boolean extractChunkData(ServerLevel level, CompoundTag chunkTag, ChunkPos pos, LevelChunkSection[] sections, byte[][] blockLight, byte @Nullable [][] skyLight) {
        Registry biomeRegistry = level.registryAccess().lookupOrThrow(Registries.BIOME);
        Codec<PalettedContainer<Holder<Biome>>> biomeCodec = ChunkTagTransformer.makeBiomeCodecRW((Registry<Biome>)biomeRegistry);
        ListTag sectionTags = chunkTag.getList("sections", 10);
        int minLightSection = WorldUtil.getMinLightSection((LevelHeightAccessor)level);
        boolean onlyAir = true;
        for (int i = 0; i < sectionTags.size(); ++i) {
            CompoundTag sectionTag = sectionTags.getCompound(i);
            byte sectionY = sectionTag.getByte("Y");
            int sectionIndex = level.getSectionIndexFromSectionY((int)sectionY);
            if (sectionIndex >= 0 && sectionIndex < sections.length) {
                LevelChunkSection section;
                PalettedContainer blocks;
                Object[] presetBlockStates = level.chunkPacketBlockController.getPresetBlockStates((Level)level, pos, (int)sectionY);
                if (sectionTag.contains("block_states", 10)) {
                    Codec blockStateCodec = presetBlockStates != null ? PalettedContainer.codecRW((IdMap)Block.BLOCK_STATE_REGISTRY, (Codec)BlockState.CODEC, (PalettedContainer.Strategy)PalettedContainer.Strategy.SECTION_STATES, (Object)Blocks.AIR.defaultBlockState(), (Object[])presetBlockStates) : SerializableChunkData.BLOCK_STATE_CODEC;
                    blocks = (PalettedContainer)blockStateCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)sectionTag.getCompound("block_states")).getOrThrow();
                } else {
                    blocks = new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES, presetBlockStates);
                }
                PalettedContainer biomes = sectionTag.contains("biomes", 10) ? (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)sectionTag.getCompound("biomes")).getOrThrow() : new PalettedContainer(biomeRegistry.asHolderIdMap(), (Object)biomeRegistry.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES, null);
                sections[sectionIndex] = section = new LevelChunkSection(blocks, biomes);
                if (!section.hasOnlyAir()) {
                    onlyAir = false;
                }
            }
            if (sectionTag.contains("BlockLight", 7)) {
                blockLight[sectionY - minLightSection] = sectionTag.getByteArray("BlockLight");
            }
            if (skyLight == null || !sectionTag.contains("SkyLight", 7)) continue;
            skyLight[sectionY - minLightSection] = sectionTag.getByteArray("SkyLight");
        }
        return onlyAir;
    }

    private static CompoundTag filterHeightmaps(CompoundTag chunkTag) {
        CompoundTag heightmaps = chunkTag.getCompound("Heightmaps");
        if (heightmaps.isEmpty()) {
            return heightmaps;
        }
        CompoundTag filteredHeightmaps = new CompoundTag();
        int len = ChunkWriter.SENDABLE_HEIGHTMAP_TYPES.length;
        for (int i = 0; i < len; ++i) {
            String key = ChunkWriter.SENDABLE_HEIGHTMAP_TYPES[i].getSerializationKey();
            Tag heightmapsEntry = heightmaps.get(key);
            if (heightmapsEntry == null) continue;
            filteredHeightmaps.put(key, heightmapsEntry);
        }
        return filteredHeightmaps;
    }

    public static ByteBuf transformToBytesOrEmpty(ServerLevel level, CompoundTag chunkTag, @Nullable AntiXrayProcessor antiXray, ChunkPos pos) {
        byte[][] skyLight;
        byte[][] blockLight;
        LevelChunkSection[] sections = new LevelChunkSection[level.getSectionsCount()];
        boolean onlyAir = ChunkTagTransformer.extractChunkData(level, chunkTag, pos, sections, blockLight = new byte[WorldUtil.getTotalLightSections((LevelHeightAccessor)level)][], skyLight = level.dimensionType().hasSkyLight() ? new byte[blockLight.length][] : null);
        if (onlyAir) {
            return Unpooled.EMPTY_BUFFER;
        }
        CompoundTag heightmapsTag = ChunkTagTransformer.filterHeightmaps(chunkTag);
        return ChunkWriter.writeFull(pos.x, pos.z, antiXray, level.getMinSectionY(), heightmapsTag, sections, blockLight, skyLight);
    }
}

