/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.nms.v1213;

import com.destroystokyo.paper.util.SneakyThrow;
import dev.booky.betterview.common.antixray.AntiXrayProcessor;
import dev.booky.betterview.common.util.BetterViewUtil;
import dev.booky.betterview.nms.ReflectionUtil;
import dev.booky.betterview.nms.v1213.LightWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ChunkWriter {
    static final Heightmap.Types[] SENDABLE_HEIGHTMAP_TYPES = (Heightmap.Types[])Arrays.stream(Heightmap.Types.values()).filter(Heightmap.Types::sendToClient).toArray(Heightmap.Types[]::new);
    private static final MethodHandle GET_NON_EMPTY_BLOCK_COUNT = ReflectionUtil.getGetter(LevelChunkSection.class, Short.TYPE, 0);

    private ChunkWriter() {
    }

    private static boolean isEmpty(ChunkAccess chunk) {
        if (chunk instanceof EmptyLevelChunk) {
            return true;
        }
        for (LevelChunkSection section : chunk.getSections()) {
            if (section == null || section.hasOnlyAir()) continue;
            return false;
        }
        return true;
    }

    public static CompoundTag extractHeightmapsTag(ChunkAccess chunk) {
        CompoundTag heightmapsTag = new CompoundTag();
        for (Heightmap.Types type : SENDABLE_HEIGHTMAP_TYPES) {
            if (!chunk.hasPrimedHeightmap(type)) continue;
            long[] heightmapData = chunk.getOrCreateHeightmapUnprimed(type).getRawData();
            heightmapsTag.put(type.getSerializationKey(), (Tag)new LongArrayTag(heightmapData));
        }
        return heightmapsTag;
    }

    public static ByteBuf writeFullOrEmpty(ChunkAccess chunk, @Nullable AntiXrayProcessor antiXray) {
        if (ChunkWriter.isEmpty(chunk)) {
            return Unpooled.EMPTY_BUFFER;
        }
        CompoundTag heightmapTags = ChunkWriter.extractHeightmapsTag(chunk);
        byte[][] blockLight = LightWriter.convertStarlightToBytes(chunk.starlight$getBlockNibbles(), false);
        byte[][] skyLight = LightWriter.convertStarlightToBytes(chunk.starlight$getSkyNibbles(), true);
        return ChunkWriter.writeFull(chunk.locX, chunk.locZ, antiXray, chunk.getMinSectionY(), heightmapTags, chunk.getSections(), blockLight, skyLight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf writeFull(int chunkX, int chunkZ, @Nullable AntiXrayProcessor antiXray, int minSectionY, CompoundTag heightmapsTag, LevelChunkSection[] sections, byte[][] blockLight, byte @Nullable [][] skyLight) {
        ByteBuf buf = BetterViewUtil.ALLOC.buffer();
        try {
            buf.writeByte(40);
            buf.writeInt(chunkX);
            buf.writeInt(chunkZ);
            ChunkWriter.writeFullBody(buf, antiXray, minSectionY, heightmapsTag, sections, blockLight, skyLight);
            ByteBuf byteBuf = buf.retain();
            return byteBuf;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFullBody(ByteBuf buf, @Nullable AntiXrayProcessor antiXray, int minSectionY, CompoundTag heightmapsTag, LevelChunkSection[] sections, byte[][] blockLight, byte @Nullable [][] skyLight) {
        FriendlyByteBuf.writeNbt((ByteBuf)buf, (Tag)heightmapsTag);
        if (antiXray != null) {
            ByteBuf subBuf = BetterViewUtil.ALLOC.buffer();
            try {
                FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(subBuf);
                int len = sections.length;
                for (int i = 0; i < len; ++i) {
                    ChunkWriter.writeSection(friendlyBuf, sections[i], antiXray, i + minSectionY);
                }
                VarInt.write((ByteBuf)buf, (int)subBuf.readableBytes());
                buf.writeBytes(subBuf);
            }
            finally {
                subBuf.release();
            }
        } else {
            int serializedSize = 0;
            int len = sections.length;
            for (int i = 0; i < len; ++i) {
                serializedSize += sections[i].getSerializedSize();
            }
            VarInt.write((ByteBuf)buf, (int)serializedSize);
            int expectedWriterIndex = buf.writerIndex() + serializedSize;
            FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(buf);
            int len2 = sections.length;
            for (int i = 0; i < len2; ++i) {
                sections[i].write(friendlyBuf, null, 0);
            }
            if (buf.writerIndex() != expectedWriterIndex) {
                throw new IllegalStateException("Expected writer index to be at " + expectedWriterIndex + ", got " + buf.writerIndex());
            }
        }
        VarInt.write((ByteBuf)buf, (int)0);
        LightWriter.writeLightData(buf, blockLight, skyLight);
    }

    private static void writeSection(FriendlyByteBuf buf, LevelChunkSection section, AntiXrayProcessor antiXray, int sectionY) {
        try {
            buf.writeShort((int)GET_NON_EMPTY_BLOCK_COUNT.invoke(section));
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
        int preReaderIndex = buf.readerIndex();
        int preWriterIndex = buf.writerIndex();
        section.states.write(buf, null, 0);
        buf.readerIndex(preWriterIndex);
        antiXray.process((ByteBuf)buf, sectionY, true);
        buf.readerIndex(preReaderIndex);
        section.getBiomes().write(buf, null, 0);
    }
}

