/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.nms.v1213;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.util.ChunkSystem;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import dev.booky.betterview.common.BetterViewManager;
import dev.booky.betterview.common.BetterViewPlayer;
import dev.booky.betterview.common.antixray.AntiXrayProcessor;
import dev.booky.betterview.common.antixray.ReplacementPresets;
import dev.booky.betterview.common.config.BvLevelConfig;
import dev.booky.betterview.common.util.ChunkTagResult;
import dev.booky.betterview.common.util.McChunkPos;
import dev.booky.betterview.nms.PaperNmsInterface;
import dev.booky.betterview.nms.v1213.ChunkTagTransformer;
import dev.booky.betterview.nms.v1213.ChunkWriter;
import dev.booky.betterview.nms.v1213.LightWriter;
import dev.booky.betterview.nms.v1213.PacketHandler;
import dev.booky.betterview.nms.v1213.WrappedServerTickManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.papermc.paper.network.ChannelInitializeListenerHolder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class NmsAdapter
implements PaperNmsInterface {
    static final byte FORGET_LEVEL_CHUNK_PACKET_ID = 34;
    static final ByteBuf FORGET_LEVEL_CHUNK_PACKET_ID_BUF = Unpooled.wrappedBuffer((byte[])new byte[]{34});
    static final byte LEVEL_CHUNK_WITH_LIGHT_PACKET_ID = 40;
    static final ByteBuf LEVEL_CHUNK_WITH_LIGHT_PACKET_ID_BUF = Unpooled.wrappedBuffer((byte[])new byte[]{40});

    public NmsAdapter() {
        if (SharedConstants.getProtocolVersion() != 768) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public long getNanosPerServerTick() {
        return MinecraftServer.getServer().tickRateManager().nanosecondsPerTick();
    }

    @Override
    public int getRequestedViewDistance(Player player) {
        return ((CraftPlayer)player).getHandle().requestedViewDistance();
    }

    @Override
    public McChunkPos getChunkPos(Player player) {
        ChunkPos pos = ((CraftPlayer)player).getHandle().chunkPosition();
        return new McChunkPos(pos.x, pos.z);
    }

    @Override
    public Channel getNettyChannel(Player player) {
        return ((CraftPlayer)player).getHandle().connection.connection.channel;
    }

    @Override
    public boolean isInjected(Channel channel) {
        return channel.pipeline().names().contains("betterview_handler");
    }

    @Override
    public boolean isFakeChannel(Channel channel) {
        if (channel instanceof EmbeddedChannel) {
            return true;
        }
        String name = channel.getClass().getSimpleName();
        return "FakeChannel".equals(name) || "SpoofedChannel".equals(name);
    }

    @Override
    public Object constructClientboundSetChunkCacheRadiusPacket(int distance) {
        return new ClientboundSetChunkCacheRadiusPacket(distance);
    }

    @Override
    public ByteBuf getClientboundForgetLevelChunkPacketId() {
        return FORGET_LEVEL_CHUNK_PACKET_ID_BUF.retainedSlice();
    }

    @Override
    public ByteBuf getClientboundLevelChunkWithLightPacketId() {
        return LEVEL_CHUNK_WITH_LIGHT_PACKET_ID_BUF.retainedSlice();
    }

    @Override
    public CompletableFuture<@Nullable ByteBuf> getLoadedChunkBuf(World world, @Nullable AntiXrayProcessor antiXray, McChunkPos chunkPos) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        NewChunkHolder holder = level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos.getKey());
        if (holder == null) {
            return CompletableFuture.completedFuture(null);
        }
        ChunkAccess access = holder.getChunkIfPresent(ChunkStatus.LIGHT);
        if (access == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> ChunkWriter.writeFullOrEmpty(access, antiXray));
    }

    @Override
    public CompletableFuture<@Nullable ChunkTagResult> readChunkTag(World world, @Nullable AntiXrayProcessor antiXray, McChunkPos chunkPos) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        ChunkPos nmsPos = new ChunkPos(chunkPos.getX(), chunkPos.getZ());
        return level.chunkSource.chunkMap.read(nmsPos).thenApplyAsync(tag -> {
            if (tag.isEmpty()) {
                return null;
            }
            if (!ChunkTagTransformer.isChunkLit((CompoundTag)tag.get())) {
                return ChunkTagResult.EMPTY;
            }
            ByteBuf chunkBuf = ChunkTagTransformer.transformToBytesOrEmpty(level, (CompoundTag)tag.get(), antiXray, nmsPos);
            return new ChunkTagResult(chunkBuf);
        });
    }

    @Override
    public CompletableFuture<ByteBuf> loadChunk(World world, @Nullable AntiXrayProcessor antiXray, int chunkX, int chunkZ) {
        CompletableFuture<ByteBuf> future = new CompletableFuture<ByteBuf>();
        ServerLevel level = ((CraftWorld)world).getHandle();
        ChunkSystem.scheduleChunkLoad((ServerLevel)level, (int)chunkX, (int)chunkZ, (boolean)true, (ChunkStatus)ChunkStatus.LIGHT, (boolean)true, (Priority)Priority.LOW, chunk -> future.completeAsync(() -> ChunkWriter.writeFullOrEmpty(chunk, antiXray)));
        return future;
    }

    @Override
    public boolean checkVoidWorld(World world) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        ChunkGenerator chunkGenerator = level.chunkSource.getGenerator();
        if (chunkGenerator instanceof FlatLevelSource) {
            FlatLevelSource flat = (FlatLevelSource)chunkGenerator;
            return flat.settings().getLayers().stream().noneMatch(state -> state != null && !state.isAir());
        }
        return false;
    }

    @Override
    public Object getDimensionId(World world) {
        return ((CraftWorld)world).getHandle().dimension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf buildEmptyChunkData(World world, @Nullable AntiXrayProcessor antiXray) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        Registry biomeRegistry = level.registryAccess().lookupOrThrow(Registries.BIOME);
        Holder.Reference biome = biomeRegistry.getOrThrow(Biomes.THE_VOID);
        EmptyLevelChunk chunk = new EmptyLevelChunk((Level)level, ChunkPos.ZERO, (Holder)biome);
        ByteBuf buf = Unpooled.buffer();
        try {
            CompoundTag heightmapsTag = ChunkWriter.extractHeightmapsTag((ChunkAccess)chunk);
            byte[][] blockLight = LightWriter.convertStarlightToBytes(chunk.starlight$getBlockNibbles(), false);
            byte[][] skyLight = LightWriter.convertStarlightToBytes(chunk.starlight$getSkyNibbles(), true);
            ChunkWriter.writeFullBody(buf, antiXray, chunk.getMinSectionY(), heightmapsTag, chunk.getSections(), blockLight, skyLight);
            ByteBuf byteBuf = buf.retain();
            return byteBuf;
        }
        finally {
            buf.release();
        }
    }

    @Override
    public void injectPacketHandler(BetterViewManager manager, NamespacedKey listenerKey) {
        ChannelInitializeListenerHolder.addListener((Key)listenerKey, channel -> channel.pipeline().addBefore("packet_handler", "betterview_handler", (ChannelHandler)new PacketHandler()));
        MinecraftServer server = MinecraftServer.getServer();
        for (Connection connection : server.getConnection().getConnections()) {
            connection.channel.pipeline().addBefore("packet_handler", "betterview_handler", (ChannelHandler)new PacketHandler());
        }
        WrappedServerTickManager.inject(server, manager);
    }

    @Override
    public void uninjectPacketHandler(NamespacedKey listenerKey) {
        ChannelInitializeListenerHolder.removeListener((Key)listenerKey);
        MinecraftServer server = MinecraftServer.getServer();
        for (Connection connection : server.getConnection().getConnections()) {
            connection.channel.eventLoop().execute(() -> {
                if (connection.channel.isActive()) {
                    connection.channel.pipeline().remove("betterview_handler");
                }
            });
        }
        WrappedServerTickManager.uninject(server);
    }

    @Override
    public void saveNetworkPlayer(Channel channel, BetterViewPlayer bvPlayer) {
        PacketHandler handler = (PacketHandler)channel.pipeline().get("betterview_handler");
        if (handler == null) {
            throw new IllegalStateException("Can't save network player to " + String.valueOf(channel) + ", no handler found");
        }
        handler.setPlayer(bvPlayer);
    }

    @Override
    public @Nullable AntiXrayProcessor createAntiXray(World world, BvLevelConfig.AntiXrayConfig config) {
        Function<Block, Integer> stateId = block -> Block.BLOCK_STATE_REGISTRY.getId((Object)block.defaultBlockState());
        ReplacementPresets levelPresets = switch (world.getEnvironment()) {
            case World.Environment.NETHER -> ReplacementPresets.createStatic(stateId.apply(Blocks.NETHERRACK));
            case World.Environment.THE_END -> ReplacementPresets.createStatic(stateId.apply(Blocks.END_STONE));
            default -> ReplacementPresets.createStaticZeroSplit(new int[]{stateId.apply(Blocks.STONE)}, new int[]{stateId.apply(Blocks.DEEPSLATE)});
        };
        Function<Key, Stream<Integer>> stateListFn = key -> {
            ResourceLocation blockKey = ResourceLocation.fromNamespaceAndPath((String)key.namespace(), (String)key.value());
            return ((Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(blockKey).orElseThrow()).value()).getStateDefinition().getPossibleStates().stream().map(arg_0 -> ((IdMapper)Block.BLOCK_STATE_REGISTRY).getIdOrThrow(arg_0));
        };
        return AntiXrayProcessor.createProcessor(config, levelPresets, stateListFn, Block.BLOCK_STATE_REGISTRY.size());
    }
}

