/*
 * Decompiled with CFR 0.152.
 */
package com.stta.audio;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Recorder {
    private static final float MAX_SHORT = 32768.0f;
    private static final int KIBIBYTE = 1024;
    private static final int SAMPLE_RATE = 16000;
    private static final float H_BYTE = 2.0f;
    private boolean listening;

    public float[] record() throws LineUnavailableException {
        this.listening = true;
        ByteArrayOutputStream recordingStream = new ByteArrayOutputStream();
        AudioFormat wavFormat = new AudioFormat(16000.0f, 16, 1, true, true);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, wavFormat);
        try {
            if (!AudioSystem.isLineSupported(info)) {
                throw new LineUnavailableException("No matching target data line found! Please ensure your system has a microphone.");
            }
            TargetDataLine microphone = (TargetDataLine)AudioSystem.getLine(info);
            microphone.open(wavFormat);
            microphone.start();
            byte[] buf = new byte[1024];
            while (this.listening) {
                int bytesRead = microphone.read(buf, 0, buf.length);
                if (bytesRead <= 0) continue;
                recordingStream.write(buf, 0, bytesRead);
            }
            microphone.stop();
            microphone.close();
            byte[] audioBytes = recordingStream.toByteArray();
            return this.BytesToFloat(audioBytes);
        }
        catch (LineUnavailableException e) {
            this.listening = false;
            throw e;
        }
    }

    public void stopRecording() {
        this.listening = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    private float[] BytesToFloat(byte[] audioBytes) {
        if (audioBytes.length % 4 != 0) {
            throw new RuntimeException("Illegal length");
        }
        ShortBuffer sbuf = ByteBuffer.wrap(audioBytes).asShortBuffer();
        float[] audioFloats = new float[audioBytes.length / 2];
        int i = 0;
        while ((float)i < (float)audioBytes.length / 2.0f) {
            audioFloats[i] = (float)sbuf.get() / 32768.0f;
            ++i;
        }
        return audioFloats;
    }
}

