/*
 * Decompiled with CFR 0.152.
 */
package com.stta.event;

import com.stta.STTAClient;
import com.stta.audio.Recorder;
import com.stta.config.STTAConfig;
import com.stta.gui.STTAHud;
import com.stta.model.ModelManager;
import io.github.givimad.whisperjni.WhisperFullParams;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sound.sampled.LineUnavailableException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EventHandler {
    public static final class_304.class_11900 KEY_CATEGORY_LISTENING = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"stta", (String)"listening"));
    public static final String KEY_HOLD = "key.stta.hold";
    public static class_304 listeningKey;
    private static final ExecutorService inputThread;
    private final ModelManager modelManager;
    private final STTAHud hud;
    private final Recorder recorder;
    private boolean pressed;
    private volatile boolean processing;
    private volatile boolean keyPressedWhileHold = true;

    public EventHandler(ModelManager modelManager, STTAHud hud) {
        this.modelManager = modelManager;
        this.hud = hud;
        this.recorder = new Recorder();
    }

    private void captureSpeech() {
        this.processing = true;
        inputThread.submit(() -> {
            try {
                this.hud.pauseAnimation();
                this.hud.showStatus((class_2561)class_2561.method_43471((String)"msg.stta.recording"));
                float[] audio = this.recorder.record();
                STTAConfig config = STTAConfig.instance();
                WhisperFullParams params = new WhisperFullParams();
                params.language = config.language;
                params.translate = config.translate;
                this.hud.showStatus((class_2561)class_2561.method_43471((String)"msg.stta.processing"));
                String text = this.modelManager.getModel().processSpeech(audio, params);
                this.hud.resumeAnimation();
                this.handleMessage(text);
                this.waitForKeyRelease();
                this.processing = false;
            }
            catch (LineUnavailableException e) {
                STTAClient.LOGGER.error(e.getMessage());
                this.hud.showStatus((class_2561)class_2561.method_43471((String)"msg.stta.no_mic"));
                this.hud.resumeAnimation();
                this.processing = false;
            }
        });
    }

    private void handleMessage(String text) {
        if (text.isEmpty()) {
            this.hud.showStatus((class_2561)class_2561.method_43471((String)"msg.stta.blank"));
            return;
        }
        switch (STTAConfig.instance().inputMode) {
            case Direct: {
                this.sendChatMessage("\ud83d\udd0a" + text);
                break;
            }
            case Delay: {
                this.hud.showStatus((class_2561)class_2561.method_43470((String)text));
                this.hud.pauseAnimation();
                if (!this.waitForHoldCancel()) {
                    this.sendChatMessage("\ud83d\udd0a" + text);
                } else {
                    this.hud.showStatus((class_2561)class_2561.method_43471((String)"msg.stta.canceled"));
                }
                this.hud.resumeAnimation();
                break;
            }
            case Confirm: {
                this.hud.showStatus((class_2561)class_2561.method_43470((String)text));
                this.hud.pauseAnimation();
                if (this.waitForHoldCancel()) {
                    this.sendChatMessage("\ud83d\udd0a" + text);
                } else {
                    this.hud.showStatus((class_2561)class_2561.method_43471((String)"msg.stta.canceled"));
                }
                this.hud.resumeAnimation();
                break;
            }
            case Draft: {
                class_310 instance = class_310.method_1551();
                instance.execute(() -> instance.method_1507((class_437)new class_408(text, false)));
            }
        }
    }

    private void sendChatMessage(String msg) {
        class_310.method_1551().execute(() -> {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                int MAX_LENGTH = 256;
                int msgLength = msg.length();
                for (int i = 0; i < msgLength; i += 256) {
                    int end = Math.min(msgLength, i + 256);
                    String part = msg.substring(i, end);
                    client.field_1724.field_3944.method_45729(part);
                }
            }
        });
    }

    private boolean waitForHoldCancel() {
        long startTime = System.currentTimeMillis();
        this.keyPressedWhileHold = false;
        while (!this.keyPressedWhileHold) {
            if ((float)(System.currentTimeMillis() - startTime) > STTAConfig.instance().delay * 1000.0f) {
                this.keyPressedWhileHold = true;
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return true;
    }

    private void waitForKeyRelease() {
        while (listeningKey.method_1434()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                STTAClient.LOGGER.info("Interrupted while waiting for key release!");
            }
        }
    }

    public void registerKeyInputs() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                if (listeningKey.method_1434() && !this.pressed) {
                    this.pressed = true;
                    if (!this.keyPressedWhileHold) {
                        this.keyPressedWhileHold = true;
                    } else if (this.modelManager.isWhisperReady() && !this.processing) {
                        this.captureSpeech();
                    } else {
                        this.hud.showStatus((class_2561)class_2561.method_43471((String)"msg.stta.no_init"));
                    }
                } else if (!listeningKey.method_1434() && this.pressed) {
                    this.pressed = false;
                    if (this.recorder.isListening()) {
                        this.recorder.stopRecording();
                    }
                }
            }
        });
    }

    public void register() {
        listeningKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304(KEY_HOLD, class_3675.class_307.field_1668, 86, KEY_CATEGORY_LISTENING));
        this.registerKeyInputs();
    }

    static {
        inputThread = Executors.newSingleThreadExecutor();
    }
}

