/*
 * Decompiled with CFR 0.152.
 */
package com.stta.model;

import com.stta.STTAClient;
import com.stta.model.DownloadCallback;
import com.stta.model.ModelListUpdateCallback;
import com.stta.model.WhisperHash;
import com.stta.model.WhisperModel;
import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperJNI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ModelManager {
    private static ModelManager instance;
    private static final int DOWNLOAD_BUFFER_SIZE = 4096;
    private static final String MODEL_URL = "https://huggingface.co/ggerganov/whisper.cpp/resolve/main/";
    private static final Path MODEL_DIR;
    private static final Path MODEL_DIR_PATH;
    private final ExecutorService downloadThread = Executors.newSingleThreadExecutor();
    private final ExecutorService listenThread = Executors.newSingleThreadExecutor();
    private final List<ModelListUpdateCallback> listeners = new CopyOnWriteArrayList<ModelListUpdateCallback>();
    private WhisperJNI whisper;
    private WhisperContext context;

    public ModelManager() {
        this.loadWhisperLibrary();
        this.ensureDirExists();
        this.listenToDirChanges();
    }

    public static ModelManager getInstance() {
        if (instance == null) {
            instance = new ModelManager();
        }
        return instance;
    }

    private void loadWhisperLibrary() {
        try {
            WhisperJNI.loadLibrary();
            this.whisper = new WhisperJNI();
        }
        catch (IOException loadFailure) {
            STTAClient.LOGGER.error("Runtime error occurred while trying to load Whisper library: ", (Throwable)loadFailure);
        }
    }

    public void loadModel(String modelName) {
        if (this.context != null) {
            this.context.close();
        }
        this.context = null;
        try {
            this.context = this.whisper.init(this.getModelPath(modelName));
            STTAClient.LOGGER.info("Whisper.cpp model {} is now initialized.", (Object)modelName);
        }
        catch (IOException noModel) {
            STTAClient.LOGGER.warn("No model is available under the name {}", (Object)modelName);
            this.context = null;
        }
    }

    public WhisperModel getModel() {
        if (this.isWhisperReady()) {
            return new WhisperModel(this.whisper, this.context);
        }
        throw new IllegalStateException("Whisper not ready!");
    }

    public boolean isWhisperReady() {
        return this.context != null && this.whisper != null;
    }

    public List<String> getModelList() {
        String[] files;
        List<String> filenames = new ArrayList<String>();
        File pathToModelDirFile = MODEL_DIR_PATH.toFile();
        if (pathToModelDirFile.exists() && pathToModelDirFile.isDirectory() && (files = pathToModelDirFile.list()) != null) {
            filenames = Arrays.asList(files);
        }
        return filenames;
    }

    private void ensureDirExists() {
        try {
            if (Files.notExists(MODEL_DIR_PATH, new LinkOption[0])) {
                Files.createDirectory(MODEL_DIR_PATH, new FileAttribute[0]);
                STTAClient.LOGGER.info("Directory created: {}", (Object)MODEL_DIR_PATH);
            } else {
                if (!Files.isDirectory(MODEL_DIR_PATH, new LinkOption[0])) {
                    STTAClient.LOGGER.error("Path {} exists but is not a directory", (Object)MODEL_DIR_PATH);
                    throw new RuntimeException("Path exists but is not a directory: " + String.valueOf(MODEL_DIR_PATH));
                }
                STTAClient.LOGGER.info("Directory already exists: {}", (Object)MODEL_DIR_PATH);
            }
        }
        catch (IOException | SecurityException | UnsupportedOperationException fileIOError) {
            STTAClient.LOGGER.error("Failed to create directory {}", (Object)MODEL_DIR, (Object)fileIOError);
            throw new RuntimeException(fileIOError);
        }
    }

    private Path getModelPath(String modelName) {
        return Path.of(MODEL_DIR_PATH.toString(), modelName);
    }

    public void download(String modelName, DownloadCallback callback) {
        if (Files.exists(Path.of(MODEL_DIR_PATH.toString(), modelName), new LinkOption[0])) {
            STTAClient.LOGGER.error("Model {} already exists!", (Object)modelName);
            callback.onAlreadyExists(modelName);
            return;
        }
        this.downloadThread.submit(() -> {
            try {
                int bytesRead;
                STTAClient.LOGGER.info("Downloading {}...", (Object)modelName);
                URL url = URI.create(MODEL_URL + modelName).toURL();
                InputStream urlStream = url.openStream();
                File tmpOutputFile = Path.of(System.getProperty("java.io.tmpdir"), modelName).toFile();
                FileOutputStream fileOutputStream = new FileOutputStream(tmpOutputFile);
                FileChannel fileChannel = fileOutputStream.getChannel();
                long totalBytes = url.openConnection().getContentLengthLong();
                long bytesTransferred = 0L;
                int bufferSize = 4096;
                byte[] buffer = new byte[bufferSize];
                while ((bytesRead = urlStream.read(buffer, 0, bufferSize)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                    int progress = (int)((bytesTransferred += (long)bytesRead) * 100L / totalBytes);
                    callback.onProgress(modelName, progress);
                }
                fileChannel.close();
                fileOutputStream.close();
                urlStream.close();
                if (!WhisperHash.checkWhisperHash(tmpOutputFile)) {
                    STTAClient.LOGGER.error("File {} does not pass the check, deleting it... ", (Object)tmpOutputFile);
                    tmpOutputFile.delete();
                    callback.onFailure(modelName, new SignatureException("The file doesn't match any signature!"));
                } else {
                    Files.copy(tmpOutputFile.toPath(), Path.of(MODEL_DIR_PATH.toString(), modelName), new CopyOption[0]);
                    tmpOutputFile.delete();
                    STTAClient.LOGGER.info("Finished downloading {}!", (Object)modelName);
                    callback.onCompletion(modelName);
                }
            }
            catch (IOException | IllegalArgumentException | IndexOutOfBoundsException | NullPointerException downloadError) {
                STTAClient.LOGGER.error("Failed to download {}: ", (Object)modelName, (Object)downloadError);
                callback.onFailure(modelName, downloadError);
            }
        });
    }

    public void addModelListUpdateListener(ModelListUpdateCallback callback) {
        this.listeners.add(callback);
    }

    public void removeModelListUpdateListener(ModelListUpdateCallback callback) {
        this.listeners.remove(callback);
    }

    private void listenToDirChanges() {
        this.listenThread.submit(() -> {
            try {
                WatchService watchService = FileSystems.getDefault().newWatchService();
                MODEL_DIR_PATH.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        WatchKey key = watchService.take();
                        List<WatchEvent<?>> keyList = key.pollEvents();
                        if (!keyList.isEmpty()) {
                            for (ModelListUpdateCallback listener : this.listeners) {
                                listener.onModelListChange();
                            }
                        }
                        key.reset();
                    }
                    catch (InterruptedException e) {
                        STTAClient.LOGGER.info("Directory listener thread interrupted, quitting!");
                    }
                }
            }
            catch (IOException | ClosedWatchServiceException watchError) {
                STTAClient.LOGGER.error("Failed to watch {} for chnages!", (Object)MODEL_DIR, (Object)watchError);
                throw new RuntimeException(watchError);
            }
        });
    }

    static {
        MODEL_DIR = Path.of(".stta-models", new String[0]);
        MODEL_DIR_PATH = Path.of(FabricLoader.getInstance().getGameDir().toString(), MODEL_DIR.toString());
    }
}

